/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.role;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbRoleImpl;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.JavaeeIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EjbClassRoleImpl
extends EjbRoleImpl
implements EjbClassRole {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.ejb.role.EjbClassRole");
    public static final EjbClassRoleImpl[] EMPTY_ARRAY = new EjbClassRoleImpl[0];
    public static final EjbClassRoleImpl EMPTY_ROLE = new EjbClassRoleImpl(EjbClassRoleEnum.EMPTY_ROLE, (EnterpriseBean)null, null);
    private final EjbClassRoleEnum myType;
    private final EjbFacet myFacet;
    private Interceptor myInterceptor;

    public EjbClassRoleImpl(EjbClassRoleEnum type, EnterpriseBean ejb, EjbFacet facet) {
        super(ejb);
        this.myFacet = facet;
        this.myType = type;
    }

    public EjbClassRoleImpl(EjbClassRoleEnum type, Interceptor interceptor, EjbFacet facet) {
        super(null);
        this.myInterceptor = interceptor;
        this.myType = type;
        this.myFacet = facet;
    }

    public Module getModule() {
        return this.myFacet.getModule();
    }

    public EjbFacet getFacet() {
        return this.myFacet;
    }

    public final EjbClassRoleEnum getType() {
        return this.myType;
    }

    public Interceptor getInterceptor() {
        return this.myInterceptor;
    }

    public EjbMethodRoleImpl getMethodRole(PsiMethod method) {
        EjbMethodRoleImpl role = EjbMethodRoleImpl.suggestMethodRole(this, method);
        if (role != null && !(role.getEnterpriseBean() instanceof MessageDrivenBean) && !role.checkPairingMethods()) {
            role = null;
        }
        return role;
    }

    public boolean isDeclarationRole() {
        return this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE || this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE || this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE || this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE || this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE || this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE || this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE;
    }

    public PsiClass[] findImplementations() {
        PsiClass[] psiClassArray;
        LOG.assertTrue(this.isDeclarationRole());
        EnterpriseBean ejb = this.getEnterpriseBean();
        if (ejb == null || this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE || this.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE) {
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass ejbClass = (PsiClass)ejb.getEjbClass().getValue();
        if (ejbClass != null) {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = ejbClass;
        } else {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        }
        return psiClassArray;
    }

    public String getTitle() {
        return EjbClassRoleImpl.getClassRoleTitle(this.getType());
    }

    public boolean isRemote() {
        return this.getType().isRemote();
    }

    public String toString() {
        if (this.getEnterpriseBean() != null) {
            return J2EEBundle.message((String)"role.for.ejb.name.string.representation", (Object[])new Object[]{this.getTitle(), this.getEnterpriseBean().getEjbName().getValue()});
        }
        if (this.getInterceptor() != null) {
            return J2EEBundle.message((String)"role.for.interceptor.name.string.representation", (Object[])new Object[]{this.getTitle(), this.getInterceptor().getInterceptorClass().getStringValue()});
        }
        return super.toString();
    }

    public Icon getIcon() {
        return EjbClassRoleImpl.getClassRoleIcon(this.getType());
    }

    public static Icon getClassRoleIcon(@NotNull EjbClassRoleEnum roleEnum) {
        if (roleEnum == null) {
            EjbClassRoleImpl.$$$reportNull$$$0(0);
        }
        switch (roleEnum) {
            case EJB_CLASS_ROLE_EJB_CLASS: {
                return JavaeeIcons.EJB_CLASS_ICON;
            }
            case EJB_CLASS_ROLE_REMOTE_INTERFACE: {
                return JavaeeIcons.EJB_REMOTE_INTERFACE_ICON;
            }
            case EJB_CLASS_ROLE_HOME_INTERFACE: {
                return JavaeeIcons.EJB_HOME_INTERFACE_ICON;
            }
            case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: {
                return JavaeeIcons.EJB_LOCAL_HOME_INTERFACE_ICON;
            }
            case EJB_CLASS_ROLE_LOCAL_INTERFACE: {
                return JavaeeIcons.EJB_LOCAL_INTERFACE_ICON;
            }
            case EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE: {
                return JavaeeIcons.EJB_LOCAL_INTERFACE_ICON;
            }
            case EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE: {
                return JavaeeIcons.EJB_REMOTE_INTERFACE_ICON;
            }
            case EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE: {
                return JavaeeIcons.EJB_REMOTE_INTERFACE_ICON;
            }
            case EJB_CLASS_ROLE_INTERCEPTOR_CLASS: {
                return JavaeeIcons.EJB_INTERCEPTOR_CLASS_ICON;
            }
        }
        return null;
    }

    public static String getClassRoleTitle(EjbClassRoleEnum roleEnum) {
        String desc;
        switch (roleEnum) {
            case EJB_CLASS_ROLE_EJB_CLASS: {
                desc = J2EEBundle.message((String)"class.role.ejb.class", (Object[])new Object[0]);
                break;
            }
            case EJB_CLASS_ROLE_HOME_INTERFACE: {
                desc = J2EEBundle.message((String)"class.role.home.interface", (Object[])new Object[0]);
                break;
            }
            case EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE: {
                desc = J2EEBundle.message((String)"class.role.local.home.interface", (Object[])new Object[0]);
                break;
            }
            case EJB_CLASS_ROLE_LOCAL_INTERFACE: {
                desc = J2EEBundle.message((String)"class.role.local.interface", (Object[])new Object[0]);
                break;
            }
            case EJB_CLASS_ROLE_REMOTE_INTERFACE: {
                desc = J2EEBundle.message((String)"class.role.remote.interface", (Object[])new Object[0]);
                break;
            }
            case EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE: {
                desc = J2EEBundle.message((String)"class.role.business.local.interface", (Object[])new Object[0]);
                break;
            }
            case EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE: {
                desc = J2EEBundle.message((String)"class.role.business.remote.interface", (Object[])new Object[0]);
                break;
            }
            case EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE: {
                desc = J2EEBundle.message((String)"class.role.service.endpoint.interface", (Object[])new Object[0]);
                break;
            }
            case EJB_CLASS_ROLE_INTERCEPTOR_CLASS: {
                desc = J2EEBundle.message((String)"class.role.interceptor.class", (Object[])new Object[0]);
                break;
            }
            default: {
                desc = J2EEBundle.message((String)"class.role.unknown.ejb.class", (Object[])new Object[0]);
            }
        }
        return desc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roleEnum", "com/intellij/javaee/ejb/role/EjbClassRoleImpl", "getClassRoleIcon"));
    }
}

