/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.annotator;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.navigation.JamNavigationGutterIconBuilder;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.annotations.ejb.JavaeeReferenceImpl;
import com.intellij.javaee.model.common.EjbReference;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.JavaeeReference;
import com.intellij.javaee.model.common.Resource;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.xml.ejb.Query;
import com.intellij.javaee.model.xml.impl.EjbXmlImplUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EjbClassLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final Comparator<EnterpriseBean> EJB_COMPARATOR = (o1, o2) -> Comparing.compare((Comparable)((Comparable)o1.getEjbName().getValue()), (Comparable)((Comparable)o2.getEjbName().getValue()));

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            EjbClassLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            EjbClassLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiIdentifier)) {
            return;
        }
        PsiElement psiElement = element.getParent();
        if (!(psiElement instanceof PsiField || psiElement instanceof PsiMethod || psiElement instanceof PsiAnnotation)) {
            return;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            return;
        }
        EjbDescriptorVersion maxVersion = EjbUtil.getMaxEjbVersion(psiClass);
        if (maxVersion == null) {
            return;
        }
        if (EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)maxVersion) <= 0) {
            EjbClassLineMarkerProvider.annotateEjbAndResourcesReferences(psiElement, (PsiIdentifier)element, result);
        }
        if (EjbDescriptorVersion.EJB_VERSION_2_0.compareTo((Enum)maxVersion) <= 0) {
            EjbClassLineMarkerProvider.annotateQLFindersAndSelectors(psiElement, result);
        }
        EjbClassLineMarkerProvider.annotateFieldAccessors(psiElement, result);
    }

    private static void annotateFieldAccessors(PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> holder) {
        if (psiElement instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            EjbClassLineMarkerProvider.addJavaeeFieldGutterIcon(holder, method, JavaeeIcons.EJB_CMP_FIELD_ICON, (JavaeeModelElement)EjbUtil.getCmpField((PsiElement)method));
            EjbClassLineMarkerProvider.addJavaeeFieldGutterIcon(holder, method, JavaeeIcons.EJB_CMR_FIELD_ICON, (JavaeeModelElement)EjbUtil.getCmrField((PsiElement)method));
        }
    }

    private static void addJavaeeFieldGutterIcon(Collection<? super RelatedItemLineMarkerInfo> holder, PsiMethod method, Icon icon, JavaeeModelElement field) {
        if (field != null) {
            holder.add((RelatedItemLineMarkerInfo)NavigationGutterIconBuilder.create((Icon)icon).setTooltipText(EjbHighlightingMessages.message("ejb.field.popup.tooltip.navigate.to.field.declaration", new Object[0])).setTarget((Object)field.getIdentifyingPsiElement()).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo((PsiElement)method.getNameIdentifier()));
        }
    }

    private static void annotateQLFindersAndSelectors(PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> holder) {
        if (!(psiElement instanceof PsiMethod)) {
            return;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (!EjbClassLineMarkerProvider.getMethodQueries(psiMethod, true).isEmpty()) {
            holder.add((RelatedItemLineMarkerInfo)JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)JavaeeIcons.EJBQL_METHOD_GUTTER_ICON, Query.class).setTooltipTitle(EjbHighlightingMessages.message("text.queries", new Object[0])).setNamer(query -> (String)query.getEjbQl().getValue()).setPopupTitle(EjbHighlightingMessages.message("ejb.references.popup.title.choose.query", new Object[0])).setTargets(EjbClassLineMarkerProvider.getMethodQueries(psiMethod, false)).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo((PsiElement)psiMethod.getNameIdentifier()));
        }
    }

    private static void annotateEjbAndResourcesReferences(PsiElement psiElement, PsiIdentifier identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiElement instanceof PsiField || psiElement instanceof PsiMethod) {
            PsiMember psiMember = (PsiMember)psiElement;
            JavaeeReference[] javaeeReferences = OldEjbRolesUtil.getInjectedReferences(psiMember);
            if (javaeeReferences.length > 0) {
                ArrayList<Resource> resList = new ArrayList<Resource>();
                ArrayList<EjbReference> ejbList = new ArrayList<EjbReference>();
                for (JavaeeReference reference : javaeeReferences) {
                    DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)reference, DomElement.class);
                    if (domElement == null) continue;
                    if (reference instanceof EjbReference) {
                        ejbList.add((EjbReference)reference);
                    }
                    if (!(reference instanceof Resource)) continue;
                    resList.add((Resource)reference);
                }
                if (!ejbList.isEmpty()) {
                    THashSet set = new THashSet();
                    for (EjbReference ejbReference : ejbList) {
                        EnterpriseBean ejb = (EnterpriseBean)ejbReference.getEjbLink().getValue();
                        if (ejb == null) continue;
                        set.add((Object)ejb);
                    }
                    EjbClassLineMarkerProvider.createEjbGutterIconRenderer(result, (PsiElement)identifier, (THashSet<EnterpriseBean>)set);
                }
                if (!resList.isEmpty()) {
                    EjbClassLineMarkerProvider.createResourceGutterIconRenderer(result, (PsiElement)identifier, resList);
                }
            }
        } else if (psiElement instanceof PsiAnnotation) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)psiElement;
            PsiAnnotation psiParentAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiAnnotation.class);
            PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMember.class);
            if (psiParentAnnotation == null && psiMember != null) {
                String annotationName = psiAnnotation.getQualifiedName();
                if ("javax.ejb.EJB".equals(annotationName) || "javax.ejb.EJBs".equals(annotationName)) {
                    THashSet set = new THashSet();
                    EjbClassLineMarkerProvider.getEnterpriseBeans(psiAnnotation, psiMember, (Set<EnterpriseBean>)set);
                    EjbClassLineMarkerProvider.createEjbGutterIconRenderer(result, (PsiElement)identifier, (THashSet<EnterpriseBean>)set);
                } else if ("javax.annotation.Resource".equals(annotationName) || "javax.annotation.Resources".equals(annotationName)) {
                    JavaeeReference[] javaeeReferences = OldEjbRolesUtil.getInjectedReferences(psiMember);
                    HashSet<Resource> set = new HashSet<Resource>();
                    for (PsiAnnotation annotation : AnnotationModelUtil.getAnnotationsValueIncludingSingle((PsiModifierListOwner)psiMember, "javax.annotation.Resources", "javax.annotation.Resource")) {
                        for (JavaeeReference javaeeReference : javaeeReferences) {
                            JavaeeReferenceImpl annoElement;
                            if (!(javaeeReference instanceof Resource) || (annoElement = (JavaeeReferenceImpl)((Object)ModelMergerUtil.getImplementation((Object)javaeeReference, JavaeeReferenceImpl.class))) == null || annoElement.getAnnotationRef().getPsiElement() != annotation) continue;
                            set.add((Resource)javaeeReference);
                        }
                    }
                    EjbClassLineMarkerProvider.createResourceGutterIconRenderer(result, (PsiElement)identifier, set);
                }
            }
        }
    }

    private static void createResourceGutterIconRenderer(Collection<? super RelatedItemLineMarkerInfo> holder, PsiElement psiAnchor, Collection<Resource> resList) {
        holder.add((RelatedItemLineMarkerInfo)JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)JavaeeIcons.EJB_JAR, Resource.class).setTooltipTitle(EjbHighlightingMessages.message("text.references", new Object[0])).setPopupTitle(EjbHighlightingMessages.message("ejb.references.popup.title.choose.resource", new Object[0])).setAlignment(GutterIconRenderer.Alignment.RIGHT).setTargets(resList).createLineMarkerInfo(psiAnchor));
    }

    private static void createEjbGutterIconRenderer(Collection<? super RelatedItemLineMarkerInfo> holder, PsiElement psiAnchor, THashSet<EnterpriseBean> set) {
        TreeSet<EnterpriseBean> treeSet = new TreeSet<EnterpriseBean>(EJB_COMPARATOR);
        treeSet.addAll((Collection<EnterpriseBean>)set);
        holder.add((RelatedItemLineMarkerInfo)JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)JavaeeIcons.EJB_REFERENCE, EnterpriseBean.class).setTooltipTitle(EjbHighlightingMessages.message("text.references", new Object[0])).setPopupTitle(EjbHighlightingMessages.message("ejb.references.popup.title.choose.ejb.class", new Object[0])).setTargets(treeSet).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(psiAnchor));
    }

    private static List<Query> getMethodQueries(PsiMethod psiMethod, boolean first) {
        ArrayList<Query> list = new ArrayList<Query>();
        block0: for (EjbMethodRole role : OldEjbRolesUtil.getEjbRoles(psiMethod)) {
            com.intellij.javaee.model.xml.ejb.EntityBean entity;
            if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL && role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_SELECTOR_IMPL || !EjbUtil.isCMP(role.getEnterpriseBean(), CmpVersion.CmpVersion_2_X) || (entity = (com.intellij.javaee.model.xml.ejb.EntityBean)ModelMergerUtil.getImplementation((Object)role.getEnterpriseBean(), com.intellij.javaee.model.xml.ejb.EntityBean.class)) == null) continue;
            for (Query query : entity.getQueries()) {
                if (!Arrays.asList(EjbXmlImplUtil.findMethods((EntityBean)entity, query.getQueryMethod())).contains(psiMethod)) continue;
                list.add(query);
                if (!first) continue;
                break block0;
            }
        }
        return list;
    }

    private static Set<EnterpriseBean> getEnterpriseBeans(PsiAnnotation psiAnnotation, PsiMember psiMember, Set<EnterpriseBean> result) {
        if ("javax.ejb.EJB".equals(psiAnnotation.getQualifiedName())) {
            AnnotationGenericValue<String> beanNameValue = AnnotationModelUtil.getObjectValue(psiAnnotation, "beanName", String.class);
            AnnotationGenericValue<PsiClass> beanInterfaceValue = AnnotationModelUtil.getPsiClassValue(psiAnnotation, "beanInterface", AnnotationModelUtil.getPsiMemberType(psiMember));
            PsiClass beanInterface = (PsiClass)beanInterfaceValue.getValue();
            String beanName = (String)beanNameValue.getValue();
            result.addAll(EjbUtil.findEjbsByLink(JavaeeFacetUtil.getInstance().getJavaeeFacet((PsiElement)psiMember, EjbFacet.ID), beanInterface, beanName));
        } else if ("javax.ejb.EJBs".equals(psiAnnotation.getQualifiedName())) {
            for (PsiAnnotation annotation : AnnotationModelUtil.getAnnotationsValue(psiAnnotation, "value", "javax.ejb.EJB")) {
                EjbClassLineMarkerProvider.getEnterpriseBeans(annotation, psiMember, result);
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/annotator/EjbClassLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

