/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatContexts;
import org.jetbrains.idea.tomcat.TomcatModuleDeploymentModel;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;
import org.jetbrains.idea.tomcat.server.TomcatServerModel;

public class TomcatDeploymentSettingsEditor
extends SettingsEditor<DeploymentModel> {
    private JPanel myPanel;
    private JComboBox<String> myContextPath;
    private JPanel myInnerPanel;
    private boolean myEEArtifact = false;

    public TomcatDeploymentSettingsEditor(CommonModel configuration, DeploymentSource source) {
        super(() -> new TomcatModuleDeploymentModel(configuration, source));
        this.$$$setupUI$$$();
    }

    public void resetEditorFrom(@NotNull DeploymentModel settings) {
        if (settings == null) {
            TomcatDeploymentSettingsEditor.$$$reportNull$$$0(0);
        }
        TomcatModuleDeploymentModel deploymentModel = (TomcatModuleDeploymentModel)settings;
        this.myEEArtifact = deploymentModel.isEEArtifact();
        this.myInnerPanel.setVisible(!this.myEEArtifact);
        if (this.myEEArtifact) {
            return;
        }
        TomcatServerModel configuration = (TomcatServerModel)settings.getServerModel();
        if (configuration instanceof TomcatLocalModel) {
            this.updateContextPaths((TomcatLocalModel)configuration);
        }
        this.setSelectedContextPath(deploymentModel.CONTEXT_PATH);
    }

    public void applyEditorTo(@NotNull DeploymentModel settings) {
        if (settings == null) {
            TomcatDeploymentSettingsEditor.$$$reportNull$$$0(1);
        }
        if (this.myEEArtifact) {
            return;
        }
        ((TomcatModuleDeploymentModel)settings).CONTEXT_PATH = this.getSelectedContextPath();
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TomcatDeploymentSettingsEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private String getSelectedContextPath() {
        String item = (String)this.myContextPath.getEditor().getItem();
        return item != null ? item.trim() : "";
    }

    private void setSelectedContextPath(String contextPath) {
        int itemCount = this.myContextPath.getItemCount();
        for (int idx = 0; idx < itemCount; ++idx) {
            if (!contextPath.equals(this.myContextPath.getItemAt(idx))) continue;
            this.myContextPath.setSelectedIndex(idx);
            return;
        }
        this.myContextPath.addItem(contextPath);
        this.myContextPath.setSelectedItem(contextPath);
    }

    private void updateContextPaths(TomcatLocalModel configuration) {
        String selectedContextPath = this.getSelectedContextPath();
        this.myContextPath.removeAllItems();
        try {
            TomcatContexts tomcatContexts = new TomcatContexts(configuration, configuration.getSourceBaseDirectoryPath());
            for (String path : tomcatContexts.getContextPaths()) {
                this.myContextPath.addItem(path);
            }
        }
        catch (ExecutionException | RuntimeConfigurationException throwable) {
            // empty catch block
        }
        this.setSelectedContextPath(selectedContextPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/tomcat/TomcatDeploymentSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/tomcat/TomcatDeploymentSettingsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInnerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/tomcat/TomcatBundle").getString("label.deployment.configurable.application.context"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myContextPath = jComboBox;
        jComboBox.setEditable(true);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

