/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.formatter.Formatter;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleLocation;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatterUtil;

public class CucumberJvm2SMFormatter
implements Formatter {
    private static final String EXAMPLES_CAPTION = "Examples:";
    private static final String SCENARIO_OUTLINE_CAPTION = "Scenario: Line: ";
    private final Map<String, String> pathToDescription = new HashMap<String, String>();
    private String currentFilePath;
    private int currentScenarioOutlineLine;
    private String currentScenarioOutlineName;
    private final PrintStream myOut;
    private final String myCurrentTimeValue;
    private final EventHandler<TestCaseStarted> testCaseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            CucumberJvm2SMFormatter.this.handleTestCaseStarted(event);
        }
    };
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            CucumberJvm2SMFormatter.this.handleTestCaseFinished(event);
        }
    };
    private final EventHandler<TestRunFinished> testRunFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            CucumberJvm2SMFormatter.this.handleTestRunFinished(event);
        }
    };
    private final EventHandler<TestStepStarted> testStepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            CucumberJvm2SMFormatter.this.handleTestStepStarted(event);
        }
    };
    private final EventHandler<TestStepFinished> testStepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            CucumberJvm2SMFormatter.this.handleTestStepFinished(event);
        }
    };
    private final EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            CucumberJvm2SMFormatter.this.handleTestSourceRead(event);
        }
    };

    public CucumberJvm2SMFormatter() {
        this(System.out, null);
    }

    public CucumberJvm2SMFormatter(PrintStream out, String currentTimeValue) {
        this.myOut = out;
        this.myCurrentTimeValue = currentTimeValue;
        this.outCommand(String.format("##teamcity[enteredTheMatrix timestamp = '%s']", this.getCurrentTime()));
        this.outCommand(String.format("##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '%s' timestamp = '%s']", 0, this.getCurrentTime()));
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.testRunFinishedHandler);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFilePath == null) {
            this.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.getEventUri(event)), CucumberJvmSMFormatterUtil.escape(this.getFeatureFileDescription(this.getEventUri(event)))));
        } else if (!this.getEventUri(event).equals(this.currentFilePath)) {
            this.closeCurrentScenarioOutline();
            this.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.getFeatureFileDescription(this.currentFilePath))));
            this.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.getEventUri(event)), CucumberJvmSMFormatterUtil.escape(this.getFeatureFileDescription(this.getEventUri(event)))));
        }
        this.outCommand(String.format("##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']", this.getCurrentTime()));
        if (CucumberJvm2SMFormatter.isScenarioOutline(event.testCase)) {
            int mainScenarioLine = CucumberJvm2SMFormatter.getScenarioOutlineLine(event.testCase);
            if (this.currentScenarioOutlineLine != mainScenarioLine || this.currentFilePath == null || !this.currentFilePath.equals(this.getEventUri(event))) {
                this.closeCurrentScenarioOutline();
                this.currentScenarioOutlineLine = mainScenarioLine;
                this.currentScenarioOutlineName = this.getEventName(event);
                this.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.getEventUri(event)) + ":" + this.currentScenarioOutlineLine, CucumberJvmSMFormatterUtil.escape(this.currentScenarioOutlineName)));
                this.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), "", EXAMPLES_CAPTION));
            }
        } else {
            this.closeCurrentScenarioOutline();
        }
        this.currentFilePath = this.getEventUri(event);
        this.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.getEventUri(event)) + ":" + this.getEventLine(event), CucumberJvmSMFormatterUtil.escape(this.getScenarioName(event))));
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        this.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.getScenarioName(event))));
        this.outCommand(String.format("##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']", this.getCurrentTime()));
    }

    private void handleTestRunFinished(TestRunFinished event) {
        this.closeCurrentScenarioOutline();
        this.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.getFeatureFileDescription(this.currentFilePath))));
    }

    private void handleTestStepStarted(TestStepStarted event) {
        this.outCommand(String.format("##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.getStepLocation(event)), CucumberJvmSMFormatterUtil.escape(this.getStepName(event))));
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.result.getStatus() != Result.Type.PASSED) {
            if (event.result.getStatus() == Result.Type.SKIPPED || event.result.getStatus() == Result.Type.PENDING) {
                this.outCommand(String.format("##teamcity[testIgnored name = '%s' message = 'Skipped step' timestamp = '%s']", CucumberJvmSMFormatterUtil.escape(this.getStepName(event)), this.getCurrentTime()));
            } else {
                this.outCommand(String.format("##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' name = '%s' %s]", this.getCurrentTime(), "", CucumberJvmSMFormatterUtil.escape(event.result.getErrorMessage()), CucumberJvmSMFormatterUtil.escape(this.getStepName(event)), ""));
            }
        }
        Long duration = event.result.getDuration() != null ? event.result.getDuration() / 1000000L : 0L;
        this.outCommand(String.format("##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']", this.getCurrentTime(), duration, CucumberJvmSMFormatterUtil.escape(this.getStepName(event))));
    }

    private String getFeatureFileDescription(String uri) {
        if (this.pathToDescription.containsKey(uri)) {
            return this.pathToDescription.get(uri);
        }
        return uri;
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.closeCurrentScenarioOutline();
        this.pathToDescription.put(event.uri, CucumberJvmSMFormatterUtil.getFeatureName(event.source));
    }

    private void closeCurrentScenarioOutline() {
        if (this.currentScenarioOutlineLine > 0) {
            this.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), EXAMPLES_CAPTION));
            this.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMFormatterUtil.escape(this.currentScenarioOutlineName)));
            this.currentScenarioOutlineLine = 0;
            this.currentScenarioOutlineName = null;
        }
    }

    private static String getStepLocation(TestStep step) {
        if (step.isHook()) {
            try {
                Field definitionMatchField = step.getClass().getSuperclass().getDeclaredField("definitionMatch");
                definitionMatchField.setAccessible(true);
                Object definitionMatchFieldValue = definitionMatchField.get(step);
                Field hookDefinitionField = definitionMatchFieldValue.getClass().getDeclaredField("hookDefinition");
                hookDefinitionField.setAccessible(true);
                Object hookDefinitionFieldValue = hookDefinitionField.get(definitionMatchFieldValue);
                Field methodField = hookDefinitionFieldValue.getClass().getDeclaredField("method");
                methodField.setAccessible(true);
                Object methodFieldValue = methodField.get(hookDefinitionFieldValue);
                if (methodFieldValue instanceof Method) {
                    Method method = (Method)methodFieldValue;
                    return String.format("java:test://%s/%s", method.getDeclaringClass().getName(), method.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }
        return "file://" + step.getStepLocation() + ":" + step.getStepLine();
    }

    private static String getStepName(TestStep step) {
        String stepName = step.isHook() ? "Hook: " + step.getHookType().toString() : step.getStepText();
        return stepName;
    }

    private void outCommand(String s) {
        this.myOut.println(s);
    }

    private static PickleEvent getPickleEvent(TestCase testCase) {
        try {
            Field pickleEventField = TestCase.class.getDeclaredField("pickleEvent");
            pickleEventField.setAccessible(true);
            return (PickleEvent)pickleEventField.get(testCase);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean isScenarioOutline(TestCase testCase) {
        PickleEvent pickleEvent = CucumberJvm2SMFormatter.getPickleEvent(testCase);
        return pickleEvent != null && pickleEvent.pickle.getLocations().size() > 1;
    }

    private static int getScenarioOutlineLine(TestCase testCase) {
        PickleEvent pickleEvent = CucumberJvm2SMFormatter.getPickleEvent(testCase);
        if (pickleEvent != null) {
            return ((PickleLocation)pickleEvent.pickle.getLocations().get(pickleEvent.pickle.getLocations().size() - 1)).getLine();
        }
        return 0;
    }

    private static String getScenarioName(TestCase testCase) {
        if (CucumberJvm2SMFormatter.isScenarioOutline(testCase)) {
            return SCENARIO_OUTLINE_CAPTION + testCase.getLine();
        }
        return testCase.getName();
    }

    protected String getScenarioName(TestCaseStarted testCaseStarted) {
        return CucumberJvm2SMFormatter.getScenarioName(testCaseStarted.testCase);
    }

    protected String getScenarioName(TestCaseFinished testCaseFinished) {
        return CucumberJvm2SMFormatter.getScenarioName(testCaseFinished.testCase);
    }

    protected String getEventUri(TestCaseStarted event) {
        return event.testCase.getUri();
    }

    protected int getEventLine(TestCaseStarted event) {
        return event.testCase.getLine();
    }

    protected String getEventName(TestCaseStarted event) {
        return event.testCase.getName();
    }

    protected String getStepLocation(TestStepStarted testStepStarted) {
        return CucumberJvm2SMFormatter.getStepLocation(testStepStarted.testStep);
    }

    protected String getStepLocation(TestStepFinished testStepFinished) {
        return CucumberJvm2SMFormatter.getStepLocation(testStepFinished.testStep);
    }

    protected String getStepName(TestStepStarted testStepStarted) {
        return CucumberJvm2SMFormatter.getStepName(testStepStarted.testStep);
    }

    protected String getStepName(TestStepFinished testStepFinished) {
        return CucumberJvm2SMFormatter.getStepName(testStepFinished.testStep);
    }

    private String getCurrentTime() {
        if (this.myCurrentTimeValue != null) {
            return this.myCurrentTimeValue;
        }
        return CucumberJvmSMFormatterUtil.getCurrentTime();
    }
}

