/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.index.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildDataPathsImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gwt.build.GwtBuildTargetType;
import org.jetbrains.jps.gwt.index.JpsGwtModule;
import org.jetbrains.jps.gwt.index.impl.JpsGwtModuleImpl;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;

public class JpsGwtModulesCache {
    private static final Logger LOG = Logger.getInstance(JpsGwtModulesCache.class);
    private final File myCacheFile;

    public JpsGwtModulesCache(@NotNull BuildDataPaths buildDataPaths) {
        if (buildDataPaths == null) {
            JpsGwtModulesCache.$$$reportNull$$$0(0);
        }
        this.myCacheFile = new File(buildDataPaths.getTargetTypeDataRoot((BuildTargetType)GwtBuildTargetType.INSTANCE), "gwt-modules.xml");
    }

    public JpsGwtModulesCache(File projectSystemDirectory) {
        this((BuildDataPaths)new BuildDataPathsImpl(projectSystemDirectory));
    }

    public void saveGwtModules(@NotNull GwtModulesConfiguration configuration) {
        if (configuration == null) {
            JpsGwtModulesCache.$$$reportNull$$$0(1);
        }
        try {
            FileUtil.createParentDirs((File)this.myCacheFile);
            Element rootElement = XmlSerializer.serialize((Object)configuration);
            JDOMUtil.write((Element)rootElement, (File)this.myCacheFile, (String)"\n");
        }
        catch (IOException e) {
            LOG.info("Cannot save cache: " + e.getMessage(), (Throwable)e);
            this.clear();
        }
    }

    @NotNull
    public List<JpsGwtModule> loadGwtModules(@NotNull JpsModel model) {
        List<JpsGwtModule> list;
        if (model == null) {
            JpsGwtModulesCache.$$$reportNull$$$0(2);
        }
        if (!this.myCacheFile.exists()) {
            LOG.debug("Cache file doesn't exist, scanning source roots to find GWT modules");
            List<JpsGwtModule> list2 = JpsGwtModulesCache.findGwtModules(model);
            if (list2 == null) {
                JpsGwtModulesCache.$$$reportNull$$$0(3);
            }
            return list2;
        }
        try {
            list = this.loadModulesFromCache(model);
        }
        catch (Exception e) {
            LOG.info("Cannot load cache: " + e.getMessage(), (Throwable)e);
            List<JpsGwtModule> list3 = JpsGwtModulesCache.findGwtModules(model);
            if (list3 == null) {
                JpsGwtModulesCache.$$$reportNull$$$0(5);
            }
            return list3;
        }
        if (list == null) {
            JpsGwtModulesCache.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<JpsGwtModule> loadModulesFromCache(JpsModel model) throws JDOMException, IOException {
        GwtModulesConfiguration configuration = (GwtModulesConfiguration)XmlSerializer.deserialize((Element)JDOMUtil.load((File)this.myCacheFile), GwtModulesConfiguration.class);
        ArrayList<JpsGwtModule> result = new ArrayList<JpsGwtModule>();
        HashMap<String, JpsModule> modulesMap = new HashMap<String, JpsModule>();
        for (JpsModule module : model.getProject().getModules()) {
            modulesMap.put(module.getName(), module);
        }
        for (GwtModuleData gwtModuleData : configuration.myGwtModules) {
            JpsModule module = (JpsModule)modulesMap.get(gwtModuleData.myModuleName);
            if (module == null) continue;
            result.add(new JpsGwtModuleImpl(new File(gwtModuleData.myFilePath), module, new File(gwtModuleData.mySrcRootPath), gwtModuleData.myInTests));
        }
        ArrayList<JpsGwtModule> arrayList = result;
        if (arrayList == null) {
            JpsGwtModulesCache.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static List<JpsGwtModule> findGwtModules(JpsModel model) {
        ArrayList<JpsGwtModule> result = new ArrayList<JpsGwtModule>();
        for (JpsModule module : model.getProject().getModules()) {
            JpsGwtModuleExtension extension = JpsGwtExtensionService.getInstance().getExtension(module);
            if (extension == null) continue;
            for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                JpsGwtModulesCache.collectGwtModules(root, module, root.getRootType().equals(JavaSourceRootType.TEST_SOURCE), result);
            }
        }
        return result;
    }

    private static void collectGwtModules(JpsModuleSourceRoot sourceRoot, JpsModule module, boolean tests, List<JpsGwtModule> result) {
        FileUtil.processFilesRecursively((File)sourceRoot.getFile(), file -> {
            if (file.getName().endsWith(".gwt.xml")) {
                try {
                    result.add(new JpsGwtModuleImpl((File)file, module, sourceRoot.getFile(), tests));
                }
                catch (Exception e) {
                    LOG.info("Cannot parse " + file.getAbsolutePath() + " file: " + e.getMessage(), (Throwable)e);
                }
            }
            return true;
        });
    }

    public void clear() {
        FileUtil.delete((File)this.myCacheFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDataPaths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gwt/index/impl/JpsGwtModulesCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gwt/index/impl/JpsGwtModulesCache";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadGwtModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModulesFromCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveGwtModules";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadGwtModules";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="configuration")
    public static class GwtModulesConfiguration {
        @XCollection(propertyElementName="gwt-modules", elementName="module")
        public List<GwtModuleData> myGwtModules = new ArrayList<GwtModuleData>();
    }

    @Tag(value="module")
    public static class GwtModuleData {
        @Attribute(value="path")
        public String myFilePath;
        @Attribute(value="root")
        public String mySrcRootPath;
        @Attribute(value="inTests")
        public boolean myInTests;
        @Attribute(value="module-name")
        public String myModuleName;

        public GwtModuleData() {
        }

        public GwtModuleData(String filePath, String srcRootPath, boolean inTests, String moduleName) {
            this.myFilePath = filePath;
            this.mySrcRootPath = srcRootPath;
            this.myInTests = inTests;
            this.myModuleName = moduleName;
        }
    }
}

