/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class TypeReference
extends Expression {
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void aboutToResolve(Scope scope) {
    }

    public static final TypeReference baseTypeReference(int baseType, int dim) {
        if (dim == 0) {
            switch (baseType) {
                case 6: {
                    return new SingleTypeReference(TypeReference.VoidBinding.simpleName, 0L);
                }
                case 5: {
                    return new SingleTypeReference(TypeReference.BooleanBinding.simpleName, 0L);
                }
                case 2: {
                    return new SingleTypeReference(TypeReference.CharBinding.simpleName, 0L);
                }
                case 9: {
                    return new SingleTypeReference(TypeReference.FloatBinding.simpleName, 0L);
                }
                case 8: {
                    return new SingleTypeReference(TypeReference.DoubleBinding.simpleName, 0L);
                }
                case 3: {
                    return new SingleTypeReference(TypeReference.ByteBinding.simpleName, 0L);
                }
                case 4: {
                    return new SingleTypeReference(TypeReference.ShortBinding.simpleName, 0L);
                }
                case 10: {
                    return new SingleTypeReference(TypeReference.IntBinding.simpleName, 0L);
                }
            }
            return new SingleTypeReference(TypeReference.LongBinding.simpleName, 0L);
        }
        switch (baseType) {
            case 6: {
                return new ArrayTypeReference(TypeReference.VoidBinding.simpleName, dim, 0L);
            }
            case 5: {
                return new ArrayTypeReference(TypeReference.BooleanBinding.simpleName, dim, 0L);
            }
            case 2: {
                return new ArrayTypeReference(TypeReference.CharBinding.simpleName, dim, 0L);
            }
            case 9: {
                return new ArrayTypeReference(TypeReference.FloatBinding.simpleName, dim, 0L);
            }
            case 8: {
                return new ArrayTypeReference(TypeReference.DoubleBinding.simpleName, dim, 0L);
            }
            case 3: {
                return new ArrayTypeReference(TypeReference.ByteBinding.simpleName, dim, 0L);
            }
            case 4: {
                return new ArrayTypeReference(TypeReference.ShortBinding.simpleName, dim, 0L);
            }
            case 10: {
                return new ArrayTypeReference(TypeReference.IntBinding.simpleName, dim, 0L);
            }
        }
        return new ArrayTypeReference(TypeReference.LongBinding.simpleName, dim, 0L);
    }

    public void checkBounds(Scope scope) {
    }

    public abstract TypeReference copyDims(int var1);

    public int dimensions() {
        return 0;
    }

    public char[][] getParameterizedTypeName() {
        return this.getTypeName();
    }

    protected abstract TypeBinding getTypeBinding(Scope var1);

    public abstract char[][] getTypeName();

    public boolean isTypeReference() {
        return true;
    }

    public TypeBinding resolveSuperType(ClassScope scope) {
        if (this.resolveType(scope) == null) {
            return null;
        }
        if (this.resolvedType.isTypeVariable()) {
            this.resolvedType = new ProblemReferenceBinding(this.getTypeName(), (ReferenceBinding)this.resolvedType, 9);
            this.reportInvalidType(scope);
            return null;
        }
        return this.resolvedType;
    }

    public final TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveType(BlockScope scope, boolean checkBounds) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        TypeBinding type = this.resolvedType = this.getTypeBinding(scope);
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.isValidBinding()) {
            this.reportInvalidType(scope);
            return null;
        }
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(scope);
        }
        if ((type = scope.environment().convertToRawType(type)).isRawType() && (this.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x200000000000L) != -1) {
            scope.problemReporter().rawTypeReference(this, type);
        }
        this.resolvedType = type;
        return this.resolvedType;
    }

    public TypeBinding resolveType(ClassScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        TypeBinding type = this.resolvedType = this.getTypeBinding(scope);
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.isValidBinding()) {
            this.reportInvalidType(scope);
            return null;
        }
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(scope);
        }
        if ((type = scope.environment().convertToRawType(type)).isRawType() && (this.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x200000000000L) != -1) {
            scope.problemReporter().rawTypeReference(this, type);
        }
        this.resolvedType = type;
        return this.resolvedType;
    }

    public TypeBinding resolveTypeArgument(BlockScope blockScope, ReferenceBinding genericType, int rank) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveTypeArgument(ClassScope classScope, ReferenceBinding genericType, int rank) {
        return this.resolveType(classScope);
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().invalidType(this, this.resolvedType);
    }

    protected void reportDeprecatedType(Scope scope) {
        scope.problemReporter().deprecatedType(this.resolvedType, this);
    }

    public abstract void traverse(ASTVisitor var1, ClassScope var2);

    public abstract void traverse(ASTVisitor var1, BlockScope var2);
}

