/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    @NonNls
    public static final String TRUE = "true";
    @NonNls
    public static final String FALSE = "false";

    private BoolUtils() {
    }

    @Nullable
    public static JSExpression findNegation(JSExpression condition) {
        JSPrefixExpression prefixAncestor;
        JSExpression ancestor = condition;
        while (ancestor.getParent() instanceof JSParenthesizedExpression) {
            ancestor = (JSExpression)ancestor.getParent();
        }
        if (ancestor.getParent() instanceof JSPrefixExpression && JSTokenTypes.EXCL.equals((prefixAncestor = (JSPrefixExpression)ancestor.getParent()).getOperationSign())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isNegation(JSExpression condition) {
        return BoolUtils.isNegation(condition, false);
    }

    private static boolean isNegation(JSExpression condition, boolean ignoreNegatedNullComparison) {
        if (condition instanceof JSPrefixExpression) {
            JSPrefixExpression prefixExpression = (JSPrefixExpression)condition;
            IElementType sign = prefixExpression.getOperationSign();
            return JSTokenTypes.EXCL.equals(sign);
        }
        if (condition instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression lhs = binaryExpression.getLOperand();
            JSExpression rhs = binaryExpression.getROperand();
            if (rhs != null && JSTokenTypes.NE.equals(sign)) {
                if (!ignoreNegatedNullComparison) {
                    return true;
                }
                return !JSLiteralExpressionImpl.isNullExpression((ASTNode)lhs.getNode()) && !JSLiteralExpressionImpl.isNullExpression((ASTNode)rhs.getNode());
            }
            return false;
        }
        if (condition instanceof JSParenthesizedExpression) {
            return BoolUtils.isNegation(((JSParenthesizedExpression)condition).getInnerExpression());
        }
        return false;
    }

    @Nullable
    public static JSExpression getNegated(JSExpression condition) {
        if (condition instanceof JSPrefixExpression) {
            JSPrefixExpression prefixExp = (JSPrefixExpression)condition;
            JSExpression operand = prefixExp.getExpression();
            JSExpression unparenthesized = ParenthesesUtils.stripParentheses((JSExpression)operand);
            return unparenthesized != null ? unparenthesized : operand;
        }
        if (condition instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression lhs = binaryExpression.getLOperand();
            JSExpression rhs = binaryExpression.getROperand();
            String negatedSign = ComparisonUtils.getNegatedOperatorText((IElementType)sign);
            String negatedText = lhs.getText() + negatedSign + rhs.getText();
            return (JSExpression)JSChangeUtil.createExpressionPsiWithContext((String)negatedText, (PsiElement)condition, JSExpression.class);
        }
        if (condition instanceof JSParenthesizedExpression) {
            return BoolUtils.getNegated(((JSParenthesizedExpression)condition).getInnerExpression());
        }
        return condition;
    }

    public static boolean isBooleanLiteral(JSExpression condition) {
        return condition instanceof JSLiteralExpression && ((JSLiteralExpression)condition).isBooleanLiteral();
    }

    public static String getNegatedExpressionText(JSExpression condition) {
        return BoolUtils.getNegatedExpressionText(condition, 15);
    }

    public static String getNegatedExpressionText(JSExpression condition, int precendence) {
        if (BoolUtils.isNegation(condition)) {
            JSExpression negated = BoolUtils.getNegated(condition);
            if (negated == null) {
                return "";
            }
            return ParenthesesUtils.getParenthesized((JSExpression)negated, (int)precendence);
        }
        if (ComparisonUtils.isComparison((JSExpression)condition)) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedOperatorText((IElementType)sign);
            JSExpression leftOperand = binaryExpression.getLOperand();
            JSExpression rightOperand = binaryExpression.getROperand();
            return leftOperand.getText() + negatedComparison + (rightOperand != null ? rightOperand.getText() : "");
        }
        return '!' + ParenthesesUtils.getParenthesized((JSExpression)condition, (int)3);
    }
}

