/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.jigsaw;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.uml.jigsaw.JigsawUmlEdge;
import com.intellij.uml.jigsaw.JigsawUmlNode;
import com.intellij.uml.jigsaw.JigsawUmlProvider;
import com.intellij.uml.jigsaw.JigsawUmlRelationships;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JigsawUmlDataModel
extends DiagramDataModel<PsiJavaModule> {
    private static final Logger LOG = Logger.getInstance(JigsawUmlDataModel.class);
    private final Set<JigsawUmlNode> myNodes;
    private final Set<JigsawUmlEdge> myEdges;
    private final Map<String, SmartPsiElementPointer<PsiJavaModule>> myInitialElements;

    JigsawUmlDataModel(@NotNull Project project, @Nullable PsiJavaModule element) {
        if (project == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(0);
        }
        super(project, (DiagramProvider)JigsawUmlProvider.getInstance());
        this.myNodes = new THashSet();
        this.myEdges = new THashSet();
        this.myInitialElements = new THashMap();
        if (element != null) {
            this.myInitialElements.put(element.getName(), this.createPointer(element));
        }
    }

    @NotNull
    public synchronized Collection<? extends DiagramNode<PsiJavaModule>> getNodes() {
        Set<JigsawUmlNode> set = this.myNodes;
        if (set == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public synchronized Collection<? extends DiagramEdge<PsiJavaModule>> getEdges() {
        Set<JigsawUmlEdge> set = this.myEdges;
        if (set == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public String getNodeName(DiagramNode<PsiJavaModule> n) {
        String string = ((PsiJavaModule)n.getIdentifyingElement()).getName();
        if (string == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public synchronized DiagramNode<PsiJavaModule> addElement(PsiJavaModule element) {
        if (element == null) {
            return null;
        }
        this.myInitialElements.computeIfAbsent(element.getName(), unused -> this.createPointer(element));
        return new JigsawUmlNode(element, (JigsawUmlProvider)this.getBuilder().getProvider());
    }

    @NotNull
    private SmartPsiElementPointer<PsiJavaModule> createPointer(@NotNull PsiJavaModule element) {
        if (element == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(4);
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiElementPointer((PsiElement)element);
        if (smartPsiElementPointer == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(5);
        }
        return smartPsiElementPointer;
    }

    public void refreshDataModel() {
        this.updateDataModel();
    }

    private synchronized void updateDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        JigsawUmlProvider umlProvider = (JigsawUmlProvider)this.getBuilder().getProvider();
        THashSet pendingModulesQueue = new THashSet();
        for (SmartPsiElementPointer<PsiJavaModule> psiElementPointer : this.myInitialElements.values()) {
            ContainerUtil.addIfNotNull((Collection)pendingModulesQueue, (Object)psiElementPointer.getElement());
        }
        THashMap usedModules = new THashMap();
        while (!pendingModulesQueue.isEmpty()) {
            Iterator it = pendingModulesQueue.iterator();
            LOG.assertTrue(it.hasNext(), (Object)"next pending module");
            PsiJavaModule javaModule = (PsiJavaModule)it.next();
            it.remove();
            JigsawUmlNode toNode = usedModules.computeIfAbsent(javaModule, aModule -> new JigsawUmlNode((PsiJavaModule)aModule, umlProvider));
            Map<PsiJavaModule, DiagramRelationshipInfo> requiredModules = JigsawUmlDataModel.getRequiredModules(javaModule);
            for (Map.Entry<PsiJavaModule, DiagramRelationshipInfo> requiredModule : requiredModules.entrySet()) {
                JigsawUmlNode fromNode = usedModules.computeIfAbsent(requiredModule.getKey(), arg_0 -> JigsawUmlDataModel.lambda$updateDataModel$2((Set)pendingModulesQueue, umlProvider, arg_0));
                this.myEdges.add(new JigsawUmlEdge((DiagramNode<PsiJavaModule>)fromNode, (DiagramNode<PsiJavaModule>)toNode, requiredModule.getValue()));
            }
        }
        this.myNodes.addAll(usedModules.values());
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(6);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    @NotNull
    private static Map<PsiJavaModule, DiagramRelationshipInfo> getRequiredModules(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(7);
        }
        THashMap result = new THashMap();
        for (PsiRequiresStatement requiresStatement : javaModule.getRequires()) {
            PsiJavaModule resolved = PsiJavaModuleReference.resolve((PsiJavaModuleReferenceElement)requiresStatement.getReferenceElement());
            if (resolved == null) continue;
            DiagramRelationshipInfo relationship = JigsawUmlRelationships.getRelationship(requiresStatement.hasModifierProperty("transitive"), requiresStatement.hasModifierProperty("static"));
            result.put(resolved, relationship);
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            JigsawUmlDataModel.$$$reportNull$$$0(8);
        }
        return tHashMap;
    }

    private static /* synthetic */ JigsawUmlNode lambda$updateDataModel$2(Set pendingModulesQueue, JigsawUmlProvider umlProvider, PsiJavaModule aModule) {
        pendingModulesQueue.add(aModule);
        return new JigsawUmlNode(aModule, umlProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/jigsaw/JigsawUmlDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/jigsaw/JigsawUmlDataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

