/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidOSProcessHandler
extends BaseOSProcessHandler {
    @NonNls
    private static final String IGNORING = "ignoring";
    @NonNls
    private static final String SKIPPING = "skipping";
    @NonNls
    private static final String DEBUGGABLE_ERROR = "androidmanifest.xml already defines debuggable";
    private final List<String> myInfoMessages;
    private final List<String> myErrorMessages;

    public AndroidOSProcessHandler(@NotNull Process process, @NotNull String commandLine) {
        if (process == null) {
            AndroidOSProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            AndroidOSProcessHandler.$$$reportNull$$$0(1);
        }
        super(process, commandLine, null);
        this.myInfoMessages = new ArrayList<String>();
        this.myErrorMessages = new ArrayList<String>();
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        String[] lines;
        if (text == null) {
            AndroidOSProcessHandler.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            AndroidOSProcessHandler.$$$reportNull$$$0(3);
        }
        super.notifyTextAvailable(text, outputType);
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return;
        }
        for (String line : lines = text.split("[\\n\\r]+")) {
            String l = line.toLowerCase();
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myInfoMessages.add(line);
                continue;
            }
            if (outputType != ProcessOutputTypes.STDERR) continue;
            if (l.contains(IGNORING) || l.contains(SKIPPING) || l.contains(DEBUGGABLE_ERROR)) {
                this.myInfoMessages.add(line);
                continue;
            }
            this.myErrorMessages.add(line);
        }
    }

    @NotNull
    public List<String> getInfoMessages() {
        List<String> list = this.myInfoMessages;
        if (list == null) {
            AndroidOSProcessHandler.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<String> getErrorMessages() {
        List<String> list = this.myErrorMessages;
        if (list == null) {
            AndroidOSProcessHandler.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidOSProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidOSProcessHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMessages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyTextAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

