/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.radComponents.RadErrorComponent;
import org.jetbrains.annotations.NotNull;

public class ReloadCustomComponentsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        FileEditor[] fileEditors;
        Project project;
        if (e == null) {
            ReloadCustomComponentsAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        LoaderFactory.getInstance(project).clearClassLoaderCache();
        for (FileEditor editor : fileEditors = FileEditorManager.getInstance((Project)project).getAllEditors()) {
            if (!(editor instanceof UIFormEditor)) continue;
            ((UIFormEditor)editor).getEditor().readFromFile(true);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ReloadCustomComponentsAction.$$$reportNull$$$0(1);
        }
        GuiEditor editor = FormEditingUtil.getActiveEditor(e.getDataContext());
        e.getPresentation().setVisible(editor != null && ReloadCustomComponentsAction.haveCustomComponents(editor));
    }

    private static boolean haveCustomComponents(GuiEditor editor) {
        if (editor.isFormInvalid()) {
            return true;
        }
        final Ref result = new Ref();
        FormEditingUtil.iterate(editor.getRootContainer(), new FormEditingUtil.ComponentVisitor(){

            public boolean visit(IComponent component) {
                if (component instanceof RadErrorComponent || !component.getComponentClassName().startsWith("javax.swing")) {
                    result.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }
        });
        return !result.isNull();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uiDesigner/actions/ReloadCustomComponentsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

