/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class IteratorUtils {
    private IteratorUtils() {
    }

    public static boolean containsCallToIteratorNext(PsiElement context, PsiVariable target, boolean checkTarget) {
        CallsIteratorNextVisitor visitor = new CallsIteratorNextVisitor(target, checkTarget, false);
        context.accept((PsiElementVisitor)visitor);
        return visitor.callsIteratorNext();
    }

    public static boolean containsCallToScannerNext(PsiElement context, PsiVariable target, boolean checkTarget) {
        CallsIteratorNextVisitor visitor = new CallsIteratorNextVisitor(target, checkTarget, true);
        context.accept((PsiElementVisitor)visitor);
        return visitor.callsIteratorNext();
    }

    public static boolean isCallToHasNext(PsiMethodCallExpression methodCallExpression) {
        return MethodCallUtils.isCallToMethod(methodCallExpression, "java.util.Iterator", (PsiType)PsiType.BOOLEAN, "hasNext", new PsiType[0]);
    }

    private static class CallsIteratorNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private static final Pattern SCANNER_PATTERN = Pattern.compile("next.*");
        private final boolean checkTarget;
        private final boolean checkScanner;
        private final PsiVariable target;
        private boolean doesCallIteratorNext;

        private CallsIteratorNextVisitor(PsiVariable target, boolean checkTarget, boolean checkScanner) {
            this.checkTarget = checkTarget;
            this.target = target;
            this.checkScanner = checkScanner;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CallsIteratorNextVisitor.$$$reportNull$$$0(0);
            }
            if (this.doesCallIteratorNext) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                CallsIteratorNextVisitor.$$$reportNull$$$0(1);
            }
            if (this.doesCallIteratorNext) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            if (this.checkScanner ? !MethodCallUtils.isCallToMethod(expression2, "java.util.Iterator", null, SCANNER_PATTERN, new PsiType[0]) : !MethodCallUtils.isCallToMethod(expression2, "java.util.Iterator", null, "next", new PsiType[0]) && !MethodCallUtils.isCallToMethod(expression2, "java.util.ListIterator", null, "previous", new PsiType[0])) {
                return;
            }
            if (this.checkTarget) {
                PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    if (this.target != null) {
                        return;
                    }
                    if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                        return;
                    }
                } else {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                    PsiElement element = referenceExpression.resolve();
                    if (this.target == null || !this.target.equals(element)) {
                        return;
                    }
                }
            }
            this.doesCallIteratorNext = true;
        }

        private boolean callsIteratorNext() {
            return this.doesCallIteratorNext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/IteratorUtils$CallsIteratorNextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

