/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class LambdaParameterNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.parameter.naming.convention.display.name", new Object[0]);
        if (string == null) {
            LambdaParameterNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("lambda.parameter.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaParameterNamingConventionInspection", "getDisplayName"));
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            PsiElement scope;
            if (variable == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            if (!((scope = variable.getDeclarationScope()) instanceof PsiLambdaExpression)) {
                return;
            }
            String name = variable.getName();
            if (name == null || LambdaParameterNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/naming/LambdaParameterNamingConventionInspection$NamingConventionsVisitor", "visitParameter"));
        }
    }
}

