/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;

class NonFinalStaticVariableUsedInClassInitializationVisitor
extends BaseInspectionVisitor {
    NonFinalStaticVariableUsedInClassInitializationVisitor() {
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        super.visitReferenceExpression(expression2);
        PsiElement referent = expression2.resolve();
        if (!(referent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)referent;
        if (!field.hasModifierProperty("static")) {
            return;
        }
        if (field.hasModifierProperty("final")) {
            return;
        }
        if (!NonFinalStaticVariableUsedInClassInitializationVisitor.isInClassInitialization((PsiExpression)expression2)) {
            return;
        }
        this.registerError((PsiElement)expression2, field);
    }

    private static boolean isInClassInitialization(PsiExpression expression2) {
        PsiClass expressionClass = ClassUtils.getContainingClass((PsiElement)expression2);
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiClassInitializer.class, PsiField.class});
        if (member == null) {
            return false;
        }
        PsiClass memberClass = member.getContainingClass();
        if (!memberClass.equals(expressionClass)) {
            return false;
        }
        if (!member.hasModifierProperty("static")) {
            return false;
        }
        if (member instanceof PsiClassInitializer) {
            return !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression2);
        }
        return true;
    }
}

