/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java15api.Java15APIUsageInspection;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.JavaOverridingMethodUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingOverrideAnnotationInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final String OVERRIDE_SHORT_NAME = StringUtil.getShortName((String)"java.lang.Override");
    public boolean ignoreObjectMethods = true;
    public boolean ignoreAnonymousClassMethods;

    @NotNull
    public String getID() {
        if ("override" == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(0);
        }
        return "override";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.override.annotation.display.name", new Object[0]);
        if (string == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Deprecated
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InspectionGadgetsFix(){
            private final AnnotateMethodFix myFix = new AnnotateMethodFix("java.lang.Override", new String[0]);

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) {
                this.myFix.applyFix(project, descriptor);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = this.myFix.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$1", "getFamilyName"));
            }
        };
    }

    @Deprecated
    protected String buildErrorString(Object ... infos) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected BaseInspectionVisitor buildVisitor() {
        throw new UnsupportedOperationException();
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.equals.hashcode.and.tostring", new Object[0]), "ignoreObjectMethods");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.methods.in.anonymous.classes", new Object[0]), "ignoreAnonymousClassMethods");
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(2);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                MissingOverrideAnnotationInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (method.getNameIdentifier() == null) {
                    return;
                }
                if (method.isConstructor()) {
                    return;
                }
                if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                    return;
                }
                PsiClass methodClass = method.getContainingClass();
                if (methodClass == null) {
                    return;
                }
                if (MissingOverrideAnnotationInspection.this.ignoreObjectMethods && (MethodUtils.isHashCode(method) || MethodUtils.isEquals(method) || MethodUtils.isToString(method))) {
                    return;
                }
                InspectionResult result = new InspectionResult();
                this.checkMissingOverride(method, result);
                if (isOnTheFly) {
                    this.checkMissingOverrideInOverriders(method, result);
                }
                if (result.requireAnnotation || result.hierarchyAnnotated == ThreeState.NO) {
                    holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionGadgetsBundle.message(result.requireAnnotation ? "missing.override.annotation.problem.descriptor" : "missing.override.annotation.in.overriding.problem.descriptor", new Object[0]), new LocalQuickFix[]{MissingOverrideAnnotationInspection.createAnnotateFix(result.requireAnnotation, result.hierarchyAnnotated)});
                }
            }

            private void checkMissingOverrideInOverriders(@NotNull PsiMethod method, @NotNull InspectionResult result) {
                if (method == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                Project project = method.getProject();
                LanguageLevel minimal = Objects.requireNonNull(method.getContainingClass()).isInterface() ? LanguageLevel.JDK_1_6 : LanguageLevel.JDK_1_5;
                GlobalSearchScope scope = MissingOverrideAnnotationInspection.getLanguageLevelScope(minimal, project);
                if (scope == null) {
                    return;
                }
                Predicate<PsiMethod> preFilter = m -> !JavaOverridingMethodUtil.containsAnnotationWithName((PsiModifierListOwner)m, OVERRIDE_SHORT_NAME);
                Stream<PsiMethod> overridingMethods = JavaOverridingMethodUtil.getOverridingMethodsIfCheapEnough(method, scope, preFilter);
                if (overridingMethods == null) {
                    return;
                }
                result.hierarchyAnnotated = ThreeState.fromBoolean((!overridingMethods.findAny().isPresent() ? 1 : 0) != 0);
            }

            private void checkMissingOverride(@NotNull PsiMethod method, @NotNull InspectionResult result) {
                if (method == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(4);
                }
                PsiClass methodClass = method.getContainingClass();
                if (MissingOverrideAnnotationInspection.this.ignoreAnonymousClassMethods && methodClass instanceof PsiAnonymousClass) {
                    return;
                }
                if (this.hasOverrideAnnotation((PsiModifierListOwner)method)) {
                    return;
                }
                boolean useJdk6Rules = PsiUtil.isLanguageLevel6OrHigher((PsiElement)method);
                if (useJdk6Rules ? !this.isJdk6Override(method, methodClass) : !this.isJdk5Override(method, methodClass)) {
                    return;
                }
                result.requireAnnotation = true;
            }

            private boolean hasOverrideAnnotation(PsiModifierListOwner element) {
                PsiModifierList modifierList = element.getModifierList();
                return modifierList != null && modifierList.hasAnnotation("java.lang.Override");
            }

            private boolean isJdk6Override(PsiMethod method, PsiClass methodClass) {
                PsiMethod[] superMethods = method.findSuperMethods();
                boolean hasSupers = false;
                for (PsiMethod superMethod : superMethods) {
                    PsiClass superClass = superMethod.getContainingClass();
                    if (this.ignoreSuperMethod(method, methodClass, superMethod, superClass)) continue;
                    hasSupers = true;
                    if (superMethod.hasModifierProperty("protected")) continue;
                    return true;
                }
                return hasSupers && !methodClass.isInterface();
            }

            private boolean isJdk5Override(PsiMethod method, PsiClass methodClass) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    PsiClass superClass = superMethod.getContainingClass();
                    if (this.ignoreSuperMethod(method, methodClass, superMethod, superClass) || superClass.isInterface() || methodClass.isInterface() && superMethod.hasModifierProperty("protected")) continue;
                    return true;
                }
                return false;
            }

            @Contract(value="_, _, _,null -> true")
            private boolean ignoreSuperMethod(PsiMethod method, PsiClass methodClass, PsiMethod superMethod, PsiClass superClass) {
                return !InheritanceUtil.isInheritorOrSelf((PsiClass)methodClass, (PsiClass)superClass, (boolean)true) || Java15APIUsageInspection.getLastIncompatibleLanguageLevel((PsiMember)superMethod, PsiUtil.getLanguageLevel((PsiElement)method)) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkMissingOverrideInOverriders";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkMissingOverride";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (javaElementVisitor == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    @NotNull
    private static AnnotateMethodFix createAnnotateFix(final boolean requireAnnotation, final ThreeState hierarchyAnnotated) {
        AnnotateMethodFix annotateMethodFix = new AnnotateMethodFix("java.lang.Override", new String[0]){

            @Override
            protected boolean annotateSelf() {
                return requireAnnotation;
            }

            @Override
            protected boolean annotateOverriddenMethods() {
                return hierarchyAnnotated == ThreeState.NO;
            }
        };
        if (annotateMethodFix == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(5);
        }
        return annotateMethodFix;
    }

    @Nullable
    private static GlobalSearchScope getLanguageLevelScope(@NotNull LanguageLevel minimal, @NotNull Project project) {
        GlobalSearchScope[] scopes;
        if (minimal == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(6);
        }
        if (project == null) {
            MissingOverrideAnnotationInspection.$$$reportNull$$$0(7);
        }
        return (scopes = (GlobalSearchScope[])Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(m -> {
            if (minimal == null) {
                MissingOverrideAnnotationInspection.$$$reportNull$$$0(8);
            }
            return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)m).isAtLeast(minimal);
        }).map(Module::getModuleScope).toArray(GlobalSearchScope[]::new)).length == 0 ? null : GlobalSearchScope.union((GlobalSearchScope[])scopes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimal";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotateFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLanguageLevelScope$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InspectionResult {
        private boolean requireAnnotation;
        private ThreeState hierarchyAnnotated = ThreeState.UNSURE;

        private InspectionResult() {
        }
    }
}

