/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class InheritorRenamer
extends AutomaticRenamer {
    public InheritorRenamer(PsiClass aClass, String newClassName) {
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)aClass).findAll()) {
            if (inheritor.getName() == null) continue;
            this.myElements.add(inheritor);
        }
        this.suggestAllNames(aClass.getName(), newClassName);
    }

    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.inheritors.title");
    }

    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.inheritors.with.the.following.names.to");
    }

    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.inheritor");
    }
}

