/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ConstructorReflectionAccessor;
import com.intellij.refactoring.extractMethodObject.reflect.MethodReflectionAccessor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReferenceReflectionAccessorBase;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceReflectionAccessor
extends ReferenceReflectionAccessorBase<MethodReferenceDescriptor> {
    private static final Logger LOG = Logger.getInstance(MethodReferenceReflectionAccessor.class);
    private final MethodReflectionAccessor myMethodAccessor;
    private final ConstructorReflectionAccessor myConstructorReflectionAccessor;

    public MethodReferenceReflectionAccessor(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        if (psiClass == null) {
            MethodReferenceReflectionAccessor.$$$reportNull$$$0(0);
        }
        if (elementFactory == null) {
            MethodReferenceReflectionAccessor.$$$reportNull$$$0(1);
        }
        super(psiClass, elementFactory);
        this.myMethodAccessor = new MethodReflectionAccessor(psiClass, elementFactory);
        this.myConstructorReflectionAccessor = new ConstructorReflectionAccessor(psiClass, elementFactory);
    }

    @Override
    @Nullable
    protected MethodReferenceDescriptor createDescriptor(@NotNull PsiReferenceExpression expression2) {
        PsiMethod method;
        PsiElement resolvedElement;
        if (expression2 == null) {
            MethodReferenceReflectionAccessor.$$$reportNull$$$0(2);
        }
        if (expression2 instanceof PsiMethodReferenceExpression && (resolvedElement = expression2.resolve()) instanceof PsiMethod && !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)(method = (PsiMethod)resolvedElement))) {
            return new MethodReferenceDescriptor(method, (PsiMethodReferenceExpression)expression2);
        }
        return null;
    }

    @Override
    protected void grantAccess(@NotNull MethodReferenceDescriptor descriptor) {
        PsiLambdaExpression lambda2;
        PsiElement lambdaBody;
        if (descriptor == null) {
            MethodReferenceReflectionAccessor.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = lambdaBody = (lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda(descriptor.expression, false, true)) == null ? null : lambda2.getBody();
        if (lambdaBody != null) {
            if (lambdaBody instanceof PsiNewExpression) {
                ConstructorReflectionAccessor.ConstructorDescriptor constructorDescriptor = ConstructorReflectionAccessor.ConstructorDescriptor.createIfInaccessible((PsiNewExpression)lambdaBody);
                if (constructorDescriptor != null) {
                    this.myConstructorReflectionAccessor.grantAccess(constructorDescriptor);
                } else {
                    LOG.warn("Inaccessible constructor not found. Method reference: " + descriptor.expression.getText());
                }
            } else if (lambdaBody instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lambdaBody;
                PsiMethod method = callExpression.resolveMethod();
                if (method != null) {
                    this.myMethodAccessor.grantAccess(new MethodReflectionAccessor.MethodCallDescriptor(callExpression, method));
                } else {
                    LOG.warn("Could not resolve method from expression: " + callExpression.getText());
                }
            } else {
                LOG.warn("Unexpected type of lambda body: " + lambdaBody.getClass().getCanonicalName());
            }
        } else {
            LOG.warn("Could not replace method reference with lambda: " + descriptor.expression.getText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/MethodReferenceReflectionAccessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "grantAccess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MethodReferenceDescriptor
    implements ItemToReplaceDescriptor {
        public final PsiMethod method;
        public final PsiMethodReferenceExpression expression;

        public MethodReferenceDescriptor(@NotNull PsiMethod method, @NotNull PsiMethodReferenceExpression expression2) {
            if (method == null) {
                MethodReferenceDescriptor.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                MethodReferenceDescriptor.$$$reportNull$$$0(1);
            }
            this.method = method;
            this.expression = expression2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethodObject/reflect/MethodReferenceReflectionAccessor$MethodReferenceDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

