/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.chainCall;

import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ChainCallExtractor {
    public static final ExtensionPointName<ChainCallExtractor> KEY = ExtensionPointName.create((String)"com.intellij.java.refactoring.chainCallExtractor");

    public boolean canExtractChainCall(@NotNull PsiMethodCallExpression var1, PsiExpression var2, PsiType var3);

    default public String buildChainCall(PsiVariable variable, PsiExpression expression2, PsiType expressionType) {
        if (expression2 instanceof PsiArrayInitializerExpression) {
            expression2 = RefactoringUtil.convertInitializerToNormalExpression(expression2, expressionType);
        }
        String typeArgument = OptionalUtil.getMapTypeArgument(expression2, expressionType);
        return "." + typeArgument + this.getMethodName(variable, expression2, expressionType) + "(" + variable.getName() + "->" + expression2.getText() + ")";
    }

    public String getMethodName(PsiVariable var1, PsiExpression var2, PsiType var3);

    default public String fixCallName(PsiMethodCallExpression call, PsiType newElementType) {
        return call.getMethodExpression().getReferenceName();
    }

    @Contract(value="null, _, _ -> null")
    public static ChainCallExtractor findExtractor(@Nullable PsiLambdaExpression lambda2, PsiExpression expression2, PsiType targetType) {
        if (lambda2 == null) {
            return null;
        }
        PsiParameterList parameters2 = lambda2.getParameterList();
        if (parameters2.getParametersCount() != 1) {
            return null;
        }
        PsiExpressionList args = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)lambda2.getParent()), PsiExpressionList.class);
        if (args == null || args.getExpressionCount() != 1) {
            return null;
        }
        PsiParameter parameter2 = parameters2.getParameters()[0];
        if (ExpressionUtils.isReferenceTo(expression2, (PsiVariable)parameter2) && parameter2.getType().equals(targetType)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)args.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        for (ChainCallExtractor extractor : (ChainCallExtractor[])KEY.getExtensions()) {
            if (!extractor.canExtractChainCall(call, expression2, targetType) || !StringUtil.isNotEmpty((String)extractor.getMethodName((PsiVariable)parameter2, expression2, targetType))) continue;
            return extractor;
        }
        return null;
    }

    public static PsiLambdaExpression extractMappingStep(@NotNull Project project, PsiLocalVariable variable) {
        PsiLambdaExpression newLambda;
        if (project == null) {
            ChainCallExtractor.$$$reportNull$$$0(0);
        }
        if (variable == null) {
            return null;
        }
        String name = variable.getName();
        if (name == null) {
            return null;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiLambdaExpression.class);
        if (lambda2 == null) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)lambda2, PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        String methodName = call.getMethodExpression().getReferenceName();
        if (methodName == null) {
            return null;
        }
        PsiParameter parameter2 = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda2.getParameterList().getParameters());
        if (parameter2 == null) {
            return null;
        }
        ChainCallExtractor extractor = ChainCallExtractor.findExtractor(lambda2, initializer, variable.getType());
        if (extractor == null) {
            return null;
        }
        String newMethodName = extractor.fixCallName(call, variable.getType());
        String mapOperation = extractor.buildChainCall((PsiVariable)parameter2, initializer, variable.getType());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        if (!mapOperation.isEmpty()) {
            qualifier = (PsiExpression)qualifier.replace((PsiElement)factory.createExpressionFromText(qualifier.getText() + mapOperation, (PsiElement)qualifier));
        }
        parameter2 = (PsiParameter)parameter2.replace((PsiElement)factory.createParameter(variable.getName(), variable.getType(), (PsiElement)parameter2));
        variable.delete();
        LambdaRefactoringUtil.simplifyToExpressionLambda(lambda2);
        PsiTypeElement typeElement = parameter2.getTypeElement();
        if (typeElement != null) {
            typeElement.delete();
        }
        ExpressionUtils.bindCallTo(call, newMethodName);
        if (qualifier instanceof PsiMethodCallExpression && (newLambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])((PsiMethodCallExpression)qualifier).getArgumentList().getExpressions()), PsiLambdaExpression.class)) != null) {
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(newLambda);
        }
        call = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)call);
        return (PsiLambdaExpression)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions()), PsiLambdaExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/chainCall/ChainCallExtractor", "extractMappingStep"));
    }
}

