/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JvmCommon;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyRequest;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class CreateBeanPropertyFixes {
    public static LocalQuickFix[] createFixes(String propertyName, @NotNull @JvmCommon PsiClass psiClass, @Nullable PsiType type2, boolean createSetter) {
        if (psiClass == null) {
            CreateBeanPropertyFixes.$$$reportNull$$$0(0);
        }
        return IntentionWrapper.wrapToQuickFixes((IntentionAction[])CreateBeanPropertyFixes.createActions(propertyName, psiClass, type2, createSetter), (PsiFile)psiClass.getContainingFile());
    }

    public static IntentionAction[] createActions(String propertyName, @NotNull @JvmCommon PsiClass psiClass, @Nullable PsiType type2, boolean createSetter) {
        if (psiClass == null) {
            CreateBeanPropertyFixes.$$$reportNull$$$0(1);
        }
        if (psiClass instanceof PsiCompiledElement) {
            return IntentionAction.EMPTY_ARRAY;
        }
        Project project = psiClass.getProject();
        if (type2 == null) {
            type2 = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.String", GlobalSearchScope.allScope((Project)project));
        }
        PropertyKind propertyKind = createSetter ? PropertyKind.SETTER : PropertyKind.GETTER;
        CreateBeanPropertyRequest request = new CreateBeanPropertyRequest(psiClass.getProject(), propertyName, propertyKind, type2);
        return JvmElementActionFactories.createMethodActions((JvmClass)psiClass, (CreateMethodRequest)request).toArray(IntentionAction.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiClass";
        objectArray2[1] = "com/intellij/psi/impl/beanProperties/CreateBeanPropertyFixes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

