/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.SdkTypeId;
import java.util.Collection;
import java.util.List;

public class DefaultJdkConfigurator
implements BaseComponent {
    private final JavaSdk myJavaSdk;
    private final PropertiesComponent myPropertiesComponent;
    private final ProjectJdkTable myProjectJdkTable;

    public DefaultJdkConfigurator(JavaSdk javaSdk, PropertiesComponent propertiesComponent, ProjectJdkTable projectJdkTable) {
        this.myJavaSdk = javaSdk;
        this.myPropertiesComponent = propertiesComponent;
        this.myProjectJdkTable = projectJdkTable;
    }

    public void initComponent() {
        if (this.myPropertiesComponent.getBoolean("defaultJdkConfigured", false)) {
            return;
        }
        List jdks = this.myProjectJdkTable.getSdksOfType((SdkTypeId)this.myJavaSdk);
        if (jdks.isEmpty()) {
            String suggestedName;
            Collection homePaths = this.myJavaSdk.suggestHomePaths();
            if (homePaths.isEmpty()) {
                return;
            }
            String homePath = (String)homePaths.iterator().next();
            if (homePath != null && this.myJavaSdk.isValidSdkHome(homePath) && (suggestedName = this.myJavaSdk.suggestSdkName(null, homePath)) != null) {
                ApplicationManager.getApplication().runWriteAction(() -> this.myProjectJdkTable.addJdk(this.myJavaSdk.createJdk(suggestedName, homePath, false)));
            }
        }
        this.myPropertiesComponent.setValue("defaultJdkConfigured", true);
    }
}

