/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RemoteRepositoriesConfiguration", storages={@Storage(value="jarRepositories.xml")})
public class RemoteRepositoriesConfiguration
implements PersistentStateComponent<State> {
    private final List<RemoteRepositoryDescription> myRepositories = new SmartList();

    public RemoteRepositoriesConfiguration() {
        this(RemoteRepositoryDescription.DEFAULT_REPOSITORIES);
    }

    public RemoteRepositoriesConfiguration(Collection<? extends RemoteRepositoryDescription> repos) {
        this.myRepositories.addAll(repos);
    }

    @NotNull
    public static RemoteRepositoriesConfiguration getInstance(Project project) {
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = (RemoteRepositoriesConfiguration)ServiceManager.getService((Project)project, RemoteRepositoriesConfiguration.class);
        if (remoteRepositoriesConfiguration == null) {
            RemoteRepositoriesConfiguration.$$$reportNull$$$0(0);
        }
        return remoteRepositoriesConfiguration;
    }

    @NotNull
    public List<RemoteRepositoryDescription> getRepositories() {
        List<RemoteRepositoryDescription> list = Collections.unmodifiableList(this.myRepositories);
        if (list == null) {
            RemoteRepositoriesConfiguration.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void resetToDefault() {
        this.setRepositories(Collections.emptyList());
    }

    public void setRepositories(@NotNull List<? extends RemoteRepositoryDescription> repos) {
        if (repos == null) {
            RemoteRepositoriesConfiguration.$$$reportNull$$$0(2);
        }
        this.myRepositories.clear();
        this.myRepositories.addAll(repos.isEmpty() ? RemoteRepositoryDescription.DEFAULT_REPOSITORIES : repos);
    }

    @Nullable
    public State getState() {
        return new State(this.myRepositories);
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            RemoteRepositoriesConfiguration.$$$reportNull$$$0(3);
        }
        SmartList loaded = new SmartList();
        if (state.data != null) {
            for (State.Repo repo : state.data) {
                loaded.add(new RemoteRepositoryDescription(repo.id, repo.name, repo.url));
            }
        }
        this.setRepositories((List<? extends RemoteRepositoryDescription>)loaded);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoriesConfiguration that = (RemoteRepositoriesConfiguration)o;
        return this.myRepositories.equals(that.myRepositories);
    }

    public int hashCode() {
        return this.myRepositories.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/RemoteRepositoriesConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/RemoteRepositoriesConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRepositories";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class State {
        @Property(surroundWithTag=false)
        @XCollection
        @NotNull
        public final List<Repo> data = new SmartList();

        State() {
            this(RemoteRepositoryDescription.DEFAULT_REPOSITORIES);
        }

        State(List<? extends RemoteRepositoryDescription> repos) {
            for (RemoteRepositoryDescription remoteRepositoryDescription : repos) {
                this.data.add(new Repo(remoteRepositoryDescription.getId(), remoteRepositoryDescription.getName(), remoteRepositoryDescription.getUrl()));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.data.equals(state.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        @Tag(value="remote-repository")
        static class Repo {
            public String id;
            public String name;
            public String url;

            Repo() {
            }

            Repo(String id, String name, String url) {
                this.id = id;
                this.name = name;
                this.url = url;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Repo repo = (Repo)o;
                if (this.id != null ? !this.id.equals(repo.id) : repo.id != null) {
                    return false;
                }
                if (this.name != null ? !this.name.equals(repo.name) : repo.name != null) {
                    return false;
                }
                return !(this.url != null ? !this.url.equals(repo.url) : repo.url != null);
            }

            public int hashCode() {
                int result = this.id != null ? this.id.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
}

