/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpecialFirstIterationLoop {
    @NotNull
    private final List<PsiStatement> myFirstIterationStatements;
    @NotNull
    private final List<PsiStatement> myOtherIterationStatements;
    @Nullable
    private final PsiLocalVariable myVariable;

    SpecialFirstIterationLoop(@NotNull List<PsiStatement> firstIterationStatements, @NotNull List<PsiStatement> otherIterationStatements, @Nullable PsiLocalVariable variable) {
        if (firstIterationStatements == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(0);
        }
        if (otherIterationStatements == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(1);
        }
        this.myFirstIterationStatements = firstIterationStatements;
        this.myOtherIterationStatements = otherIterationStatements;
        this.myVariable = variable;
    }

    @NotNull
    public List<PsiStatement> getOtherIterationStatements() {
        List<PsiStatement> list = this.myOtherIterationStatements;
        if (list == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<PsiStatement> getFirstIterationStatements() {
        List<PsiStatement> list = this.myFirstIterationStatements;
        if (list == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public PsiLocalVariable getVariable() {
        return this.myVariable;
    }

    @Contract(value="null -> null")
    @Nullable
    static PsiExpression getExpressionComparedToZero(@Nullable PsiBinaryExpression condition2) {
        if (condition2 == null) {
            return null;
        }
        IElementType tokenType = condition2.getOperationTokenType();
        PsiExpression left = condition2.getLOperand();
        PsiExpression right = condition2.getROperand();
        if (ExpressionUtils.isZero(right)) {
            if (tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.GT)) {
                return left;
            }
        } else if (ExpressionUtils.isZero(left) && (tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.LT))) {
            return right;
        }
        return null;
    }

    @Nullable
    private static SpecialFirstIterationLoop extract(boolean firstIterationThen, int index, @NotNull List<PsiStatement> statements, @NotNull PsiLocalVariable checkVar) {
        PsiStatement statement;
        PsiIfStatement ifStatement;
        if (statements == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(4);
        }
        if (checkVar == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(5);
        }
        if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)(statement = statements.get(index)), PsiIfStatement.class)) == null) {
            return null;
        }
        List<PsiStatement> thenStatements = SpecialFirstIterationLoop.unwrapBlock(ifStatement.getThenBranch());
        List<PsiStatement> elseStatements = SpecialFirstIterationLoop.unwrapBlock(ifStatement.getElseBranch());
        return SpecialFirstIterationLoop.extract(firstIterationThen, index, thenStatements, elseStatements, statements, checkVar);
    }

    @Nullable
    private static SpecialFirstIterationLoop extract(boolean firstIterationThen, int index, @NotNull List<PsiStatement> thenStatements, @NotNull List<PsiStatement> elseStatements, @NotNull List<PsiStatement> statements, @NotNull PsiLocalVariable checkVar) {
        PsiStatement statement;
        PsiIfStatement ifStatement;
        if (thenStatements == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(6);
        }
        if (elseStatements == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(7);
        }
        if (statements == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(8);
        }
        if (checkVar == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(9);
        }
        if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)(statement = statements.get(index)), PsiIfStatement.class)) == null) {
            return null;
        }
        List<PsiStatement> beforeStatements = statements.subList(0, index);
        List<PsiStatement> afterStatements = statements.subList(index + 1, statements.size());
        ArrayList<PsiStatement> firstIteration = new ArrayList<PsiStatement>(beforeStatements);
        ArrayList<PsiStatement> otherIterations = new ArrayList<PsiStatement>(beforeStatements);
        firstIteration.addAll(firstIterationThen ? thenStatements : elseStatements);
        firstIteration.addAll(afterStatements);
        otherIterations.addAll(firstIterationThen ? elseStatements : thenStatements);
        otherIterations.addAll(afterStatements);
        return new SpecialFirstIterationLoop(firstIteration, otherIterations, checkVar);
    }

    private static int getSingleStatementIndex(@NotNull List<PsiStatement> statements, @NotNull Predicate<PsiStatement> predicate) {
        if (statements == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(10);
        }
        if (predicate == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(11);
        }
        int index = -1;
        for (int i = 0; i < statements.size(); ++i) {
            PsiStatement statement = statements.get(i);
            if (!predicate.test(statement)) continue;
            if (index != -1) {
                return -1;
            }
            index = i;
        }
        return index;
    }

    private static int getSingleAssignmentIndex(@NotNull List<PsiStatement> statements) {
        if (statements == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(12);
        }
        return SpecialFirstIterationLoop.getSingleStatementIndex(statements, statement -> ExpressionUtils.getAssignment((PsiElement)statement) != null);
    }

    @NotNull
    private static List<PsiStatement> unwrapBlock(@Nullable PsiStatement statement) {
        if (statement == null) {
            List<PsiStatement> list = Collections.emptyList();
            if (list == null) {
                SpecialFirstIterationLoop.$$$reportNull$$$0(13);
            }
            return list;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)statement, PsiBlockStatement.class);
        if (blockStatement == null) {
            List<PsiStatement> list = Collections.singletonList(statement);
            if (list == null) {
                SpecialFirstIterationLoop.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])blockStatement.getCodeBlock().getStatements());
        if (arrayList == null) {
            SpecialFirstIterationLoop.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstIterationStatements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherIterationStatements";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/SpecialFirstIterationLoop";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkVar";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenStatements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseStatements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/SpecialFirstIterationLoop";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherIterationStatements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstIterationStatements";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSingleStatementIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSingleAssignmentIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class IndexBasedLoop {
        private IndexBasedLoop() {
        }

        @Nullable
        static SpecialFirstIterationLoop extract(@NotNull TerminalBlock terminalBlock) {
            StreamApiMigrationInspection.CountingLoopSource countingLoopSource;
            if (terminalBlock == null) {
                IndexBasedLoop.$$$reportNull$$$0(0);
            }
            if ((countingLoopSource = terminalBlock.getLastOperation(StreamApiMigrationInspection.CountingLoopSource.class)) == null) {
                return null;
            }
            PsiVariable loopVar = countingLoopSource.getVariable();
            PsiLocalVariable loopLocalVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)loopVar, PsiLocalVariable.class);
            if (loopLocalVar == null) {
                return null;
            }
            ArrayList statements = ContainerUtil.newArrayList((Object[])terminalBlock.getStatements());
            int index = SpecialFirstIterationLoop.getSingleStatementIndex(statements, statement -> statement instanceof PsiIfStatement);
            if (index == -1) {
                return null;
            }
            ThreeState firstIterationThen = IndexBasedLoop.isFirstIterationThen((PsiStatement)statements.get(index), loopVar);
            if (firstIterationThen.equals((Object)ThreeState.UNSURE)) {
                return null;
            }
            return SpecialFirstIterationLoop.extract(firstIterationThen.toBoolean(), index, statements, loopLocalVar);
        }

        @NotNull
        private static ThreeState isFirstIterationThen(@NotNull PsiStatement statement, @NotNull PsiVariable loopVar) {
            PsiIfStatement ifStatement;
            if (statement == null) {
                IndexBasedLoop.$$$reportNull$$$0(1);
            }
            if (loopVar == null) {
                IndexBasedLoop.$$$reportNull$$$0(2);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    IndexBasedLoop.$$$reportNull$$$0(3);
                }
                return threeState;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    IndexBasedLoop.$$$reportNull$$$0(4);
                }
                return threeState;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition2, PsiBinaryExpression.class);
            if (binaryExpression == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    IndexBasedLoop.$$$reportNull$$$0(5);
                }
                return threeState;
            }
            PsiExpression comparedEqWithZero = ExpressionUtils.getValueComparedWithZero(binaryExpression);
            if (comparedEqWithZero != null) {
                if (!ExpressionUtils.isReferenceTo(comparedEqWithZero, loopVar)) {
                    ThreeState threeState = ThreeState.UNSURE;
                    if (threeState == null) {
                        IndexBasedLoop.$$$reportNull$$$0(6);
                    }
                    return threeState;
                }
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    IndexBasedLoop.$$$reportNull$$$0(7);
                }
                return threeState;
            }
            PsiExpression notEqWithZero = SpecialFirstIterationLoop.getExpressionComparedToZero(binaryExpression);
            if (notEqWithZero == null || !ExpressionUtils.isReferenceTo(notEqWithZero, loopVar)) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    IndexBasedLoop.$$$reportNull$$$0(8);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                IndexBasedLoop.$$$reportNull$$$0(9);
            }
            return threeState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "terminalBlock";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopVar";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/SpecialFirstIterationLoop$IndexBasedLoop";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/SpecialFirstIterationLoop$IndexBasedLoop";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isFirstIterationThen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extract";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isFirstIterationThen";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class BoolFlagLoop {
        private BoolFlagLoop() {
        }

        @Nullable
        static SpecialFirstIterationLoop extract(TerminalBlock terminalBlock) {
            ArrayList statements = ContainerUtil.newArrayList((Object[])terminalBlock.getStatements());
            int index = SpecialFirstIterationLoop.getSingleStatementIndex(statements, PsiIfStatement.class::isInstance);
            if (index == -1) {
                return null;
            }
            PsiStatement statement = (PsiStatement)statements.get(index);
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
            if (ifStatement == null) {
                return null;
            }
            ThreeState firstIterationThen = BoolFlagLoop.isFirstIterationThen(statement);
            if (firstIterationThen.equals((Object)ThreeState.UNSURE)) {
                return null;
            }
            ConditionData conditionData = ConditionData.extract(ifStatement, firstIterationThen.toBoolean());
            if (conditionData == null) {
                return null;
            }
            PsiAssignmentExpression assignment = conditionData.getAssignment();
            PsiExpression expression2 = assignment.getLExpression();
            PsiLocalVariable boolFlag = ExpressionUtils.resolveLocalVariable(expression2);
            if (boolFlag == null) {
                return null;
            }
            PsiExpression rExpression = assignment.getRExpression();
            if (rExpression == null) {
                return null;
            }
            if (!BoolFlagLoop.assignmentNegatesInitializer((PsiVariable)boolFlag, rExpression)) {
                return null;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            boolean referencesAllowed = ReferencesSearch.search((PsiElement)boolFlag).forEach(reference -> PsiTreeUtil.isAncestor((PsiElement)condition2, (PsiElement)reference.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)assignment, (PsiElement)reference.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)boolFlag, (PsiElement)reference.getElement(), (boolean)false));
            if (!referencesAllowed) {
                return null;
            }
            return SpecialFirstIterationLoop.extract(firstIterationThen.toBoolean(), index, conditionData.getThenStatements(), conditionData.getElseStatements(), statements, boolFlag);
        }

        private static boolean assignmentNegatesInitializer(@NotNull PsiVariable boolFlag, @NotNull PsiExpression expression2) {
            Object constantExpression;
            if (boolFlag == null) {
                BoolFlagLoop.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                BoolFlagLoop.$$$reportNull$$$0(1);
            }
            if (!((constantExpression = ExpressionUtils.computeConstantExpression(expression2)) instanceof Boolean)) {
                return false;
            }
            boolean assignmentValue = (Boolean)constantExpression;
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)boolFlag.getInitializer()), !assignmentValue);
        }

        @NotNull
        private static ThreeState isFirstIterationThen(@NotNull PsiStatement statement) {
            PsiIfStatement ifStatement;
            if (statement == null) {
                BoolFlagLoop.$$$reportNull$$$0(2);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    BoolFlagLoop.$$$reportNull$$$0(3);
                }
                return threeState;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    BoolFlagLoop.$$$reportNull$$$0(4);
                }
                return threeState;
            }
            boolean negated = BoolUtils.isNegation(condition2);
            condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2);
            PsiExpression expression2 = negated ? BoolUtils.getNegated(condition2) : condition2;
            PsiLocalVariable boolFlagVar = ExpressionUtils.resolveLocalVariable(expression2);
            if (boolFlagVar == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    BoolFlagLoop.$$$reportNull$$$0(5);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.fromBoolean((boolean)ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)boolFlagVar.getInitializer()), !negated));
            if (threeState == null) {
                BoolFlagLoop.$$$reportNull$$$0(6);
            }
            return threeState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boolFlag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/SpecialFirstIterationLoop$BoolFlagLoop";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/SpecialFirstIterationLoop$BoolFlagLoop";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isFirstIterationThen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "assignmentNegatesInitializer";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isFirstIterationThen";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ConditionData {
            @NotNull
            private final List<PsiStatement> myThenStatements;
            @NotNull
            private final List<PsiStatement> myElseStatements;
            @NotNull
            private final PsiAssignmentExpression myAssignment;

            private ConditionData(@NotNull List<PsiStatement> thenStatements, @NotNull List<PsiStatement> elseStatements, @NotNull PsiAssignmentExpression assignment) {
                if (thenStatements == null) {
                    ConditionData.$$$reportNull$$$0(0);
                }
                if (elseStatements == null) {
                    ConditionData.$$$reportNull$$$0(1);
                }
                if (assignment == null) {
                    ConditionData.$$$reportNull$$$0(2);
                }
                this.myThenStatements = thenStatements;
                this.myElseStatements = elseStatements;
                this.myAssignment = assignment;
            }

            @NotNull
            public PsiAssignmentExpression getAssignment() {
                PsiAssignmentExpression psiAssignmentExpression = this.myAssignment;
                if (psiAssignmentExpression == null) {
                    ConditionData.$$$reportNull$$$0(3);
                }
                return psiAssignmentExpression;
            }

            @NotNull
            public List<PsiStatement> getElseStatements() {
                List<PsiStatement> list = this.myElseStatements;
                if (list == null) {
                    ConditionData.$$$reportNull$$$0(4);
                }
                return list;
            }

            @NotNull
            public List<PsiStatement> getThenStatements() {
                List<PsiStatement> list = this.myThenStatements;
                if (list == null) {
                    ConditionData.$$$reportNull$$$0(5);
                }
                return list;
            }

            @Nullable
            static ConditionData extract(@NotNull PsiIfStatement ifStatement, boolean firstIterationThen) {
                PsiStatement block;
                ArrayList<PsiStatement> firstIterationStatements;
                int index;
                if (ifStatement == null) {
                    ConditionData.$$$reportNull$$$0(6);
                }
                if ((index = SpecialFirstIterationLoop.getSingleAssignmentIndex(firstIterationStatements = new ArrayList<PsiStatement>(SpecialFirstIterationLoop.unwrapBlock(block = firstIterationThen ? ifStatement.getThenBranch() : ifStatement.getElseBranch())))) == -1) {
                    return null;
                }
                PsiStatement assignment = (PsiStatement)firstIterationStatements.remove(index);
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)assignment, PsiExpressionStatement.class);
                if (expressionStatement == null) {
                    return null;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiAssignmentExpression.class);
                if (assignmentExpression == null) {
                    return null;
                }
                PsiStatement otherBlock = firstIterationThen ? ifStatement.getElseBranch() : ifStatement.getThenBranch();
                List otherIterationStatements = SpecialFirstIterationLoop.unwrapBlock(otherBlock);
                return firstIterationThen ? new ConditionData(firstIterationStatements, otherIterationStatements, assignmentExpression) : new ConditionData(otherIterationStatements, firstIterationStatements, assignmentExpression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "thenStatements";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elseStatements";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignment";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/streamMigration/SpecialFirstIterationLoop$BoolFlagLoop$ConditionData";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ifStatement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/streamMigration/SpecialFirstIterationLoop$BoolFlagLoop$ConditionData";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAssignment";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElseStatements";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getThenStatements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "extract";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

