/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class InstanceofExpressionPostfixTemplate
extends PostfixTemplate {
    public InstanceofExpressionPostfixTemplate() {
        this("instanceof");
    }

    public InstanceofExpressionPostfixTemplate(String alias) {
        super(alias, "expr instanceof Type ? ((Type) expr). : null");
    }

    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            InstanceofExpressionPostfixTemplate.$$$reportNull$$$0(0);
        }
        if (copyDocument == null) {
            InstanceofExpressionPostfixTemplate.$$$reportNull$$$0(1);
        }
        return JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression(JavaPostfixTemplatesUtils.getTopmostExpression(context));
    }

    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        PsiExpression expression2;
        if (context == null) {
            InstanceofExpressionPostfixTemplate.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            InstanceofExpressionPostfixTemplate.$$$reportNull$$$0(3);
        }
        if (!JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression(expression2 = JavaPostfixTemplatesUtils.getTopmostExpression(context))) {
            return;
        }
        InstanceofExpressionPostfixTemplate.surroundExpression(context.getProject(), editor, expression2);
    }

    private static void surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull PsiExpression expr) throws IncorrectOperationException {
        TextRange range;
        if (project == null) {
            InstanceofExpressionPostfixTemplate.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            InstanceofExpressionPostfixTemplate.$$$reportNull$$$0(5);
        }
        if (expr == null) {
            InstanceofExpressionPostfixTemplate.$$$reportNull$$$0(6);
        }
        assert (expr.isValid());
        PsiType[] types = GuessManager.getInstance(project).guessTypeToCast(expr);
        boolean parenthesesNeeded = expr instanceof PsiPolyadicExpression || expr instanceof PsiConditionalExpression || expr instanceof PsiAssignmentExpression;
        String exprText = parenthesesNeeded ? "(" + expr.getText() + ")" : expr.getText();
        Template template = InstanceofExpressionPostfixTemplate.generateTemplate(project, exprText, types);
        if (expr.isPhysical()) {
            range = expr.getTextRange();
        } else {
            RangeMarker rangeMarker = (RangeMarker)expr.getUserData(ElementToWorkOn.TEXT_RANGE);
            if (rangeMarker == null) {
                PostfixTemplatesUtils.showErrorHint((Project)project, (Editor)editor);
                return;
            }
            range = new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        }
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
    }

    private static Template generateTemplate(Project project, String exprText, PsiType[] suggestedTypes) {
        Object type22;
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        LinkedHashSet<PsiTypeLookupItem> itemSet = new LinkedHashSet<PsiTypeLookupItem>();
        for (Object type22 : suggestedTypes) {
            itemSet.add(PsiTypeLookupItem.createLookupItem(type22, null));
        }
        final LookupElement[] lookupItems = itemSet.toArray(LookupElement.EMPTY_ARRAY);
        PsiTypeResult result = suggestedTypes.length > 0 ? new PsiTypeResult(suggestedTypes[0], project) : null;
        Expression expr = new Expression((Result)result){
            final /* synthetic */ Result val$result;
            {
                this.val$result = result;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return lookupItems.length > 1 ? lookupItems : null;
            }

            public Result calculateResult(ExpressionContext context) {
                return this.val$result;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }
        };
        template.addTextSegment(exprText);
        template.addTextSegment(" instanceof ");
        type22 = "type";
        template.addVariable((String)type22, expr, expr, true);
        template.addTextSegment(" ? ((");
        template.addVariableSegment((String)type22);
        template.addTextSegment(")" + exprText + ")");
        template.addEndVariable();
        template.addTextSegment(" : null;");
        return template;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyDocument";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/InstanceofExpressionPostfixTemplate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "expand";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

