/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.ElementProcessingHintPass;
import com.intellij.codeInsight.hints.ModificationStampHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002JH\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000326\u0010\u0013\u001a2\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00100\u0014H&J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH&J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H&J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H&R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/codeInsight/hints/ElementProcessingHintPass;", "Lcom/intellij/codeHighlighting/EditorBoundHighlightingPass;", "rootElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "modificationStampHolder", "Lcom/intellij/codeInsight/hints/ModificationStampHolder;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/hints/ModificationStampHolder;)V", "hints", "Lgnu/trove/TIntObjectHashMap;", "Lcom/intellij/util/SmartList;", "", "traverser", "Lcom/intellij/psi/SyntaxTraverser;", "applyHintsToEditor", "", "collectElementHints", "element", "collector", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "offset", "hint", "createRenderer", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "text", "doApplyInformationToEditor", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getHintKey", "Lcom/intellij/openapi/util/Key;", "", "isAvailable", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.java.impl"})
public abstract class ElementProcessingHintPass
extends EditorBoundHighlightingPass {
    private final SyntaxTraverser<PsiElement> traverser;
    private final TIntObjectHashMap<SmartList<String>> hints;
    private final PsiElement rootElement;
    private final ModificationStampHolder modificationStampHolder;

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        boolean bl2 = bl = this.myDocument != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.hints.clear();
        PsiFile psiFile = this.rootElement.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return;
        }
        PsiFile virtualFile = psiFile;
        if (this.isAvailable((VirtualFile)virtualFile)) {
            Iterable $receiver$iv = (Iterable)this.traverser;
            for (Object element$iv : $receiver$iv) {
                PsiElement it;
                PsiElement psiElement = it = (PsiElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
                this.collectElementHints(psiElement, (Function2<? super Integer, ? super String, Unit>)((Function2)new Function2<Integer, String, Unit>(this){
                    final /* synthetic */ ElementProcessingHintPass this$0;
                    {
                        this.this$0 = elementProcessingHintPass;
                        super(2);
                    }

                    public final void invoke(int offset, @NotNull String hint) {
                        Intrinsics.checkParameterIsNotNull((Object)hint, (String)"hint");
                        SmartList hintList = (SmartList)ElementProcessingHintPass.access$getHints$p(this.this$0).get(offset);
                        if (hintList == null) {
                            hintList = new SmartList();
                            ElementProcessingHintPass.access$getHints$p(this.this$0).put(offset, (Object)hintList);
                        }
                        hintList.add((Object)hint);
                    }
                }));
            }
        }
    }

    public void doApplyInformationToEditor() {
        CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(this.myEditor);
        this.applyHintsToEditor();
        keeper.restoreOriginalLocation(false);
        if (this.rootElement == this.myFile) {
            Editor editor = this.myEditor;
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myEditor");
            PsiFile psiFile = this.myFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"myFile");
            this.modificationStampHolder.putCurrentModificationStamp(editor, psiFile);
        }
    }

    public abstract boolean isAvailable(@NotNull VirtualFile var1);

    public abstract void collectElementHints(@NotNull PsiElement var1, @NotNull Function2<? super Integer, ? super String, Unit> var2);

    @NotNull
    public abstract Key<Boolean> getHintKey();

    @NotNull
    public abstract HintRenderer createRenderer(@NotNull String var1);

    private final void applyHintsToEditor() {
        Object[] $receiver$iv$iv;
        Editor editor = this.myEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myEditor");
        InlayModel inlayModel = editor.getInlayModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)inlayModel, (String)"myEditor.inlayModel");
        InlayModel inlayModel2 = inlayModel;
        TextRange textRange = this.rootElement.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"rootElement.textRange");
        int n = textRange.getStartOffset() + 1;
        TextRange textRange2 = this.rootElement.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"rootElement.textRange");
        List list = inlayModel2.getInlineElementsInRange(n, textRange2.getEndOffset() - 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"inlayModel.getInlineElem\u2026.textRange.endOffset - 1)");
        Object[] $receiver$iv = (Object[])list;
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object t : $receiver$iv$iv) {
            boolean bl;
            Inlay it = (Inlay)t;
            if (this.getHintKey().isIn((UserDataHolder)it)) {
                Inlay inlay = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)inlay, (String)"it");
                SmartList hintsList = (SmartList)this.hints.get(inlay.getOffset());
                bl = hintsList == null || !CollectionsKt.removeAll((List)((List)hintsList), (Function1)((Function1)new Function1<String, Boolean>(it){
                    final /* synthetic */ Inlay $it;

                    public final boolean invoke(@NotNull String hintText) {
                        Intrinsics.checkParameterIsNotNull((Object)hintText, (String)"hintText");
                        Inlay inlay = this.$it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)inlay, (String)"it");
                        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
                        if (editorCustomElementRenderer == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.HintRenderer");
                        }
                        return Intrinsics.areEqual((Object)hintText, (Object)((HintRenderer)editorCustomElementRenderer).getText());
                    }
                    {
                        this.$it = inlay;
                        super(1);
                    }
                }));
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(t);
        }
        List toRemove2 = (List)destination$iv$iv;
        Editor editor2 = this.myEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"myEditor");
        Document document = editor2.getDocument();
        int n2 = toRemove2.size();
        Object[] objectArray2 = this.hints.getValues();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"hints.values");
        $receiver$iv = objectArray2;
        int n3 = n2;
        Document document2 = document;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Object[] objectArray3 = $receiver$iv$iv;
        int n4 = objectArray3.length;
        for (int i = 0; i < n4; ++i) {
            Object element$iv$iv;
            Object it;
            Object object = it = (element$iv$iv = objectArray3[i]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.SmartList<*>");
            }
            Iterable list$iv$iv = (Iterable)((SmartList)object);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        Collection collection = list2;
        int n5 = collection.size();
        DocumentUtil.executeInBulk((Document)document2, (n3 + n5 > 1000 ? 1 : 0) != 0, (Runnable)new Runnable(this, toRemove2, inlayModel2){
            final /* synthetic */ ElementProcessingHintPass this$0;
            final /* synthetic */ List $toRemove;
            final /* synthetic */ InlayModel $inlayModel;

            public final void run() {
                Iterable $receiver$iv = this.$toRemove;
                for (T element$iv : $receiver$iv) {
                    Inlay it = (Inlay)element$iv;
                    Disposer.dispose((Disposable)((Disposable)it));
                }
                ElementProcessingHintPass.access$getHints$p(this.this$0).forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<SmartList<String>>(this){
                    final /* synthetic */ applyHintsToEditor.2 this$0;

                    public final boolean execute(int offset, SmartList<String> hintTexts) {
                        SmartList<String> smartList = hintTexts;
                        Intrinsics.checkExpressionValueIsNotNull(smartList, (String)"hintTexts");
                        Iterable $receiver$iv = (Iterable)smartList;
                        for (T element$iv : $receiver$iv) {
                            Inlay inlay;
                            String it = (String)element$iv;
                            InlayModel inlayModel = this.this$0.$inlayModel;
                            ElementProcessingHintPass elementProcessingHintPass = this.this$0.this$0;
                            String string = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                            Inlay inlay2 = inlay = inlayModel.addInlineElement(offset, (EditorCustomElementRenderer)elementProcessingHintPass.createRenderer(string));
                            if (inlay2 == null) continue;
                            inlay2.putUserData(this.this$0.this$0.getHintKey(), (Object)true);
                        }
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = elementProcessingHintPass;
                this.$toRemove = list;
                this.$inlayModel = inlayModel;
            }
        });
    }

    public ElementProcessingHintPass(@NotNull PsiElement rootElement, @NotNull Editor editor, @NotNull ModificationStampHolder modificationStampHolder) {
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)modificationStampHolder, (String)"modificationStampHolder");
        super(editor, rootElement.getContainingFile(), true);
        this.rootElement = rootElement;
        this.modificationStampHolder = modificationStampHolder;
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)this.rootElement);
        Intrinsics.checkExpressionValueIsNotNull((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(rootElement)");
        this.traverser = syntaxTraverser;
        this.hints = new TIntObjectHashMap();
    }

    @NotNull
    public static final /* synthetic */ TIntObjectHashMap access$getHints$p(ElementProcessingHintPass $this) {
        return $this.hints;
    }
}

