/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedParameterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public RemoveUnusedParameterFix(PsiParameter parameter2) {
        super((PsiElement)parameter2);
        this.myName = parameter2.getName();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.unused.parameter.text", this.myName);
        if (string == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.unused.parameter.family", new Object[0]);
        if (string == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiParameter myParameter;
        if (project == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(5);
        }
        return (myParameter = (PsiParameter)startElement).getDeclarationScope() instanceof PsiMethod && BaseIntentionAction.canModify((PsiElement)myParameter);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            RemoveUnusedParameterFix.$$$reportNull$$$0(9);
        }
        PsiParameter myParameter = (PsiParameter)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myParameter.getContainingFile())) {
            return;
        }
        RemoveUnusedParameterFix.removeReferences(myParameter);
    }

    public static void removeReferences(PsiParameter parameter2) {
        PsiMethod method = (PsiMethod)parameter2.getDeclarationScope();
        ChangeSignatureProcessor processor = new ChangeSignatureProcessor(parameter2.getProject(), method, false, null, method.getName(), method.getReturnType(), ParameterInfoImpl.fromMethodExceptParameter(method, parameter2));
        processor.run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

