/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ExpectedTypeUtil");

    @NotNull
    public static ExpectedTypeInfo[] intersect(List<ExpectedTypeInfo[]> typeInfos) {
        if (typeInfos.isEmpty()) {
            if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                ExpectedTypeUtil.$$$reportNull$$$0(0);
            }
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        ExpectedTypeInfos result = new ExpectedTypeInfos(typeInfos.get(0));
        ExpectedTypeInfos acc = new ExpectedTypeInfos();
        for (int i = 1; i < typeInfos.size(); ++i) {
            ExpectedTypeInfo[] next = typeInfos.get(i);
            acc.clear();
            for (ExpectedTypeInfo info : next) {
                Iterator<ExpectedTypeInfo> iterator = result.iterator();
                while (iterator.hasNext()) {
                    ExpectedTypeInfo[] intersection;
                    for (ExpectedTypeInfo aIntersection : intersection = iterator.next().intersect(info)) {
                        acc.addInfo(aIntersection);
                    }
                }
            }
            if (acc.isEmpty()) {
                if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                    ExpectedTypeUtil.$$$reportNull$$$0(1);
                }
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            result = new ExpectedTypeInfos(acc.toArray());
        }
        ExpectedTypeInfo[] expectedTypeInfoArray = result.toArray();
        if (expectedTypeInfoArray == null) {
            ExpectedTypeUtil.$$$reportNull$$$0(2);
        }
        return expectedTypeInfoArray;
    }

    public static int contains(ExpectedTypeInfo info1, ExpectedTypeInfo info2) {
        int kind2;
        int kind1 = info1.getKind();
        if (kind1 == (kind2 = info2.getKind())) {
            if (ExpectedTypeUtil.matchesStrictly(info1.getType(), info2)) {
                return -1;
            }
            if (ExpectedTypeUtil.matchesStrictly(info2.getType(), info1)) {
                return 1;
            }
            return 0;
        }
        if (kind1 == 0) {
            return ExpectedTypeUtil.matches(info1.getType(), info2) ? -1 : 0;
        }
        if (kind2 == 0) {
            return ExpectedTypeUtil.matches(info2.getType(), info1) ? 1 : 0;
        }
        return 0;
    }

    private static boolean matchesStrictly(PsiType type2, ExpectedTypeInfo info) {
        return type2 instanceof PsiPrimitiveType == info.getType() instanceof PsiPrimitiveType && ExpectedTypeUtil.matches(type2, info);
    }

    public static boolean matches(PsiType type2, ExpectedTypeInfo info) {
        PsiType infoType = info.getType();
        switch (info.getKind()) {
            case 0: {
                return type2.equals(infoType);
            }
            case 1: {
                return infoType.isAssignableFrom(type2);
            }
            case 2: {
                return type2.isAssignableFrom(infoType);
            }
            case 3: {
                return type2.isAssignableFrom(info.getDefaultType()) && infoType.isAssignableFrom(type2);
            }
            case 4: {
                return true;
            }
        }
        LOG.error("Unexpected ExpectedInfo kind");
        return false;
    }

    @Nullable
    public static PsiSubstitutor inferSubstitutor(PsiMethod method, PsiMethodCallExpression callExpr, boolean forCompletion) {
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiExpression[] args = callExpr.getArgumentList().getExpressions();
        PsiSubstitutor result = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method.getContainingClass())) {
            PsiType type2 = helper.inferTypeForMethodTypeParameter(typeParameter, parameters2, args, PsiSubstitutor.EMPTY, callExpr.getParent(), (ParameterTypeInferencePolicy)(forCompletion ? CompletionParameterTypeInferencePolicy.INSTANCE : DefaultParameterTypeInferencePolicy.INSTANCE));
            if (PsiType.NULL.equals((Object)type2)) {
                return null;
            }
            result = result.put(typeParameter, type2);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeUtil", "intersect"));
    }

    public static class ExpectedClassesFromSetProvider
    implements ExpectedTypesProvider.ExpectedClassProvider {
        private final Set<? extends PsiClass> myOccurrenceClasses;

        public ExpectedClassesFromSetProvider(@NotNull Set<? extends PsiClass> occurrenceClasses) {
            if (occurrenceClasses == null) {
                ExpectedClassesFromSetProvider.$$$reportNull$$$0(0);
            }
            this.myOccurrenceClasses = occurrenceClasses;
        }

        @Override
        @NotNull
        public PsiField[] findDeclaredFields(@NotNull PsiManager manager, @NotNull String name) {
            if (manager == null) {
                ExpectedClassesFromSetProvider.$$$reportNull$$$0(1);
            }
            if (name == null) {
                ExpectedClassesFromSetProvider.$$$reportNull$$$0(2);
            }
            ArrayList<PsiField> fields = new ArrayList<PsiField>();
            for (PsiClass psiClass : this.myOccurrenceClasses) {
                PsiField field = psiClass.findFieldByName(name, true);
                if (field == null) continue;
                fields.add(field);
            }
            PsiField[] psiFieldArray = fields.toArray(PsiField.EMPTY_ARRAY);
            if (psiFieldArray == null) {
                ExpectedClassesFromSetProvider.$$$reportNull$$$0(3);
            }
            return psiFieldArray;
        }

        @Override
        @NotNull
        public PsiMethod[] findDeclaredMethods(@NotNull PsiManager manager, @NotNull String name) {
            if (manager == null) {
                ExpectedClassesFromSetProvider.$$$reportNull$$$0(4);
            }
            if (name == null) {
                ExpectedClassesFromSetProvider.$$$reportNull$$$0(5);
            }
            ArrayList methods = new ArrayList();
            for (PsiClass psiClass : this.myOccurrenceClasses) {
                Object[] occMethod = psiClass.findMethodsByName(name, true);
                ContainerUtil.addAll(methods, (Object[])occMethod);
            }
            PsiMethod[] psiMethodArray = methods.toArray(PsiMethod.EMPTY_ARRAY);
            if (psiMethodArray == null) {
                ExpectedClassesFromSetProvider.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "occurrenceClasses";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/ExpectedTypeUtil$ExpectedClassesFromSetProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/ExpectedTypeUtil$ExpectedClassesFromSetProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findDeclaredFields";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findDeclaredMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findDeclaredFields";
                    break;
                }
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findDeclaredMethods";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExpectedTypeInfos {
        List<ExpectedTypeInfo> myInfos;

        ExpectedTypeInfos() {
            this.myInfos = new ArrayList<ExpectedTypeInfo>();
        }

        ExpectedTypeInfos(ExpectedTypeInfo[] infos) {
            this.myInfos = new ArrayList<ExpectedTypeInfo>(Arrays.asList(infos));
        }

        public void clear() {
            this.myInfos.clear();
        }

        void addInfo(ExpectedTypeInfo info) {
            Iterator<ExpectedTypeInfo> iterator = this.myInfos.iterator();
            while (iterator.hasNext()) {
                ExpectedTypeInfo sub = iterator.next();
                int cmp = ExpectedTypeUtil.contains(sub, info);
                if (cmp > 0) {
                    return;
                }
                if (cmp >= 0) continue;
                iterator.remove();
            }
            this.myInfos.add(info);
        }

        public boolean isEmpty() {
            return this.myInfos.isEmpty();
        }

        public Iterator<ExpectedTypeInfo> iterator() {
            return this.myInfos.iterator();
        }

        @NotNull
        public ExpectedTypeInfo[] toArray() {
            ExpectedTypeInfo[] expectedTypeInfoArray = this.myInfos.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
            if (expectedTypeInfoArray == null) {
                ExpectedTypeInfos.$$$reportNull$$$0(0);
            }
            return expectedTypeInfoArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypeUtil$ExpectedTypeInfos", "toArray"));
        }
    }
}

