/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;

public class PlatformVcsDetector
implements ProjectComponent {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public PlatformVcsDetector(Project project, ProjectLevelVcsManagerImpl vcsManager) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
            DumbAwareRunnable runnable2 = () -> {
                AbstractVcs vcs;
                VirtualFile file2 = ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myProject.getBaseDir());
                if (this.myVcsManager.needAutodetectMappings() && (vcs = this.myVcsManager.findVersioningVcs(file2)) != null && vcs != this.myVcsManager.getVcsFor(file2)) {
                    this.myVcsManager.removeDirectoryMapping(new VcsDirectoryMapping("", ""));
                    this.myVcsManager.setAutoDirectoryMapping(file2.getPath(), vcs.getName());
                    this.myVcsManager.cleanupMappings();
                }
            };
            ApplicationManager.getApplication().invokeLater((Runnable)runnable2, o -> !this.myProject.isOpen() || this.myProject.isDisposed());
        }));
    }
}

