/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class HorizontalLayout
extends AbstractLayoutManager {
    protected final int myOffset;

    public HorizontalLayout(int offset) {
        this.myOffset = offset;
    }

    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Dimension size = parent.getComponent(i).getPreferredSize();
            width += size.width;
            height = Math.max(height, size.height);
        }
        Dimension size = new Dimension(width += (count - 1) * this.myOffset, height);
        JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
        return size;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int height = parent.getHeight() - insets.top - insets.bottom;
        int x = insets.left;
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component component = parent.getComponent(i);
            Dimension size = component.getPreferredSize();
            component.setBounds(x, insets.top + (height - size.height) / 2, size.width, size.height);
            x += size.width + this.myOffset;
        }
    }
}

