/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.details.HttpDataViewModel;
import com.android.tools.profilers.network.details.TabContent;
import com.android.tools.profilers.network.details.TabUiUtils;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.network.httpdata.Payload;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RequestTabContent
extends TabContent {
    private static final String ID_BODY_COMPONENT = "REQUEST_PAYLOAD_COMPONENT";
    private static final String HEADERS_TITLE = "Application Headers";
    private final IdeProfilerComponents myComponents;
    private final NetworkConnectionsModel myModel;
    private JPanel myPanel;

    RequestTabContent(@NotNull IdeProfilerComponents components, @NotNull NetworkConnectionsModel model) {
        if (components == null) {
            RequestTabContent.$$$reportNull$$$0(0);
        }
        if (model == null) {
            RequestTabContent.$$$reportNull$$$0(1);
        }
        this.myComponents = components;
        this.myModel = model;
    }

    @Override
    @NotNull
    public String getTitle() {
        if ("Request" == null) {
            RequestTabContent.$$$reportNull$$$0(2);
        }
        return "Request";
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        this.myPanel = TabUiUtils.createVerticalPanel(TabUiUtils.TAB_SECTION_VGAP);
        JBScrollPane jBScrollPane = TabUiUtils.createVerticalScrollPane(this.myPanel);
        if (jBScrollPane == null) {
            RequestTabContent.$$$reportNull$$$0(3);
        }
        return jBScrollPane;
    }

    @Override
    public void populateFor(@Nullable HttpData data) {
        this.myPanel.removeAll();
        if (data == null) {
            return;
        }
        HttpDataViewModel httpDataViewModel = new HttpDataViewModel(this.myModel, data);
        JComponent headersComponent = httpDataViewModel.createHeaderComponent(HttpDataViewModel.ConnectionType.REQUEST);
        this.myPanel.add((Component)TabUiUtils.createHideablePanel(HEADERS_TITLE, headersComponent, null));
        Payload requestPayload = Payload.newRequestPayload(this.myModel, data);
        JComponent bodyComponent = httpDataViewModel.createBodyComponent(this.myComponents, HttpDataViewModel.ConnectionType.REQUEST);
        bodyComponent.setName(ID_BODY_COMPONENT);
        JLabel northEastComponent = null;
        HttpData.ContentType contentType = data.getRequestHeader().getContentType();
        String contentToParse = "";
        if (contentType.isFormData()) {
            contentToParse = requestPayload.getBytes().toStringUtf8();
        }
        if (!contentToParse.isEmpty()) {
            JLabel toggleLabel;
            final CardLayout cardLayout = new CardLayout();
            final JPanel payloadPanel = new JPanel(cardLayout);
            final String cardViewParsed = "view parsed";
            final String cardViewSource = "view source";
            LinkedHashMap<String, String> parsedContent = new LinkedHashMap<String, String>();
            Stream<String[]> parsedContentStream = Arrays.stream(contentToParse.trim().split("&")).map(s -> s.split("=", 2));
            parsedContentStream.forEach(a -> parsedContent.put(a[0], ((String[])a).length > 1 ? a[1] : ""));
            payloadPanel.add((Component)TabUiUtils.createStyledMapComponent(parsedContent), cardViewParsed);
            payloadPanel.add((Component)bodyComponent, cardViewSource);
            bodyComponent = payloadPanel;
            northEastComponent = toggleLabel = new JLabel(cardViewSource);
            final Color toggleHoverColor = AdtUiUtils.overlayColor((int)toggleLabel.getBackground().getRGB(), (int)toggleLabel.getForeground().getRGB(), (float)0.9f);
            final Color toggleDefaultColor = AdtUiUtils.overlayColor((int)toggleLabel.getBackground().getRGB(), (int)toggleHoverColor.getRGB(), (float)0.6f);
            toggleLabel.setForeground(toggleDefaultColor);
            toggleLabel.setFont(UIManager.getFont("Label.font").deriveFont(11.0f));
            toggleLabel.setBorder((Border)new JBEmptyBorder(0, 10, 0, 5));
            toggleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    toggleLabel.setText(cardViewSource.equals(toggleLabel.getText()) ? cardViewParsed : cardViewSource);
                    cardLayout.next(payloadPanel);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    toggleLabel.setForeground(toggleHoverColor);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    toggleLabel.setForeground(toggleDefaultColor);
                }
            });
        }
        HideablePanel bodyPanel = TabUiUtils.createHideablePanel(httpDataViewModel.getBodyTitle(HttpDataViewModel.ConnectionType.REQUEST), bodyComponent, northEastComponent);
        this.myPanel.add((Component)bodyPanel);
    }

    @Override
    public void trackWith(@NotNull FeatureTracker featureTracker) {
        if (featureTracker == null) {
            RequestTabContent.$$$reportNull$$$0(4);
        }
        featureTracker.trackSelectNetworkDetailsRequest();
    }

    @Nullable
    @VisibleForTesting
    JComponent findPayloadViewer() {
        JComponent bodyComponent = TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_BODY_COMPONENT);
        return HttpDataViewModel.findPayloadViewer(bodyComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/details/RequestTabContent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/details/RequestTabContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trackWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

