/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkRadioDataSeries;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NetworkRadioTooltip
extends AspectModel<Aspect>
implements ProfilerTooltip {
    @Nullable
    private RadioStateData myRadioStateData;
    @NotNull
    private final NetworkProfilerStage myStage;
    @NotNull
    private RangedSeries<NetworkRadioDataSeries.RadioState> myRadioDataSeries;

    NetworkRadioTooltip(@NotNull NetworkProfilerStage stage) {
        if (stage == null) {
            NetworkRadioTooltip.$$$reportNull$$$0(0);
        }
        this.myStage = stage;
        this.myRadioDataSeries = (RangedSeries)stage.getRadioState().getSeries().get(0);
        this.updateRadioState();
        stage.getStudioProfilers().getTimeline().getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateRadioState);
        stage.getStudioProfilers().getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateRadioState);
    }

    @Override
    public void dispose() {
        this.myStage.getStudioProfilers().getTimeline().getTooltipRange().removeDependencies((AspectObserver)this);
        this.myStage.getStudioProfilers().getTimeline().getDataRange().removeDependencies((AspectObserver)this);
    }

    private void updateRadioState() {
        ProfilerTimeline timeline = this.myStage.getStudioProfilers().getTimeline();
        Range tooltipRange = timeline.getTooltipRange();
        if (tooltipRange.isEmpty()) {
            return;
        }
        List series = this.myRadioDataSeries.getDataSeries().getDataForXRange(timeline.getDataRange());
        int radioStateIndex = Collections.binarySearch(series, new SeriesData((long)tooltipRange.getMin(), null), Comparator.comparingDouble(seriesData -> seriesData.x));
        if (radioStateIndex < 0) {
            radioStateIndex = -radioStateIndex - 2;
        }
        if (radioStateIndex >= 0) {
            int i;
            this.myRadioStateData = new RadioStateData((NetworkRadioDataSeries.RadioState)((Object)((SeriesData)series.get((int)radioStateIndex)).value), new Range((double)((SeriesData)series.get((int)0)).x, timeline.getDataRange().getMax()));
            for (i = radioStateIndex - 1; i >= 0; --i) {
                if (((SeriesData)series.get((int)i)).value == this.myRadioStateData.getRadioState()) continue;
                this.myRadioStateData.getRadioStateRange().setMin((double)((SeriesData)series.get((int)(i + 1))).x);
                break;
            }
            for (i = radioStateIndex + 1; i < series.size(); ++i) {
                if (((SeriesData)series.get((int)i)).value == this.myRadioStateData.getRadioState()) continue;
                this.myRadioStateData.getRadioStateRange().setMax((double)((SeriesData)series.get((int)i)).x);
                break;
            }
        } else {
            this.myRadioStateData = null;
        }
        this.changed(Aspect.RADIO_STATE);
    }

    @Nullable
    public RadioStateData getRadioStateData() {
        return this.myRadioStateData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stage", "com/android/tools/profilers/network/NetworkRadioTooltip", "<init>"));
    }

    public static class RadioStateData {
        @NotNull
        private NetworkRadioDataSeries.RadioState myRadioState;
        @NotNull
        private Range myRadioStateRange;

        public RadioStateData(@NotNull NetworkRadioDataSeries.RadioState radioState, @NotNull Range radioStateRange) {
            if (radioState == null) {
                RadioStateData.$$$reportNull$$$0(0);
            }
            if (radioStateRange == null) {
                RadioStateData.$$$reportNull$$$0(1);
            }
            this.myRadioState = radioState;
            this.myRadioStateRange = radioStateRange;
        }

        @NotNull
        public NetworkRadioDataSeries.RadioState getRadioState() {
            NetworkRadioDataSeries.RadioState radioState = this.myRadioState;
            if (radioState == null) {
                RadioStateData.$$$reportNull$$$0(2);
            }
            return radioState;
        }

        @NotNull
        public Range getRadioStateRange() {
            Range range = this.myRadioStateRange;
            if (range == null) {
                RadioStateData.$$$reportNull$$$0(3);
            }
            return range;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "radioState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "radioStateRange";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/NetworkRadioTooltip$RadioStateData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/NetworkRadioTooltip$RadioStateData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRadioState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRadioStateRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Aspect {
        RADIO_STATE;

    }
}

