/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniReferenceInstanceObject
implements InstanceObject {
    @NotNull
    private final LiveAllocationInstanceObject myReferencedObject;
    private long myAllocTime;
    private long myDeallocTime;
    private final long myRefValue;
    private final long myObjectTag;
    @Nullable
    private MemoryProfiler.AllocationStack myAllocationCallstack;
    @Nullable
    private MemoryProfiler.AllocationStack myDeallocationCallstack;
    @NotNull
    private final ThreadId myAllocThreadId;
    @NotNull
    private final ThreadId myDeallocThreadId;
    @Nullable
    private List<FieldObject> myFields;
    private static final String REF_NAME_FORMATTER = "JNI Global Reference (0x%x)";
    private static final String OBJECT_NAME_FORMATTER = "%s@%d";

    /*
     * WARNING - void declaration
     */
    public JniReferenceInstanceObject(@NotNull LiveAllocationInstanceObject referencedObject, @Nullable ThreadId allocThreadId, long objectTag, long l) {
        void refValue;
        if (referencedObject == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(0);
        }
        this.myAllocTime = Long.MIN_VALUE;
        this.myDeallocTime = Long.MAX_VALUE;
        this.myReferencedObject = referencedObject;
        this.myRefValue = refValue;
        this.myObjectTag = objectTag;
        this.myAllocThreadId = allocThreadId == null ? ThreadId.INVALID_THREAD_ID : allocThreadId;
        this.myDeallocThreadId = ThreadId.INVALID_THREAD_ID;
    }

    public void setAllocationTime(long allocTime) {
        this.myAllocTime = allocTime;
    }

    @Override
    public long getAllocTime() {
        return this.myAllocTime;
    }

    public void setDeallocTime(long deallocTime) {
        this.myDeallocTime = deallocTime;
    }

    @Override
    public long getDeallocTime() {
        return this.myDeallocTime;
    }

    public void setAllocationStack(@NotNull MemoryProfiler.AllocationStack callstack) {
        if (callstack == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(1);
        }
        this.myAllocationCallstack = callstack;
    }

    @Override
    @Nullable
    public MemoryProfiler.AllocationStack getAllocationCallStack() {
        return this.myAllocationCallstack;
    }

    public void setDeallocationStack(@NotNull MemoryProfiler.AllocationStack callstack) {
        if (callstack == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(2);
        }
        this.myDeallocationCallstack = callstack;
    }

    @Nullable
    public MemoryProfiler.AllocationStack getDeallocationStack() {
        return this.myAllocationCallstack;
    }

    @Override
    public boolean hasTimeData() {
        return this.hasAllocTime() || this.hasDeallocTime();
    }

    @Override
    public boolean hasAllocTime() {
        return this.myAllocTime != Long.MIN_VALUE;
    }

    @Override
    public boolean hasDeallocTime() {
        return this.myDeallocTime != Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getName() {
        if ("" == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(3);
        }
        return "";
    }

    @Override
    public int getHeapId() {
        return 4;
    }

    @Override
    public int getShallowSize() {
        return this.myReferencedObject.getShallowSize();
    }

    @Override
    public boolean getIsRoot() {
        return true;
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    @NotNull
    public List<FieldObject> getFields() {
        if (this.myFields == null) {
            this.myFields = Collections.singletonList(new JniRefField());
        }
        List<FieldObject> list = this.myFields;
        if (list == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        ThreadId threadId = this.myAllocThreadId;
        if (threadId == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(5);
        }
        return threadId;
    }

    @NotNull
    public ThreadId getDeallocationThreadId() {
        ThreadId threadId = this.myDeallocThreadId;
        if (threadId == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(6);
        }
        return threadId;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        ClassDb.ClassEntry classEntry = this.myReferencedObject.getClassEntry();
        if (classEntry == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(7);
        }
        return classEntry;
    }

    @Override
    @Nullable
    public InstanceObject getClassObject() {
        return this.myReferencedObject.getClassObject();
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        ValueObject.ValueType valueType = this.myReferencedObject.getValueType();
        if (valueType == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(8);
        }
        return valueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        String string = String.format(REF_NAME_FORMATTER, this.myRefValue);
        if (string == null) {
            JniReferenceInstanceObject.$$$reportNull$$$0(9);
        }
        return string;
    }

    public long getRefValue() {
        return this.myRefValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedObject";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callstack";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/JniReferenceInstanceObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/JniReferenceInstanceObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationThreadId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeallocationThreadId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassEntry";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setAllocationStack";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDeallocationStack";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JniRefField
    implements FieldObject {
        private JniRefField() {
        }

        @Override
        @NotNull
        public String getFieldName() {
            if ("" == null) {
                JniRefField.$$$reportNull$$$0(0);
            }
            return "";
        }

        @Override
        @Nullable
        public InstanceObject getAsInstance() {
            return JniReferenceInstanceObject.this.myReferencedObject;
        }

        @Override
        @Nullable
        public Object getValue() {
            return "";
        }

        @Override
        @NotNull
        public ValueObject.ValueType getValueType() {
            ValueObject.ValueType valueType = ValueObject.ValueType.OBJECT;
            if (valueType == null) {
                JniRefField.$$$reportNull$$$0(1);
            }
            return valueType;
        }

        @Override
        @NotNull
        public String getValueText() {
            String string = String.format(JniReferenceInstanceObject.OBJECT_NAME_FORMATTER, JniReferenceInstanceObject.this.myReferencedObject.getValueText(), JniReferenceInstanceObject.this.myObjectTag);
            if (string == null) {
                JniRefField.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            if ("" == null) {
                JniRefField.$$$reportNull$$$0(3);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/memory/adapters/JniReferenceInstanceObject$JniRefField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

