/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryProfilerSelection {
    @NotNull
    private final MemoryProfilerStage myStage;
    @Nullable
    private CaptureEntry myCaptureEntry;
    @Nullable
    private CaptureObject myCaptureObject;
    @Nullable
    private HeapSet myHeapSet;
    @Nullable
    private ClassSet myClassSet;
    @Nullable
    private InstanceObject myInstanceObject;
    @NotNull
    private List<FieldObject> myFieldObjectPath;

    public MemoryProfilerSelection(@NotNull MemoryProfilerStage stage) {
        if (stage == null) {
            MemoryProfilerSelection.$$$reportNull$$$0(0);
        }
        this.myFieldObjectPath = Collections.emptyList();
        this.myStage = stage;
    }

    @Nullable
    public CaptureObject getCaptureObject() {
        return this.myCaptureObject;
    }

    @Nullable
    public HeapSet getHeapSet() {
        return this.myHeapSet;
    }

    @Nullable
    public ClassSet getClassSet() {
        return this.myClassSet;
    }

    @Nullable
    public InstanceObject getInstanceObject() {
        return this.myInstanceObject;
    }

    @NotNull
    public List<FieldObject> getFieldObjectPath() {
        List<FieldObject> list = this.myFieldObjectPath;
        if (list == null) {
            MemoryProfilerSelection.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean selectCaptureEntry(@Nullable CaptureEntry<? extends CaptureObject> captureEntry) {
        if (Objects.equals(this.myCaptureEntry, captureEntry)) {
            return false;
        }
        this.setFieldObjectPath(Collections.emptyList());
        this.setInstanceObject(null);
        this.setClassSet(null);
        this.setHeapSet(null);
        if (this.myCaptureObject != null) {
            this.myCaptureObject.unload();
        }
        this.myCaptureEntry = captureEntry;
        this.myCaptureObject = this.myCaptureEntry == null ? null : captureEntry.getCaptureObject();
        this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE);
        return true;
    }

    public boolean finishSelectingCaptureObject(@Nullable CaptureObject captureObject) {
        if (captureObject != null && captureObject == this.myCaptureObject && !captureObject.isError() && captureObject.isDoneLoading()) {
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE);
            return true;
        }
        return false;
    }

    public boolean selectHeapSet(@Nullable HeapSet heapSet) {
        assert (heapSet == null || this.myCaptureObject != null);
        if (this.myHeapSet == heapSet) {
            return false;
        }
        this.setFieldObjectPath(Collections.emptyList());
        this.setInstanceObject(null);
        this.setClassSet(null);
        this.setHeapSet(heapSet);
        return true;
    }

    public boolean selectClassSet(@Nullable ClassSet classSet) {
        assert (classSet == null || this.myCaptureObject != null);
        if (this.myClassSet == classSet) {
            return false;
        }
        this.setFieldObjectPath(Collections.emptyList());
        this.setInstanceObject(null);
        this.setClassSet(classSet);
        return true;
    }

    public boolean selectInstanceObject(@Nullable InstanceObject instanceObject) {
        assert (instanceObject == null || this.myCaptureObject != null);
        if (this.myInstanceObject == instanceObject) {
            return false;
        }
        this.setFieldObjectPath(Collections.emptyList());
        this.setInstanceObject(instanceObject);
        return true;
    }

    public boolean selectFieldObjectPath(@NotNull List<FieldObject> fieldObjectPath) {
        if (fieldObjectPath == null) {
            MemoryProfilerSelection.$$$reportNull$$$0(2);
        }
        assert (fieldObjectPath.isEmpty() || this.myCaptureObject != null && this.myInstanceObject != null);
        if (Objects.equals(this.myFieldObjectPath, fieldObjectPath)) {
            return false;
        }
        this.setFieldObjectPath(fieldObjectPath);
        return true;
    }

    private void setHeapSet(@Nullable HeapSet heapSet) {
        if (this.myHeapSet != heapSet) {
            this.myHeapSet = heapSet;
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP);
        }
    }

    private void setClassSet(@Nullable ClassSet classSet) {
        if (this.myClassSet != classSet) {
            this.myClassSet = classSet;
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_CLASS);
        }
    }

    private void setInstanceObject(@Nullable InstanceObject instanceObject) {
        if (this.myInstanceObject != instanceObject) {
            this.myInstanceObject = instanceObject;
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_INSTANCE);
        }
    }

    public void setFieldObjectPath(@NotNull List<FieldObject> fieldObjectPath) {
        if (fieldObjectPath == null) {
            MemoryProfilerSelection.$$$reportNull$$$0(3);
        }
        if (this.myFieldObjectPath != fieldObjectPath) {
            this.myFieldObjectPath = fieldObjectPath;
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_FIELD_PATH);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfilerSelection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldObjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfilerSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldObjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectFieldObjectPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFieldObjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

