/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.CloseButton;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.memory.AttributeColumn;
import com.android.tools.profilers.memory.LazyMemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.SimpleColumnRenderer;
import com.android.tools.profilers.memory.ValueColumnRenderer;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MemoryClassSetView
extends AspectObserver {
    private static final int LABEL_COLUMN_WIDTH = 500;
    private static final int DEFAULT_COLUMN_WIDTH = 80;
    @NotNull
    private final MemoryProfilerStage myStage;
    @NotNull
    private final ProfilerTimeline myTimeline;
    @NotNull
    private final ContextMenuInstaller myContextMenuInstaller;
    @NotNull
    private final Map<CaptureObject.InstanceAttribute, AttributeColumn<MemoryObject>> myAttributeColumns;
    @NotNull
    private final JPanel myInstancesPanel;
    @Nullable
    private JComponent myColumnTree;
    @Nullable
    private JTree myTree;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private LazyMemoryObjectTreeNode<MemoryObject> myTreeRoot;
    @Nullable
    private Comparator<MemoryObjectTreeNode<MemoryObject>> myInitialComparator;
    @Nullable
    private CaptureObject myCaptureObject;
    @Nullable
    private ClassSet myClassSet;
    @Nullable
    private InstanceObject myInstanceObject;
    @Nullable
    private List<FieldObject> myFieldObjectPath;

    MemoryClassSetView(@NotNull MemoryProfilerStage stage, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (stage == null) {
            MemoryClassSetView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            MemoryClassSetView.$$$reportNull$$$0(1);
        }
        this.myAttributeColumns = new HashMap();
        this.myInstancesPanel = new JPanel(new BorderLayout());
        this.myStage = stage;
        this.myTimeline = this.myStage.getStudioProfilers().getTimeline();
        this.myContextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
        this.myStage.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::refreshCaptureObject).onChange((Enum)MemoryProfilerAspect.CURRENT_CLASS, this::refreshClassSet).onChange((Enum)MemoryProfilerAspect.CURRENT_INSTANCE, this::refreshSelectedInstance).onChange((Enum)MemoryProfilerAspect.CURRENT_HEAP_CONTENTS, this::refreshAllInstances).onChange((Enum)MemoryProfilerAspect.CURRENT_FIELD_PATH, this::refreshFieldPath);
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.LABEL, new AttributeColumn("Instance", ValueColumnRenderer::new, 2, 500, SortOrder.ASCENDING, Comparator.comparing(o -> {
            if (!(o.getAdapter() instanceof ValueObject)) {
                return "";
            }
            ValueObject valueObject = (ValueObject)o.getAdapter();
            String comparisonString = valueObject.getName();
            if (!comparisonString.isEmpty()) {
                return comparisonString;
            }
            return valueObject.getValueText();
        })));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.DEPTH, new AttributeColumn("Depth", () -> new SimpleColumnRenderer(value -> {
            ValueObject valueObject;
            Object node = value.getAdapter();
            if (node instanceof ValueObject && (valueObject = (ValueObject)node).getDepth() >= 0 && valueObject.getDepth() < Integer.MAX_VALUE) {
                return Integer.toString(valueObject.getDepth());
            }
            return "";
        }, value -> null, 4), 4, 80, SortOrder.ASCENDING, Comparator.comparingInt(o -> ((ValueObject)o.getAdapter()).getDepth())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.ALLOCATION_TIME, new AttributeColumn("Alloc Time", () -> new SimpleColumnRenderer(value -> {
            InstanceObject instanceObject;
            Object node = value.getAdapter();
            if (node instanceof InstanceObject && (instanceObject = (InstanceObject)node).getAllocTime() > Long.MIN_VALUE) {
                return TimeAxisFormatter.DEFAULT.getFixedPointFormattedString(TimeUnit.MILLISECONDS.toMicros(1L), this.myTimeline.convertToRelativeTimeUs(instanceObject.getAllocTime()));
            }
            return "";
        }, value -> null, 4), 4, 80, SortOrder.ASCENDING, Comparator.comparingLong(o -> ((InstanceObject)o.getAdapter()).getAllocTime())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.DEALLOCATION_TIME, new AttributeColumn("Dealloc Time", () -> new SimpleColumnRenderer(value -> {
            InstanceObject instanceObject;
            Object node = value.getAdapter();
            if (node instanceof InstanceObject && (instanceObject = (InstanceObject)node).getDeallocTime() < Long.MAX_VALUE) {
                return TimeAxisFormatter.DEFAULT.getFixedPointFormattedString(TimeUnit.MILLISECONDS.toMicros(1L), this.myTimeline.convertToRelativeTimeUs(instanceObject.getDeallocTime()));
            }
            return "";
        }, value -> null, 4), 4, 80, SortOrder.DESCENDING, Comparator.comparingLong(o -> ((InstanceObject)o.getAdapter()).getDeallocTime())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.NATIVE_SIZE, new AttributeColumn("Native Size", () -> new SimpleColumnRenderer(value -> {
            Object node = value.getAdapter();
            return node instanceof ValueObject ? Long.toString(((ValueObject)node).getNativeSize()) : "";
        }, value -> null, 4), 4, 80, SortOrder.DESCENDING, Comparator.comparingLong(o -> ((ValueObject)o.getAdapter()).getNativeSize())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.SHALLOW_SIZE, new AttributeColumn("Shallow Size", () -> new SimpleColumnRenderer(value -> {
            Object node = value.getAdapter();
            return node instanceof ValueObject ? Integer.toString(((ValueObject)node).getShallowSize()) : "";
        }, value -> null, 4), 4, 80, SortOrder.DESCENDING, Comparator.comparingInt(o -> ((ValueObject)o.getAdapter()).getShallowSize())));
        this.myAttributeColumns.put(CaptureObject.InstanceAttribute.RETAINED_SIZE, new AttributeColumn("Retained Size", () -> new SimpleColumnRenderer(value -> {
            Object node = value.getAdapter();
            return node instanceof ValueObject ? Long.toString(((ValueObject)node).getRetainedSize()) : "";
        }, value -> null, 4), 4, 80, SortOrder.DESCENDING, Comparator.comparingLong(o -> ((ValueObject)o.getAdapter()).getRetainedSize())));
        JPanel headingPanel = new JPanel(new BorderLayout());
        JLabel instanceViewLabel = new JLabel("Instance View");
        instanceViewLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        headingPanel.add((Component)instanceViewLabel, "West");
        CloseButton closeButton = new CloseButton(e -> this.myStage.selectClassSet(null));
        headingPanel.add((Component)((Object)closeButton), "East");
        this.myInstancesPanel.add((Component)headingPanel, "North");
        this.myInstancesPanel.setVisible(false);
    }

    public void reset() {
        if (this.myColumnTree != null) {
            this.myInstancesPanel.remove(this.myColumnTree);
        }
        this.myColumnTree = null;
        this.myTree = null;
        this.myTreeRoot = null;
        this.myTreeModel = null;
        this.myClassSet = null;
        this.myInstanceObject = null;
        this.myFieldObjectPath = null;
        this.myInstancesPanel.setVisible(false);
        this.myStage.selectInstanceObject(null);
    }

    @NotNull
    JComponent getComponent() {
        JPanel jPanel = this.myInstancesPanel;
        if (jPanel == null) {
            MemoryClassSetView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @VisibleForTesting
    @Nullable
    JTree getTree() {
        return this.myTree;
    }

    @VisibleForTesting
    @Nullable
    JComponent getColumnTree() {
        return this.myColumnTree;
    }

    private void initializeTree() {
        assert (this.myTree == null && this.myColumnTree == null && this.myTreeModel == null && this.myTreeRoot == null && this.myCaptureObject != null && this.myClassSet != null);
        this.myTree = new JTree();
        int defaultFontHeight = this.myTree.getFontMetrics(this.myTree.getFont()).getHeight();
        this.myTree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myTree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            if (!e.isAddedPath()) {
                return;
            }
            assert (path.getLastPathComponent() instanceof MemoryObjectTreeNode);
            MemoryObjectTreeNode valueNode = (MemoryObjectTreeNode)path.getLastPathComponent();
            valueNode.select();
            Object memoryObject = valueNode.getAdapter();
            if (memoryObject instanceof InstanceObject) {
                this.myInstanceObject = (InstanceObject)valueNode.getAdapter();
                this.myStage.selectFieldObjectPath(Collections.emptyList());
                this.myStage.selectInstanceObject(this.myInstanceObject);
            } else if (memoryObject instanceof FieldObject) {
                assert (path.getPathCount() > 2);
                MemoryObjectTreeNode instanceNode = (MemoryObjectTreeNode)path.getPathComponent(1);
                assert (instanceNode.getAdapter() instanceof InstanceObject);
                this.myInstanceObject = (InstanceObject)instanceNode.getAdapter();
                this.myStage.selectInstanceObject(this.myInstanceObject);
                Object[] fieldNodePath = Arrays.copyOfRange(path.getPath(), 2, path.getPathCount());
                ArrayList<FieldObject> fieldObjectPath = new ArrayList<FieldObject>(fieldNodePath.length);
                for (Object fieldNode : fieldNodePath) {
                    if (!(fieldNode instanceof MemoryObjectTreeNode) || !(((MemoryObjectTreeNode)fieldNode).getAdapter() instanceof FieldObject)) {
                        return;
                    }
                    fieldObjectPath.add((FieldObject)((MemoryObjectTreeNode)fieldNode).getAdapter());
                }
                this.myFieldObjectPath = fieldObjectPath;
                this.myStage.selectFieldObjectPath(fieldObjectPath);
            }
        });
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                assert (path.getLastPathComponent() instanceof LazyMemoryObjectTreeNode);
                LazyMemoryObjectTreeNode treeNode = (LazyMemoryObjectTreeNode)path.getLastPathComponent();
                if (treeNode == MemoryClassSetView.this.myTreeRoot) {
                    return;
                }
                treeNode.expandNode();
                MemoryClassSetView.this.myTreeModel.nodeStructureChanged(treeNode);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.installTreeContextMenus();
        List<CaptureObject.InstanceAttribute> supportedAttributes = this.myCaptureObject.getInstanceAttributes();
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myTree);
        CaptureObject.InstanceAttribute sortAttribute = Collections.max(supportedAttributes, Comparator.comparingInt(CaptureObject.InstanceAttribute::getWeight));
        for (CaptureObject.InstanceAttribute attribute : supportedAttributes) {
            AttributeColumn<MemoryObject> column = this.myAttributeColumns.get((Object)attribute);
            ColumnTreeBuilder.ColumnBuilder columnBuilder = column.getBuilder();
            if (sortAttribute == attribute) {
                columnBuilder.setInitialOrder(attribute.getSortOrder());
                this.myInitialComparator = attribute.getSortOrder() == SortOrder.ASCENDING ? column.getComparator() : Collections.reverseOrder(column.getComparator());
            }
            builder.addColumn(columnBuilder);
        }
        builder.setTreeSorter((comparator, sortOrder) -> {
            if (this.myTreeRoot != null) {
                TreePath selectionPath = this.myTree.getSelectionPath();
                this.myTreeRoot.sort(comparator);
                this.myTreeModel.nodeStructureChanged(this.myTreeRoot);
                if (selectionPath != null) {
                    this.myTree.expandPath(selectionPath.getParentPath());
                    this.myTree.setSelectionPath(selectionPath);
                    this.myTree.scrollPathToVisible(selectionPath);
                }
            }
        });
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MemoryClassSetView.this.myTree.getSelectionCount() == 0 && MemoryClassSetView.this.myTree.getRowCount() != 0) {
                    MemoryClassSetView.this.myTree.setSelectionRow(0);
                }
            }
        });
        builder.setHoverColor(ProfilerColors.DEFAULT_HOVER_COLOR);
        builder.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        builder.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        builder.setShowVerticalLines(true);
        builder.setTableIntercellSpacing(new Dimension());
        this.myColumnTree = builder.build();
        this.myInstancesPanel.add((Component)this.myColumnTree, "Center");
    }

    private void installTreeContextMenus() {
        assert (this.myTree != null);
        this.myContextMenuInstaller.installNavigationContextMenu(this.myTree, this.myStage.getStudioProfilers().getIdeServices().getCodeNavigator(), () -> {
            InstanceObject fieldInstance;
            TreePath selection = this.myTree.getSelectionPath();
            if (selection == null || !(selection.getLastPathComponent() instanceof MemoryObjectTreeNode)) {
                return null;
            }
            Object selectedObject = ((MemoryObjectTreeNode)selection.getLastPathComponent()).getAdapter();
            if (selectedObject instanceof InstanceObject) {
                return new CodeLocation.Builder(((InstanceObject)selectedObject).getClassEntry().getClassName()).build();
            }
            if (selectedObject instanceof FieldObject && (fieldInstance = ((FieldObject)selectedObject).getAsInstance()) != null) {
                return new CodeLocation.Builder(fieldInstance.getClassEntry().getClassName()).build();
            }
            return null;
        });
        this.myContextMenuInstaller.installGenericContextMenu(this.myTree, new ContextMenuItem(){

            @Override
            @NotNull
            public String getText() {
                if ("Go to Instance" == null) {
                    3.$$$reportNull$$$0(0);
                }
                return "Go to Instance";
            }

            @Override
            @Nullable
            public Icon getIcon() {
                return null;
            }

            @Override
            public boolean isEnabled() {
                return MemoryClassSetView.this.myInstanceObject != null && MemoryClassSetView.this.myFieldObjectPath != null && !MemoryClassSetView.this.myFieldObjectPath.isEmpty();
            }

            @Override
            public void run() {
                if (MemoryClassSetView.this.myCaptureObject == null || MemoryClassSetView.this.myInstanceObject == null || MemoryClassSetView.this.myFieldObjectPath == null || MemoryClassSetView.this.myFieldObjectPath.isEmpty()) {
                    return;
                }
                FieldObject selectedField = (FieldObject)MemoryClassSetView.this.myFieldObjectPath.get(MemoryClassSetView.this.myFieldObjectPath.size() - 1);
                if (selectedField.getValueType().getIsPrimitive() || selectedField.getValueType() == ValueObject.ValueType.NULL) {
                    return;
                }
                InstanceObject selectedObject = selectedField.getAsInstance();
                assert (selectedObject != null);
                HeapSet heapSet = MemoryClassSetView.this.myCaptureObject.getHeapSet(selectedObject.getHeapId());
                assert (heapSet != null);
                MemoryClassSetView.this.myStage.selectHeapSet(heapSet);
                ClassifierSet classifierSet = heapSet.findContainingClassifierSet(selectedObject);
                assert (classifierSet != null && classifierSet instanceof ClassSet);
                MemoryClassSetView.this.myStage.selectClassSet((ClassSet)classifierSet);
                MemoryClassSetView.this.myStage.selectInstanceObject(selectedObject);
                MemoryClassSetView.this.myStage.selectFieldObjectPath(Collections.emptyList());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/memory/MemoryClassSetView$3", "getText"));
            }
        });
    }

    private void populateTreeContents() {
        assert (this.myTree != null && this.myCaptureObject != null && this.myClassSet != null);
        Comparator comparator = this.myTreeRoot == null ? this.myInitialComparator : this.myTreeRoot.getComparator();
        this.myTreeRoot = new LazyMemoryObjectTreeNode<MemoryObject>((MemoryObject)this.myClassSet, true){

            @Override
            public int computeChildrenCount() {
                return MemoryClassSetView.this.myClassSet.getInstancesCount();
            }

            @Override
            public void expandNode() {
                if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                    return;
                }
                this.myMemoizedChildrenCount = MemoryClassSetView.this.myClassSet.getInstancesCount();
                Stream<InstanceObject> instances = MemoryClassSetView.this.myClassSet.getInstancesStream();
                instances.forEach(subAdapter -> {
                    InstanceTreeNode child = new InstanceTreeNode((InstanceObject)subAdapter);
                    child.setTreeModel(MemoryClassSetView.this.myTreeModel);
                    this.add(child);
                });
                if (MemoryClassSetView.this.myTreeModel != null) {
                    MemoryClassSetView.this.myTreeModel.nodeChanged(this);
                }
            }
        };
        if (comparator != null) {
            this.myTreeRoot.sort(comparator);
        }
        this.myTreeModel = new DefaultTreeModel(this.myTreeRoot);
        this.myTreeRoot.setTreeModel(this.myTreeModel);
        this.myTree.setModel(this.myTreeModel);
        this.myTreeRoot.expandNode();
    }

    private void refreshCaptureObject() {
        this.myCaptureObject = this.myStage.getSelectedCapture();
        this.reset();
    }

    private void refreshClassSet() {
        ClassSet classSet = this.myStage.getSelectedClassSet();
        if (classSet == this.myClassSet) {
            return;
        }
        if (classSet == null) {
            this.reset();
            return;
        }
        if (this.myClassSet == null) {
            this.myClassSet = classSet;
            this.initializeTree();
        } else {
            this.myClassSet = classSet;
        }
        this.populateTreeContents();
        this.myInstancesPanel.setVisible(true);
    }

    private void refreshSelectedInstance() {
        InstanceObject instanceObject = this.myStage.getSelectedInstanceObject();
        if (this.myInstanceObject == instanceObject) {
            return;
        }
        assert (this.myTree != null);
        this.myInstanceObject = instanceObject;
        if (this.myInstanceObject == null) {
            this.myTree.clearSelection();
            return;
        }
        assert (this.myTreeRoot != null && this.myTreeModel != null);
        for (MemoryObjectTreeNode node : this.myTreeRoot.getChildren()) {
            if (node.getAdapter() != this.myInstanceObject) continue;
            this.selectPath(node);
            break;
        }
    }

    private void refreshAllInstances() {
        if (this.myClassSet == null) {
            return;
        }
        if (this.myClassSet.isEmpty()) {
            this.myStage.selectClassSet(ClassSet.EMPTY_SET);
            return;
        }
        this.populateTreeContents();
        if (this.myInstanceObject == null) {
            return;
        }
        assert (this.myTreeRoot != null);
        for (MemoryObjectTreeNode node : this.myTreeRoot.getChildren()) {
            if (node.getAdapter() != this.myInstanceObject) continue;
            this.selectPath(node);
            return;
        }
        this.myStage.selectInstanceObject(null);
    }

    private void refreshFieldPath() {
        List<FieldObject> fieldPath = this.myStage.getSelectedFieldObjectPath();
        if (Objects.equals(this.myFieldObjectPath, fieldPath)) {
            if (this.myFieldObjectPath != null && !this.myFieldObjectPath.isEmpty()) {
                assert (this.myTree != null);
                this.myTree.scrollPathToVisible(this.myTree.getSelectionPath());
            }
            return;
        }
        this.myFieldObjectPath = fieldPath;
        if (this.myFieldObjectPath.isEmpty()) {
            if (this.myInstanceObject != null) {
                assert (this.myTreeRoot != null && this.myTreeModel != null && this.myTree != null);
                MemoryObjectTreeNode<MemoryObject> instanceNode = this.findSelectedInstanceNode();
                if (instanceNode != null) {
                    this.selectPath(instanceNode);
                }
            }
            return;
        }
        assert (this.myTreeRoot != null && this.myTreeModel != null && this.myTree != null && this.myInstanceObject != null);
        MemoryObjectTreeNode<MemoryObject> instanceNode = this.findSelectedInstanceNode();
        assert (instanceNode != null);
        List<MemoryObjectTreeNode<MemoryObject>> fields = MemoryClassSetView.findLeafNodesForFieldPath(instanceNode, this.myFieldObjectPath);
        if (!fields.isEmpty()) {
            this.selectPath(fields.get(0));
        }
    }

    @Nullable
    private MemoryObjectTreeNode<MemoryObject> findSelectedInstanceNode() {
        assert (this.myTree != null && this.myTreeModel != null && this.myTreeRoot != null && this.myInstanceObject != null);
        for (MemoryObjectTreeNode node : this.myTreeRoot.getChildren()) {
            if (node.getAdapter() != this.myInstanceObject) continue;
            return node;
        }
        return null;
    }

    private void selectPath(@NotNull MemoryObjectTreeNode<MemoryObject> targetNode) {
        if (targetNode == null) {
            MemoryClassSetView.$$$reportNull$$$0(3);
        }
        assert (this.myTree != null && this.myTreeModel != null);
        TreePath path = new TreePath(this.myTreeModel.getPathToRoot(targetNode));
        this.myTree.expandPath(path.getParentPath());
        this.myTree.setSelectionPath(path);
        this.myTree.scrollPathToVisible(path);
    }

    @NotNull
    private static List<MemoryObjectTreeNode<MemoryObject>> findLeafNodesForFieldPath(@NotNull MemoryObjectTreeNode<MemoryObject> parentNode, @NotNull List<FieldObject> fieldPath) {
        if (parentNode == null) {
            MemoryClassSetView.$$$reportNull$$$0(4);
        }
        if (fieldPath == null) {
            MemoryClassSetView.$$$reportNull$$$0(5);
        }
        assert (!fieldPath.isEmpty());
        FieldObject currentField = fieldPath.get(0);
        ArrayList<MemoryObjectTreeNode<MemoryObject>> results = new ArrayList<MemoryObjectTreeNode<MemoryObject>>(1);
        if (fieldPath.size() == 1) {
            parentNode.getChildren().stream().filter(child -> child.getAdapter().equals(currentField)).forEach(results::add);
        } else {
            List<FieldObject> slice = fieldPath.subList(1, fieldPath.size());
            parentNode.getChildren().stream().filter(child -> child.getAdapter().equals(currentField)).forEach(child -> results.addAll(MemoryClassSetView.findLeafNodesForFieldPath(child, slice)));
        }
        ArrayList<MemoryObjectTreeNode<MemoryObject>> arrayList = results;
        if (arrayList == null) {
            MemoryClassSetView.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryClassSetView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryClassSetView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findLeafNodesForFieldPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findLeafNodesForFieldPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FieldTreeNode
    extends LazyMemoryObjectTreeNode<FieldObject> {
        FieldTreeNode(@NotNull FieldObject adapter) {
            if (adapter == null) {
                FieldTreeNode.$$$reportNull$$$0(0);
            }
            super(adapter, true);
        }

        @Override
        public int computeChildrenCount() {
            return ((FieldObject)this.getAdapter()).getAsInstance() == null ? 0 : ((FieldObject)this.getAdapter()).getAsInstance().getFieldCount();
        }

        @Override
        public void expandNode() {
            if (this.myMemoizedChildrenCount == this.myChildren.size() || ((FieldObject)this.getAdapter()).getAsInstance() == null) {
                return;
            }
            List<FieldObject> fields = ((FieldObject)this.getAdapter()).getAsInstance().getFields();
            this.myMemoizedChildrenCount = fields.size();
            for (FieldObject field : fields) {
                FieldTreeNode child = new FieldTreeNode(field);
                child.setTreeModel(this.getTreeModel());
                this.add(child);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "com/android/tools/profilers/memory/MemoryClassSetView$FieldTreeNode", "<init>"));
        }
    }

    static class InstanceTreeNode
    extends LazyMemoryObjectTreeNode<ValueObject> {
        InstanceTreeNode(@NotNull InstanceObject adapter) {
            if (adapter == null) {
                InstanceTreeNode.$$$reportNull$$$0(0);
            }
            super(adapter, true);
        }

        @Override
        public int computeChildrenCount() {
            return ((InstanceObject)this.getAdapter()).getFieldCount();
        }

        @Override
        public void expandNode() {
            if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                return;
            }
            List<FieldObject> fields = ((InstanceObject)this.getAdapter()).getFields();
            this.myMemoizedChildrenCount = fields.size();
            for (FieldObject field : fields) {
                FieldTreeNode child = new FieldTreeNode(field);
                child.setTreeModel(this.getTreeModel());
                this.add(child);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "com/android/tools/profilers/memory/MemoryClassSetView$InstanceTreeNode", "<init>"));
        }
    }
}

