/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.ActivityAction;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.StackedEventType;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profilers.ProfilerClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ActivityEventDataSeries
implements DataSeries<EventAction<StackedEventType>> {
    @NotNull
    private ProfilerClient myClient;
    @NotNull
    private final Common.Session mySession;
    private final boolean myFragmentsOnly;

    public ActivityEventDataSeries(@NotNull ProfilerClient client, @NotNull Common.Session session, boolean fragmentOnly) {
        if (client == null) {
            ActivityEventDataSeries.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ActivityEventDataSeries.$$$reportNull$$$0(1);
        }
        this.myClient = client;
        this.mySession = session;
        this.myFragmentsOnly = fragmentOnly;
    }

    public List<SeriesData<EventAction<StackedEventType>>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            ActivityEventDataSeries.$$$reportNull$$$0(2);
        }
        ArrayList<SeriesData<EventAction<StackedEventType>>> seriesData = new ArrayList<SeriesData<EventAction<StackedEventType>>>();
        EventServiceGrpc.EventServiceBlockingStub eventService = this.myClient.getEventClient();
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()));
        EventProfiler.ActivityDataResponse response = eventService.getActivityData(dataRequestBuilder.build());
        for (EventProfiler.ActivityData data : response.getDataList()) {
            boolean isFragment;
            long actionStart = 0L;
            long actionEnd = 0L;
            boolean bl = isFragment = !data.getFragmentData().equals((Object)EventProfiler.FragmentData.getDefaultInstance());
            if (this.myFragmentsOnly != isFragment) continue;
            boolean haveEvent = false;
            for (int i = 0; i < data.getStateChangesCount(); ++i) {
                EventProfiler.ActivityStateData state = data.getStateChanges(i);
                StackedEventType action = StackedEventType.NONE;
                String displayString = data.getName();
                switch (state.getState()) {
                    case ADDED: 
                    case RESUMED: {
                        action = StackedEventType.ACTIVITY_STARTED;
                        actionStart = TimeUnit.NANOSECONDS.toMicros(state.getTimestamp());
                        break;
                    }
                    case DESTROYED: {
                        if (i != data.getStateChangesCount() - 1) break;
                        displayString = String.format("%s - %s", displayString, state.getState().toString().toLowerCase());
                    }
                    case REMOVED: 
                    case PAUSED: {
                        action = StackedEventType.ACTIVITY_COMPLETED;
                        actionEnd = TimeUnit.NANOSECONDS.toMicros(state.getTimestamp());
                        haveEvent = true;
                        break;
                    }
                }
                while (haveEvent && ++i < data.getStateChangesCount()) {
                    state = data.getStateChanges(i);
                    EventProfiler.ActivityStateData.ActivityState activityState = state.getState();
                    if (this.getComponentInStartingOrRunningState(activityState)) {
                        --i;
                        break;
                    }
                    displayString = String.format("%s - %s", displayString, state.getState().toString().toLowerCase());
                }
                if (!haveEvent && (i != data.getStateChangesCount() - 1 || action == StackedEventType.NONE)) continue;
                seriesData.add((SeriesData<EventAction<StackedEventType>>)new SeriesData(actionStart, (Object)new ActivityAction(actionStart, actionEnd, action, displayString, data.getHash(), data.getFragmentData().getActivityContextHash())));
                actionEnd = 0L;
                actionStart = 0L;
                haveEvent = false;
            }
        }
        return seriesData;
    }

    private boolean getComponentInStartingOrRunningState(EventProfiler.ActivityStateData.ActivityState state) {
        switch (state) {
            case ADDED: 
            case RESUMED: 
            case ATTACHED: 
            case CREATED: 
            case CREATEDVIEW: 
            case ACTIVITYCREATED: 
            case STARTED: {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/event/ActivityEventDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForXRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

