/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.energy.DetailedEnergyUsage;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyStageTooltipView;
import com.android.tools.profilers.event.EventMonitorView;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EnergyProfilerStageView
extends StageView<EnergyProfilerStage> {
    @NotNull
    private final EnergyStageTooltipView myTooltipView;

    public EnergyProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull EnergyProfilerStage energyProfilerStage) {
        if (profilersView == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(0);
        }
        if (energyProfilerStage == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, energyProfilerStage);
        this.myTooltipView = new EnergyStageTooltipView((EnergyProfilerStage)((Object)this.getStage()));
        this.getComponent().add((Component)this.buildMonitorUi(), "Center");
    }

    @NotNull
    private JPanel buildMonitorUi() {
        StudioProfilers profilers = ((EnergyProfilerStage)((Object)this.getStage())).getStudioProfilers();
        ProfilerTimeline timeline = profilers.getTimeline();
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        ProfilerScrollbar scrollbar = new ProfilerScrollbar(timeline, (JComponent)panel);
        panel.add((Component)((Object)scrollbar), new TabularLayout.Constraint(4, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(3, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((EnergyProfilerStage)((Object)this.getStage())).getEventMonitor());
        JComponent eventsComponent = eventsView.getComponent();
        panel.add((Component)eventsComponent, new TabularLayout.Constraint(0, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((EnergyProfilerStage)((Object)this.getStage())).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        DetailedEnergyUsage usage = ((EnergyProfilerStage)((Object)this.getStage())).getDetailedUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig cpuConfig = new LineConfig(ProfilerColors.ENERGY_CPU).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX);
        lineChart.configure(usage.getCpuUsageSeries(), cpuConfig);
        LineConfig networkConfig = new LineConfig(ProfilerColors.ENERGY_NETWORK).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX);
        lineChart.configure(usage.getNetworkUsageSeries(), networkConfig);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (Component)this.myTooltipView.createComponent(), ProfilerLayeredPane.class);
        tooltip.registerListenersOn((Component)lineChart);
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((EnergyProfilerStage)((Object)this.getStage())).getAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        EnergyProfilerStage.EnergyLegends legends = ((EnergyProfilerStage)((Object)this.getStage())).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure((Legend)legends.getCpuLegend(), new LegendConfig(lineChart.getLineConfig(usage.getCpuUsageSeries())));
        legend.configure((Legend)legends.getNetworkLegend(), new LegendConfig(lineChart.getLineConfig(usage.getNetworkUsageSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        monitorPanel.add((Component)tooltip, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        layout.setRowSizing(2, "*");
        panel.add((Component)monitorPanel, new TabularLayout.Constraint(2, 0));
        JBPanel jBPanel = panel;
        if (jBPanel == null) {
            EnergyProfilerStageView.$$$reportNull$$$0(2);
        }
        return jBPanel;
    }

    @Override
    public JComponent getToolbar() {
        return new JPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "energyProfilerStage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyProfilerStageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyProfilerStageView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMonitorUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

