/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.DetailedEnergyUsage;
import com.android.tools.profilers.energy.EnergyMonitor;
import com.android.tools.profilers.event.EventMonitor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class EnergyProfilerStage
extends Stage {
    @NotNull
    private final DetailedEnergyUsage myDetailedUsage;
    @NotNull
    private final AxisComponentModel myAxis;
    @NotNull
    private final EventMonitor myEventMonitor;
    @NotNull
    private final EnergyLegends myLegends;
    @NotNull
    private final EnergyLegends myTooltipLegends;

    public EnergyProfilerStage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            EnergyProfilerStage.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myDetailedUsage = new DetailedEnergyUsage(profilers);
        this.myAxis = new AxisComponentModel(this.myDetailedUsage.getUsageRange(), EnergyMonitor.ENERGY_AXIS_FORMATTER);
        this.myEventMonitor = new EventMonitor(profilers);
        this.myLegends = new EnergyLegends(this.myDetailedUsage, profilers.getTimeline().getDataRange(), false);
        this.myTooltipLegends = new EnergyLegends(this.myDetailedUsage, profilers.getTimeline().getTooltipRange(), true);
    }

    @Override
    public void enter() {
        this.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTooltipLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedUsage);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myAxis);
    }

    @Override
    public void exit() {
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTooltipLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedUsage);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myAxis);
    }

    @NotNull
    public DetailedEnergyUsage getDetailedUsage() {
        DetailedEnergyUsage detailedEnergyUsage = this.myDetailedUsage;
        if (detailedEnergyUsage == null) {
            EnergyProfilerStage.$$$reportNull$$$0(1);
        }
        return detailedEnergyUsage;
    }

    @NotNull
    public AxisComponentModel getAxis() {
        AxisComponentModel axisComponentModel = this.myAxis;
        if (axisComponentModel == null) {
            EnergyProfilerStage.$$$reportNull$$$0(2);
        }
        return axisComponentModel;
    }

    @NotNull
    public EventMonitor getEventMonitor() {
        EventMonitor eventMonitor = this.myEventMonitor;
        if (eventMonitor == null) {
            EnergyProfilerStage.$$$reportNull$$$0(3);
        }
        return eventMonitor;
    }

    @NotNull
    public EnergyLegends getLegends() {
        EnergyLegends energyLegends = this.myLegends;
        if (energyLegends == null) {
            EnergyProfilerStage.$$$reportNull$$$0(4);
        }
        return energyLegends;
    }

    @NotNull
    public EnergyLegends getTooltipLegends() {
        EnergyLegends energyLegends = this.myTooltipLegends;
        if (energyLegends == null) {
            EnergyProfilerStage.$$$reportNull$$$0(5);
        }
        return energyLegends;
    }

    @NotNull
    public String getName() {
        if ("ENERGY" == null) {
            EnergyProfilerStage.$$$reportNull$$$0(6);
        }
        return "ENERGY";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyProfilerStage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyProfilerStage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailedUsage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAxis";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMonitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegends";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipLegends";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EnergyLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myNetworkLegend;

        EnergyLegends(DetailedEnergyUsage detailedUsage, Range range, boolean isTooltip) {
            super(100);
            this.myCpuLegend = new SeriesLegend(detailedUsage.getCpuUsageSeries(), EnergyMonitor.ENERGY_AXIS_FORMATTER, range, "CPU", Interpolatable.SegmentInterpolator);
            this.myNetworkLegend = new SeriesLegend(detailedUsage.getNetworkUsageSeries(), EnergyMonitor.ENERGY_AXIS_FORMATTER, range, "NETWORK", Interpolatable.SegmentInterpolator);
            ArrayList legends = Lists.newArrayList((Object[])new SeriesLegend[]{this.myCpuLegend, this.myNetworkLegend});
            if (isTooltip) {
                Collections.reverse(legends);
            }
            legends.forEach(arg_0 -> ((EnergyLegends)this).add(arg_0));
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            SeriesLegend seriesLegend = this.myCpuLegend;
            if (seriesLegend == null) {
                EnergyLegends.$$$reportNull$$$0(0);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getNetworkLegend() {
            SeriesLegend seriesLegend = this.myNetworkLegend;
            if (seriesLegend == null) {
                EnergyLegends.$$$reportNull$$$0(1);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/energy/EnergyProfilerStage$EnergyLegends";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuLegend";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNetworkLegend";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

