/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.SyscallModel;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class NodeNameParser {
    private static final Pattern NATIVE_SEPARATOR_PATTERN = Pattern.compile("::");
    private static final Pattern JAVA_SEPARATOR_PATTERN = Pattern.compile("\\.");

    NodeNameParser() {
    }

    static CaptureNodeModel parseNodeName(String fullName) {
        if (fullName.contains("(")) {
            return NodeNameParser.parseCppFunctionName(fullName);
        }
        if (fullName.contains(".")) {
            ModelInfo modelInfo = NodeNameParser.createModelInfo(fullName, ".", JAVA_SEPARATOR_PATTERN);
            return new JavaMethodModel(modelInfo.getName(), modelInfo.getClassOrNamespace());
        }
        return new SyscallModel(fullName);
    }

    @NotNull
    private static CaptureNodeModel parseCppFunctionName(String functionFullName) {
        functionFullName = NodeNameParser.removeTemplateInformation(functionFullName);
        int paramsStartIndex = functionFullName.lastIndexOf(40);
        int paramsEndIndex = NodeNameParser.findMatchingClosingCharacterIndex(functionFullName, '(', ')', paramsStartIndex);
        String parameters = functionFullName.substring(paramsStartIndex + 1, paramsEndIndex);
        int returnTypeSeparatorIndex = (functionFullName = functionFullName.substring(0, paramsStartIndex)).indexOf(32);
        if (returnTypeSeparatorIndex >= 0) {
            functionFullName = functionFullName.substring(returnTypeSeparatorIndex + 1);
        }
        boolean isGlobalNamespace = !functionFullName.contains("::");
        ModelInfo modelInfo = isGlobalNamespace ? new ModelInfo(functionFullName, "") : NodeNameParser.createModelInfo(functionFullName, "::", NATIVE_SEPARATOR_PATTERN);
        CppFunctionModel cppFunctionModel = new CppFunctionModel.Builder(modelInfo.getName()).setClassOrNamespace(modelInfo.getClassOrNamespace()).setParameters(parameters).build();
        if (cppFunctionModel == null) {
            NodeNameParser.$$$reportNull$$$0(0);
        }
        return cppFunctionModel;
    }

    private static String removeTemplateInformation(String functionFullName) {
        int currentIndex = functionFullName.indexOf(60);
        if (currentIndex < 0) {
            return functionFullName;
        }
        StringBuilder filteredName = new StringBuilder(functionFullName.substring(0, currentIndex));
        while (currentIndex < functionFullName.length()) {
            char currentChar = functionFullName.charAt(currentIndex);
            if (currentChar == '<') {
                currentIndex = NodeNameParser.findMatchingClosingCharacterIndex(functionFullName, '<', '>', currentIndex);
            } else {
                filteredName.append(currentChar);
            }
            ++currentIndex;
        }
        return filteredName.toString();
    }

    private static int findMatchingClosingCharacterIndex(String functionName, char opening, char closing, int startIndex) {
        int count = 1;
        int index = startIndex;
        assert (functionName.charAt(index) == opening);
        while (index++ < functionName.length() - 1) {
            if (functionName.charAt(index) == opening) {
                ++count;
            } else if (functionName.charAt(index) == closing) {
                --count;
            }
            if (count != 0) continue;
            return index;
        }
        throw new IllegalStateException("Native function signature must have matching parentheses and brackets.");
    }

    private static ModelInfo createModelInfo(String fullName, String separator, Pattern separatorPattern) {
        String[] splittedMethod = separatorPattern.split(fullName);
        int methodNameIndex = splittedMethod.length - 1;
        String methodName = splittedMethod[methodNameIndex];
        StringBuilder classOrNamespace = new StringBuilder(splittedMethod[0]);
        for (int i = 1; i < methodNameIndex; ++i) {
            classOrNamespace.append(separator);
            classOrNamespace.append(splittedMethod[i]);
        }
        return new ModelInfo(methodName, classOrNamespace.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/cpu/simpleperf/NodeNameParser", "parseCppFunctionName"));
    }

    private static class ModelInfo {
        @NotNull
        private final String myName;
        @NotNull
        private final String myClassOrNamespace;

        ModelInfo(@NotNull String name, @NotNull String classOrNamespace) {
            if (name == null) {
                ModelInfo.$$$reportNull$$$0(0);
            }
            if (classOrNamespace == null) {
                ModelInfo.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myClassOrNamespace = classOrNamespace;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ModelInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getClassOrNamespace() {
            String string = this.myClassOrNamespace;
            if (string == null) {
                ModelInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classOrNamespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/simpleperf/NodeNameParser$ModelInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/simpleperf/NodeNameParser$ModelInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassOrNamespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

