/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.NativeNodeModel;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class NativeModelHChartColors {
    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (model == null) {
            NativeModelHChartColors.$$$reportNull$$$0(0);
        }
        if (!(model instanceof NativeNodeModel)) {
            throw new IllegalStateException("Model must be a subclass of NativeNodeModel.");
        }
    }

    private static boolean isMethodVendor(CaptureNodeModel method) {
        return method.getFullName().startsWith("openjdkjvmti::");
    }

    private static boolean isMethodPlatform(CaptureNodeModel method) {
        return method.getFullName().startsWith("art::") || method.getFullName().startsWith("android::") || method.getFullName().startsWith("art_") || method.getFullName().startsWith("dalvik-jit-code-cache");
    }

    static Color getFillColor(@NotNull CaptureNodeModel model, CaptureModel.Details.Type chartType, boolean isUnmatched) {
        if (model == null) {
            NativeModelHChartColors.$$$reportNull$$$0(1);
        }
        NativeModelHChartColors.validateModel(model);
        Color color = chartType == CaptureModel.Details.Type.CALL_CHART ? (NativeModelHChartColors.isMethodVendor(model) ? ProfilerColors.CPU_CALLCHART_VENDOR : (NativeModelHChartColors.isMethodPlatform(model) ? ProfilerColors.CPU_CALLCHART_PLATFORM : ProfilerColors.CPU_CALLCHART_APP)) : (NativeModelHChartColors.isMethodVendor(model) ? ProfilerColors.CPU_FLAMECHART_VENDOR : (NativeModelHChartColors.isMethodPlatform(model) ? ProfilerColors.CPU_FLAMECHART_PLATFORM : ProfilerColors.CPU_FLAMECHART_APP));
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getBorderColor(@NotNull CaptureNodeModel model, CaptureModel.Details.Type chartType, boolean isUnmatched) {
        if (model == null) {
            NativeModelHChartColors.$$$reportNull$$$0(2);
        }
        NativeModelHChartColors.validateModel(model);
        Color color = chartType == CaptureModel.Details.Type.CALL_CHART ? (NativeModelHChartColors.isMethodVendor(model) ? ProfilerColors.CPU_CALLCHART_VENDOR_BORDER : (NativeModelHChartColors.isMethodPlatform(model) ? ProfilerColors.CPU_CALLCHART_PLATFORM_BORDER : ProfilerColors.CPU_CALLCHART_APP_BORDER)) : (NativeModelHChartColors.isMethodVendor(model) ? ProfilerColors.CPU_FLAMECHART_VENDOR_BORDER : (NativeModelHChartColors.isMethodPlatform(model) ? ProfilerColors.CPU_FLAMECHART_PLATFORM_BORDER : ProfilerColors.CPU_FLAMECHART_APP_BORDER));
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "com/android/tools/profilers/cpu/NativeModelHChartColors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFillColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBorderColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

