/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.JavaMethodHChartColors;
import com.android.tools.profilers.cpu.NativeModelHChartColors;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.NativeNodeModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class CaptureNodeHRenderer
implements HRenderer<CaptureNode> {
    private static final int LEFT_MARGIN_PX = 3;
    @NotNull
    private CaptureModel.Details.Type myType;
    @NotNull
    private TextFitsPredicate myTextFitsPredicate;

    @VisibleForTesting
    CaptureNodeHRenderer(@NotNull CaptureModel.Details.Type type, @NotNull TextFitsPredicate textFitPredicate) {
        if (type == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(0);
        }
        if (textFitPredicate == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(1);
        }
        if (type != CaptureModel.Details.Type.CALL_CHART && type != CaptureModel.Details.Type.FLAME_CHART) {
            throw new IllegalStateException("Chart type not supported and can't be rendered.");
        }
        this.myType = type;
        this.myTextFitsPredicate = textFitPredicate;
    }

    @VisibleForTesting
    public CaptureNodeHRenderer() {
        this(CaptureModel.Details.Type.CALL_CHART);
    }

    public CaptureNodeHRenderer(@NotNull CaptureModel.Details.Type type) {
        if (type == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(2);
        }
        this(type, (text, metrics, width) -> (float)metrics.stringWidth(text) <= width);
    }

    private Color getFillColor(CaptureNode node) {
        CaptureNodeModel nodeModel = node.getData();
        if (nodeModel instanceof JavaMethodModel) {
            return JavaMethodHChartColors.getFillColor(nodeModel, this.myType, node.isUnmatched());
        }
        if (nodeModel instanceof NativeNodeModel) {
            return NativeModelHChartColors.getFillColor(nodeModel, this.myType, node.isUnmatched());
        }
        throw new IllegalStateException("Node type not supported.");
    }

    private Color getBorderColor(CaptureNode node) {
        CaptureNodeModel nodeModel = node.getData();
        if (nodeModel instanceof JavaMethodModel) {
            return JavaMethodHChartColors.getBorderColor(nodeModel, this.myType, node.isUnmatched());
        }
        if (nodeModel instanceof NativeNodeModel) {
            return NativeModelHChartColors.getBorderColor(nodeModel, this.myType, node.isUnmatched());
        }
        throw new IllegalStateException("Node type not supported.");
    }

    @NotNull
    static Color toUnmatchColor(@NotNull Color color) {
        if (color == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(3);
        }
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
        if (color2 == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(4);
        }
        return color2;
    }

    public void render(@NotNull Graphics2D g, @NotNull CaptureNode node, @NotNull Rectangle2D drawingArea, boolean isFocused) {
        if (g == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(5);
        }
        if (node == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(6);
        }
        if (drawingArea == null) {
            CaptureNodeHRenderer.$$$reportNull$$$0(7);
        }
        CaptureNode captureNode = node;
        Color nodeColor = this.getFillColor(captureNode);
        if (isFocused) {
            nodeColor = ColorUtil.darker((Color)nodeColor, (int)2);
        }
        g.setPaint(nodeColor);
        g.fill(drawingArea);
        g.setPaint(this.getBorderColor(captureNode));
        g.draw(drawingArea);
        Font font = g.getFont();
        FontMetrics fontMetrics = g.getFontMetrics(font);
        if (captureNode.getFilterType() == CaptureNode.FilterType.MATCH) {
            g.setPaint(Color.BLACK);
        } else if (captureNode.getFilterType() == CaptureNode.FilterType.UNMATCH) {
            g.setPaint(CaptureNodeHRenderer.toUnmatchColor(Color.BLACK));
        } else {
            g.setPaint(Color.BLACK);
            g.setFont(font.deriveFont(1));
        }
        Float availableWidth = Float.valueOf((float)drawingArea.getWidth() - 3.0f);
        String text = CaptureNodeHRenderer.generateFittingText(node.getData(), s -> this.myTextFitsPredicate.test((String)s, fontMetrics, availableWidth.floatValue()));
        float textPositionX = 3.0f + (float)drawingArea.getX();
        float textPositionY = (float)(drawingArea.getY() + (double)fontMetrics.getAscent());
        g.drawString(text, textPositionX, textPositionY);
        g.setFont(font);
    }

    private static String generateFittingText(CaptureNodeModel model, Predicate<String> textFitsPredicate) {
        String classOrNamespace = "";
        String separator = "";
        if (model instanceof CppFunctionModel) {
            classOrNamespace = ((CppFunctionModel)model).getClassOrNamespace();
            separator = "::";
        } else if (model instanceof JavaMethodModel) {
            classOrNamespace = ((JavaMethodModel)model).getClassName();
            separator = ".";
        }
        if (!separator.isEmpty() && !classOrNamespace.isEmpty()) {
            String[] classElements = classOrNamespace.split(separator.equals(".") ? "\\." : separator);
            for (int abbreviationCount = 0; abbreviationCount <= classElements.length; ++abbreviationCount) {
                StringBuilder textBuilder = new StringBuilder();
                for (int i = 0; i < classElements.length; ++i) {
                    textBuilder.append(i < abbreviationCount ? Character.valueOf(classElements[i].charAt(0)) : classElements[i]).append(separator);
                }
                textBuilder.append(model.getName());
                String text = textBuilder.toString();
                if (!textFitsPredicate.test(text)) continue;
                return text;
            }
        }
        return AdtUiUtils.shrinkToFit((String)model.getName(), textFitsPredicate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFitPredicate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CaptureNodeHRenderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CaptureNodeHRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnmatchColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toUnmatchColor";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TextFitsPredicate {
        public boolean test(String var1, FontMetrics var2, float var3);
    }
}

