/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.DeviceId;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilerTable
extends DataStoreTable<ProfilerStatements> {
    private final Object myLock = new Object();

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            ProfilerTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Profiler_Bytes", "Id STRING NOT NULL", "Session INTEGER", "Data BLOB");
            this.createTable("Profiler_Devices", "DeviceId INTEGER", "Data BLOB");
            this.createTable("Profiler_Processes", "DeviceId INTEGER", "ProcessId INTEGER", "StartTime INTEGER", "EndTime INTEGER", "HasAgent INTEGER", "LastKnownAttachedTime INTEGER", "Data BLOB");
            this.createTable("Profiler_Sessions", "SessionId INTEGER", "DeviceId INTEGER", "ProcessId INTEGER", "StartTime INTEGER", "EndTime INTEGER");
            this.createUniqueIndex("Profiler_Processes", "DeviceId", "ProcessId", "StartTime");
            this.createUniqueIndex("Profiler_Devices", "DeviceId");
            this.createUniqueIndex("Profiler_Bytes", "Id", "Session");
            this.createUniqueIndex("Profiler_Sessions", "SessionId");
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(ProfilerStatements.INSERT_DEVICE, "INSERT OR REPLACE INTO Profiler_Devices (DeviceId, Data) values (?, ?)");
            this.createStatement(ProfilerStatements.INSERT_PROCESS, "INSERT OR REPLACE INTO Profiler_Processes (DeviceId, ProcessId, StartTime, EndTime, Data) values (?, ?, ?, ?, ?)");
            this.createStatement(ProfilerStatements.UPDATE_PROCESS, "UPDATE Profiler_Processes Set EndTime = ?, Data = ? WHERE DeviceId = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.INSERT_SESSION, "INSERT OR REPLACE INTO Profiler_Sessions (SessionId, DeviceId, ProcessId, StartTime, EndTime) values (?, ?, ?, ?, ?)");
            this.createStatement(ProfilerStatements.SELECT_PROCESSES, "SELECT Data from Profiler_Processes WHERE DeviceId = ? AND (EndTime > ? OR EndTime = 0) AND StartTime < ?");
            this.createStatement(ProfilerStatements.SELECT_PROCESS_BY_ID, "SELECT Data from Profiler_Processes WHERE DeviceId = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.SELECT_DEVICE, "SELECT Data from Profiler_Devices");
            this.createStatement(ProfilerStatements.SELECT_SESSIONS, "SELECT * from Profiler_Sessions ORDER BY SessionId ASC");
            this.createStatement(ProfilerStatements.FIND_AGENT_STATUS, "SELECT HasAgent, LastKnownAttachedTime from Profiler_Processes WHERE DeviceId = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.UPDATE_AGENT_STATUS, "UPDATE Profiler_Processes SET HasAgent = ?, LastKnownAttachedTime = ? WHERE DeviceId = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.INSERT_BYTES, "INSERT OR REPLACE INTO Profiler_Bytes (Id, Session, Data) VALUES (?, ?, ?)");
            this.createStatement(ProfilerStatements.GET_BYTES, "SELECT Data FROM Profiler_Bytes WHERE Id = ? AND Session = ?");
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Profiler.GetDevicesResponse getDevices(@NotNull Profiler.GetDevicesRequest request) {
        if (request == null) {
            ProfilerTable.$$$reportNull$$$0(1);
        }
        if (this.isClosed()) {
            Profiler.GetDevicesResponse getDevicesResponse = Profiler.GetDevicesResponse.getDefaultInstance();
            if (getDevicesResponse != null) return getDevicesResponse;
            ProfilerTable.$$$reportNull$$$0(2);
            return getDevicesResponse;
        }
        Object object = this.myLock;
        // MONITORENTER : object
        Profiler.GetDevicesResponse.Builder responseBuilder = Profiler.GetDevicesResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_DEVICE, new Object[0]);
            while (results.next()) {
                responseBuilder.addDevice(Common.Device.parseFrom((byte[])results.getBytes(1)));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetDevicesResponse getDevicesResponse = responseBuilder.build();
        // MONITOREXIT : object
        if (getDevicesResponse != null) return getDevicesResponse;
        ProfilerTable.$$$reportNull$$$0(3);
        return getDevicesResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Profiler.GetProcessesResponse getProcesses(@NotNull Profiler.GetProcessesRequest request) {
        if (request == null) {
            ProfilerTable.$$$reportNull$$$0(4);
        }
        if (this.isClosed()) {
            Profiler.GetProcessesResponse getProcessesResponse = Profiler.GetProcessesResponse.getDefaultInstance();
            if (getProcessesResponse != null) return getProcessesResponse;
            ProfilerTable.$$$reportNull$$$0(5);
            return getProcessesResponse;
        }
        Object object = this.myLock;
        // MONITORENTER : object
        Profiler.GetProcessesResponse.Builder responseBuilder = Profiler.GetProcessesResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_PROCESSES, request.getDeviceId(), Long.MIN_VALUE, Long.MAX_VALUE);
            while (results.next()) {
                byte[] data = results.getBytes(1);
                Common.Process process = data == null ? Common.Process.getDefaultInstance() : Common.Process.parseFrom((byte[])data);
                responseBuilder.addProcess(process);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetProcessesResponse getProcessesResponse = responseBuilder.build();
        // MONITOREXIT : object
        if (getProcessesResponse != null) return getProcessesResponse;
        ProfilerTable.$$$reportNull$$$0(6);
        return getProcessesResponse;
    }

    @NotNull
    public Profiler.GetSessionsResponse getSessions(@NotNull Profiler.GetSessionsRequest request) {
        if (request == null) {
            ProfilerTable.$$$reportNull$$$0(7);
        }
        if (this.isClosed()) {
            Profiler.GetSessionsResponse getSessionsResponse = Profiler.GetSessionsResponse.getDefaultInstance();
            if (getSessionsResponse == null) {
                ProfilerTable.$$$reportNull$$$0(8);
            }
            return getSessionsResponse;
        }
        Profiler.GetSessionsResponse.Builder responseBuilder = Profiler.GetSessionsResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.SELECT_SESSIONS, new Object[0]);
            while (results.next()) {
                responseBuilder.addSessions(Common.Session.newBuilder().setSessionId(results.getLong(1)).setDeviceId(results.getLong(2)).setPid(results.getInt(3)).setStartTimestamp(results.getLong(4)).setEndTimestamp(results.getLong(5)).build());
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.GetSessionsResponse getSessionsResponse = responseBuilder.build();
        if (getSessionsResponse == null) {
            ProfilerTable.$$$reportNull$$$0(9);
        }
        return getSessionsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateDevice(@NotNull Common.Device device) {
        if (device == null) {
            ProfilerTable.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.execute(ProfilerStatements.INSERT_DEVICE, device.getDeviceId(), device.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateProcess(@NotNull DeviceId devicdId, @NotNull Common.Process process) {
        if (devicdId == null) {
            ProfilerTable.$$$reportNull$$$0(11);
        }
        if (process == null) {
            ProfilerTable.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_PROCESS_BY_ID, devicdId.get(), process.getPid(), 0L);
                if (results.next()) {
                    this.execute(ProfilerStatements.UPDATE_PROCESS, 0L, process.toByteArray(), devicdId.get(), process.getPid(), 0L);
                } else {
                    this.execute(ProfilerStatements.INSERT_PROCESS, devicdId.get(), process.getPid(), 0L, 0L, process.toByteArray());
                }
            }
            catch (SQLException ex) {
                ProfilerTable.onError(ex);
            }
        }
    }

    public void insertOrUpdateSession(@NotNull Common.Session session) {
        if (session == null) {
            ProfilerTable.$$$reportNull$$$0(13);
        }
        this.execute(ProfilerStatements.INSERT_SESSION, session.getSessionId(), session.getDeviceId(), session.getPid(), session.getStartTimestamp(), session.getEndTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAgentStatus(@NotNull DeviceId devicdId, @NotNull Common.Process process, @NotNull Profiler.AgentStatusResponse agentStatus) {
        if (devicdId == null) {
            ProfilerTable.$$$reportNull$$$0(14);
        }
        if (process == null) {
            ProfilerTable.$$$reportNull$$$0(15);
        }
        if (agentStatus == null) {
            ProfilerTable.$$$reportNull$$$0(16);
        }
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.FIND_AGENT_STATUS, devicdId.get(), process.getPid(), 0L);
                if (results.next()) {
                    Profiler.AgentStatusResponse.Status status = Profiler.AgentStatusResponse.Status.forNumber((int)results.getInt(1));
                    switch (status) {
                        case DETACHED: 
                        case UNSPECIFIED: 
                        case UNRECOGNIZED: {
                            status = agentStatus.getStatus();
                            break;
                        }
                    }
                    this.execute(ProfilerStatements.UPDATE_AGENT_STATUS, status.ordinal(), agentStatus.getLastTimestamp(), devicdId.get(), process.getPid(), 0L);
                }
            }
            catch (SQLException ex) {
                ProfilerTable.onError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Profiler.AgentStatusResponse getAgentStatus(@NotNull Profiler.AgentStatusRequest request) {
        if (request == null) {
            ProfilerTable.$$$reportNull$$$0(17);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        Profiler.AgentStatusResponse.Builder responseBuilder = Profiler.AgentStatusResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.FIND_AGENT_STATUS, request.getDeviceId(), request.getProcessId(), 0L);
            if (results.next()) {
                responseBuilder.setStatusValue(results.getInt(1));
                responseBuilder.setLastTimestamp(results.getLong(2));
            }
        }
        catch (SQLException ex) {
            ProfilerTable.onError(ex);
        }
        Profiler.AgentStatusResponse agentStatusResponse = responseBuilder.build();
        // MONITOREXIT : object
        if (agentStatusResponse != null) return agentStatusResponse;
        ProfilerTable.$$$reportNull$$$0(18);
        return agentStatusResponse;
    }

    public void insertOrUpdateBytes(@NotNull String id, @NotNull Common.Session session, @NotNull Profiler.BytesResponse response) {
        if (id == null) {
            ProfilerTable.$$$reportNull$$$0(19);
        }
        if (session == null) {
            ProfilerTable.$$$reportNull$$$0(20);
        }
        if (response == null) {
            ProfilerTable.$$$reportNull$$$0(21);
        }
        this.execute(ProfilerStatements.INSERT_BYTES, id, session, response.toByteArray());
    }

    @Nullable
    public Profiler.BytesResponse getBytes(@NotNull Profiler.BytesRequest request) {
        if (request == null) {
            ProfilerTable.$$$reportNull$$$0(22);
        }
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.GET_BYTES, request.getId(), request.getSession());
            if (results.next()) {
                return Profiler.BytesResponse.parseFrom((byte[])results.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            ProfilerTable.onError(ex);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/ProfilerTable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devicdId";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentStatus";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/ProfilerTable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcesses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDevices";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProcesses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSessions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateDevice";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateProcess";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateSession";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateAgentStatus";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAgentStatus";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateBytes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ProfilerStatements {
        INSERT_DEVICE,
        INSERT_PROCESS,
        UPDATE_PROCESS,
        INSERT_SESSION,
        SELECT_PROCESSES,
        SELECT_PROCESS_BY_ID,
        SELECT_DEVICE,
        SELECT_SESSIONS,
        FIND_AGENT_STATUS,
        UPDATE_AGENT_STATUS,
        INSERT_BYTES,
        GET_BYTES;

    }
}

