/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlBinaryExpression;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.freemarker.psi.directives.FtlSwitchDirective;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlEnumReference
extends PsiReferenceBase<FtlStringLiteral> {
    public FtlEnumReference(FtlStringLiteral literal) {
        super((PsiElement)literal);
    }

    @Nullable
    private FtlType getExpectedType() {
        FtlExpression switchExpression;
        PsiElement grandParent;
        FtlBinaryExpression binary;
        FtlTokenType op;
        PsiElement parent = ((FtlStringLiteral)this.myElement).getParent();
        if (parent instanceof FtlBinaryExpression && ((op = (binary = (FtlBinaryExpression)parent).getOperationSign()) == FtlElementTypes.EQ || op == FtlElementTypes.NEQ)) {
            FtlExpression other;
            FtlExpression ftlExpression = other = this.myElement == binary.getLeftOperand() ? binary.getRightOperand() : binary.getLeftOperand();
            if (other != null) {
                return other.getType();
            }
        }
        if (FtlDirectiveType.isDirective(parent, "case") && (grandParent = parent.getParent()) instanceof FtlSwitchDirective && (switchExpression = ((FtlSwitchDirective)grandParent).getSwitchExpression()) != null) {
            return switchExpression.getType();
        }
        return null;
    }

    @Nullable
    public PsiClass getEnumClass() {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)FtlPsiUtil.extractPsiType(this.getExpectedType()));
        if (psiClass != null && psiClass.isEnum()) {
            return psiClass;
        }
        return null;
    }

    @Nullable
    public PsiElement resolve() {
        PsiField field;
        PsiClass enumClass = this.getEnumClass();
        if (enumClass != null && (field = enumClass.findFieldByName(this.getValue(), false)) instanceof PsiEnumConstant) {
            return field;
        }
        return null;
    }

    @NotNull
    public PsiEnumConstant[] getVariants() {
        ArrayList variants = ContainerUtil.newArrayList();
        PsiClass enumClass = this.getEnumClass();
        if (enumClass != null) {
            for (PsiField field : enumClass.getFields()) {
                if (!(field instanceof PsiEnumConstant)) continue;
                variants.add((PsiEnumConstant)field);
            }
        }
        PsiEnumConstant[] psiEnumConstantArray = variants.toArray(new PsiEnumConstant[0]);
        if (psiEnumConstantArray == null) {
            FtlEnumReference.$$$reportNull$$$0(0);
        }
        return psiEnumConstantArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlEnumReference", "getVariants"));
    }
}

