/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlDeprecatedBuiltInsInspection
extends FtlSuppressableInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlDeprecatedBuiltInsInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element.getParent() instanceof FtlBuiltIn && element.getNode().getElementType() == FtlElementTypes.IDENTIFIER) {
                    FtlBuiltIn builtIn = (FtlBuiltIn)element.getParent();
                    FtlBuiltInDescriptor descriptor = builtIn.getBuiltInDescriptor();
                    if (descriptor == null || !descriptor.isDeprecated()) {
                        return;
                    }
                    final String replacement = descriptor.getQuickFixReplacement(builtIn);
                    String message = FreeMarkerBundle.message("deprecated.builtin.usage", builtIn.getBuiltInName());
                    if (replacement == null) {
                        holder.registerProblem(element, message, new LocalQuickFix[0]);
                    } else {
                        holder.registerProblem(element, message, new LocalQuickFix[]{new LocalQuickFix(){

                            @NotNull
                            public String getFamilyName() {
                                String string = FreeMarkerBundle.message("replace.with.0", replacement);
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                if (project == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (descriptor == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                PsiElement psiElement = descriptor.getPsiElement();
                                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiElement.getContainingFile());
                                FtlBuiltIn builtIn = (FtlBuiltIn)psiElement.getParent();
                                PsiElement parent = builtIn.getParent();
                                int endOffset = (parent instanceof FtlMethodCallExpression ? parent : psiElement).getTextRange().getEndOffset();
                                document.replaceString(builtIn.getQuestionToken().getTextRange().getStartOffset(), endOffset, (CharSequence)replacement);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 2;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n2 = 3;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$1$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "project";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "descriptor";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getFamilyName";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray;
                                        objectArray[2] = "applyFix";
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        }});
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            FtlDeprecatedBuiltInsInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlDeprecatedBuiltInsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.deprecated.builtins.inspection", new Object[0]);
        if (string == null) {
            FtlDeprecatedBuiltInsInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("FtlDeprecatedBuiltInsInspection" == null) {
            FtlDeprecatedBuiltInsInspection.$$$reportNull$$$0(4);
        }
        return "FtlDeprecatedBuiltInsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

