/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.freemarker.editorActions.FreeMarkerBackspaceHandler;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlLiteralExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlSequenceLiteral;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class FreeMarkerTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        FileViewProvider viewProvider = file.getViewProvider();
        if (!FtlPsiUtil.hasFtlViewProvider(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        if (c == ']' || c == '>') {
            char startChar;
            FtlSequenceLiteral literal;
            CharSequence sequence = document.getCharsSequence();
            if (sequence.charAt(offset - 1) == '/') {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
            documentManager.commitDocument(document);
            while (offset > 0 && (offset >= sequence.length() || sequence.charAt(offset) == ' ')) {
                --offset;
            }
            FtlXmlTag tag = (FtlXmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), FtlXmlTag.class, (boolean)false);
            if (tag == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(7);
                }
                return result;
            }
            PsiElement leaf = tag.getContainingFile().findElementAt(offset);
            if (leaf == null || leaf.getContainingFile() != viewProvider.getPsi(viewProvider.getBaseLanguage())) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(8);
                }
                return result;
            }
            if (leaf instanceof PsiComment) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(9);
                }
                return result;
            }
            if (c == ']' && !tag.isOpeningTagClosed() && (literal = (FtlSequenceLiteral)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), FtlSequenceLiteral.class, (boolean)false)) != null && FtlDirectiveStyle.SQUARE == literal.getContainingFtlFile().getDirectiveStyle()) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"]", (boolean)true);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(10);
                }
                return result;
            }
            if (tag.isClosed()) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(11);
                }
                return result;
            }
            if (!tag.needsClosing()) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
            if (c == ']' && leaf.getParent() instanceof FtlIndexExpression) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(13);
                }
                return result;
            }
            char c2 = startChar = c == ']' ? (char)'[' : '<';
            if (!tag.getFirstChild().getText().startsWith(String.valueOf(startChar))) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(14);
                }
                return result;
            }
            IElementType elementType = leaf.getNode().getElementType();
            if (elementType == FtlElementTypes.TEMPLATE_TEXT || elementType == FtlElementTypes.STRING_TEXT || elementType == FtlElementTypes.CHAR_ESCAPE) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(15);
                }
                return result;
            }
            String name = tag.getDirectiveTagName();
            if (name.length() >= 2 && name.charAt(0) == '@' && !Character.isJavaIdentifierStart(name.charAt(1))) {
                name = "@";
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(String.valueOf(c) + startChar + "/" + name + c), (boolean)true, (int)1);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(16);
            }
            return result;
        }
        if (c == '}' && TypedHandler.handleRParen((Editor)editor, (FileType)fileType, (char)c)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(17);
            }
            return result;
        }
        if (c == '\'' || c == '\"') {
            CharSequence sequence = document.getCharsSequence();
            if (sequence.length() <= offset) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(18);
                }
                return result;
            }
            char next = sequence.charAt(offset);
            if (Character.isJavaIdentifierPart(next)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(c));
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(19);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(20);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        CharSequence chars;
        char c;
        if (project == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(22);
        }
        if (file == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(23);
        }
        if (!FtlPsiUtil.hasFtlViewProvider(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(24);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if (charTyped == '#' && offset > 0 && (FreeMarkerTypedHandler.isDirectiveStart(c = (chars = editor.getDocument().getCharsSequence()).charAt(offset - 1)) || c == '/' && offset > 1 && FreeMarkerTypedHandler.isDirectiveStart(chars.charAt(offset - 2)))) {
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(25);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(26);
        }
        return result;
    }

    private static boolean isDirectiveStart(char c) {
        return c == '[' || c == '<';
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(27);
        }
        if (editor == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(28);
        }
        if (file == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(29);
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (!FtlPsiUtil.hasFtlViewProvider(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(30);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(31);
            }
            return result;
        }
        if (c == '/') {
            documentManager.commitDocument(document);
            FtlXmlTag tag = (FtlXmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), FtlXmlTag.class, (boolean)false);
            if (tag == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(32);
                }
                return result;
            }
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
            if (result == null) {
                FreeMarkerTypedHandler.$$$reportNull$$$0(33);
            }
            return result;
        }
        if (c == '[') {
            FtlXmlTag grandParent;
            char nextChar;
            if (offset < document.getTextLength() && (Character.isJavaIdentifierPart(nextChar = document.getCharsSequence().charAt(offset)) || FreeMarkerTypedHandler.isBeforeLiteral(file, offset, nextChar))) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(34);
                }
                return result;
            }
            documentManager.commitDocument(document);
            PsiElement element = file.findElementAt(offset - 1);
            if (FreeMarkerBackspaceHandler.needsRightBracket(element) && (grandParent = (FtlXmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, FtlXmlTag.class)) != null && !grandParent.isOpeningTagClosed()) {
                document.insertString(offset, (CharSequence)"]");
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(35);
                }
                return result;
            }
        }
        if (c == '=' && offset > 1 && document.getImmutableCharSequence().charAt(offset - 2) == '[') {
            documentManager.commitDocument(document);
            FtlInterpolation el = (FtlInterpolation)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), FtlInterpolation.class, (boolean)false);
            if (el != null && el.isSquare() && !el.isClosed()) {
                document.insertString(offset, (CharSequence)"]");
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    FreeMarkerTypedHandler.$$$reportNull$$$0(36);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            FreeMarkerTypedHandler.$$$reportNull$$$0(37);
        }
        return result;
    }

    private static boolean isBeforeLiteral(PsiFile file, int offset, char nextChar) {
        if ('\"' != nextChar && '\'' != nextChar) {
            return false;
        }
        return offset >= 2 && PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 2), FtlLiteralExpression.class, (boolean)false) == null && PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, FtlLiteralExpression.class, (boolean)false) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/editorActions/FreeMarkerTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/editorActions/FreeMarkerTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

