/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FtlDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        String info;
        PsiElement navigationElement;
        if (element instanceof FakePsiElement && (navigationElement = element.getNavigationElement()) != null && navigationElement.isPhysical() && !(navigationElement.getContainingFile() instanceof FtlFile) && (info = FtlDocumentationProvider.findSpecificProvider(navigationElement).getQuickNavigateInfo(element, originalElement)) != null) {
            return info;
        }
        if (element instanceof FtlVariable) {
            FtlVariable variable = (FtlVariable)element;
            String name = variable.getName();
            FtlType type = variable.getType();
            if (type != null) {
                return StringUtil.escapeXml((String)type.getPresentableText()) + " " + name;
            }
            return name;
        }
        if (element instanceof BeanPropertyElement) {
            String result = JavaDocumentationProvider.generateMethodInfo((PsiMethod)((BeanPropertyElement)element).getMethod(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
            return QuickDocUtil.inferLinkFromFullDocumentation((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement, (String)result);
        }
        return null;
    }

    private static DocumentationProvider findSpecificProvider(PsiElement element) {
        DocumentationProvider provider = DocumentationManager.getProviderFromElement((PsiElement)element);
        if (!(element instanceof FakePsiElement) || element.getNavigationElement() != element) {
            return provider;
        }
        if (provider instanceof CompositeDocumentationProvider) {
            ArrayList<DocumentationProvider> providers = new ArrayList<DocumentationProvider>();
            for (DocumentationProvider member : ((CompositeDocumentationProvider)provider).getProviders()) {
                if (member instanceof FtlDocumentationProvider) continue;
                providers.add(member);
            }
            return CompositeDocumentationProvider.wrapProviders(providers);
        }
        return provider;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (element instanceof BeanPropertyElement) {
            return JavaDocumentationProvider.getExternalJavaDocUrl((PsiElement)((BeanPropertyElement)element).getMethod());
        }
        return null;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        String info;
        PsiElement navigationElement;
        if (element instanceof FakePsiElement && (navigationElement = element.getNavigationElement()) != null && navigationElement.isPhysical() && !(navigationElement.getContainingFile() instanceof FtlFile) && (info = FtlDocumentationProvider.findSpecificProvider(navigationElement).generateDoc(navigationElement, originalElement)) != null) {
            return info;
        }
        if (element instanceof BeanPropertyElement) {
            return JavaDocumentationProvider.generateExternalJavadoc((PsiElement)((BeanPropertyElement)element).getMethod());
        }
        return null;
    }

    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        if (element instanceof BeanPropertyElement) {
            return JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)((BeanPropertyElement)element).getMethod(), (Project)project, docUrls);
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof FtlVariable || object instanceof BeanPropertyElement) {
            return (PsiElement)object;
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }
}

