/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.FtlArgumentDependentBuiltIn;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlDateType;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlMarkupOutputType;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlCustomVariable;
import com.intellij.freemarker.psi.variables.FtlHashType;
import com.intellij.freemarker.psi.variables.FtlLightVariable;
import com.intellij.freemarker.psi.variables.FtlMethodType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlBuiltIns {
    private static final Set<FtlBuiltInDescriptor> ourBuiltIns;
    private static final Set<FtlBuiltInDescriptor> ourDeprecatedBuiltIns;
    private static final String[] DATE_FORMAT_ACCURACIES;
    private static final String MAP_STRING_STRING = "java.util.Map<java.lang.String, java.lang.String>";

    @NotNull
    private static FtlPsiType getStringStringMap(FtlBuiltIn builtIn) {
        FtlPsiType ftlPsiType = FtlPsiType.wrap(JavaPsiFacade.getElementFactory((Project)builtIn.getProject()).createTypeFromText(MAP_STRING_STRING, (PsiElement)builtIn));
        if (ftlPsiType == null) {
            FtlBuiltIns.$$$reportNull$$$0(0);
        }
        return ftlPsiType;
    }

    @NotNull
    private static FtlHashType getDateFormatHash(FtlBuiltIn builtIn) {
        String[] array;
        FtlPsiType string = new FtlPsiType((PsiType)FtlBuiltIns.getStringType(builtIn));
        FtlCustomVariable customVariable = new FtlCustomVariable("string", builtIn);
        boolean camelCase = FtlPsiUtil.isUsingCamelCase(builtIn.getContainingFtlFile());
        for (String s : array = new String[]{"short", "medium", "long", "full"}) {
            customVariable.addSubVariable(new FtlLightVariable(s, (PsiElement)builtIn, string));
            for (String s1 : array) {
                customVariable.addSubVariable(new FtlLightVariable(camelCase ? s + StringUtil.capitalize((String)s1) : s + "_" + s1, (PsiElement)builtIn, string));
            }
        }
        for (String standard : (String[])ContainerUtil.ar((Object[])new String[]{"iso", "xs"})) {
            customVariable.addSubVariable(new FtlLightVariable(standard, (PsiElement)builtIn, string));
            for (String accuracy : DATE_FORMAT_ACCURACIES) {
                String accurateName = camelCase ? standard + StringUtil.capitalize((String)accuracy) : standard + "_" + accuracy;
                customVariable.addSubVariable(new FtlLightVariable(accurateName, (PsiElement)builtIn, string));
                for (String zone : (String[])ContainerUtil.ar((Object[])new String[]{camelCase ? "NZ" : "_nz", camelCase ? "U" : "_u"})) {
                    customVariable.addSubVariable(new FtlLightVariable(accurateName + zone, (PsiElement)builtIn, string));
                }
            }
        }
        FtlHashType ftlHashType = new FtlHashType(customVariable);
        if (ftlHashType == null) {
            FtlBuiltIns.$$$reportNull$$$0(1);
        }
        return ftlHashType;
    }

    private static void addDateFormatBuiltIns(Function<FtlBuiltIn, FtlType> stringType) {
        for (String zone : (String[])ContainerUtil.ar((Object[])new String[]{"utc", "local"})) {
            String iso = "iso_" + zone;
            String camelIso = "iso" + StringUtil.capitalize((String)zone);
            ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn(iso, camelIso, stringType));
            ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn(iso + "_nz", camelIso + "NZ", stringType));
            for (String accuracy : DATE_FORMAT_ACCURACIES) {
                ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn(iso + "_" + accuracy, camelIso + StringUtil.capitalize((String)accuracy), stringType));
                ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn(iso + "_" + accuracy + "_nz", camelIso + StringUtil.capitalize((String)accuracy) + "NZ", stringType));
            }
        }
        Function formatFunction = in -> FtlCallableType.createLightFunctionType(in, (FtlType)stringType.fun(in), "format", (FtlType)stringType.fun(in));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("iso", (Function<? super FtlBuiltIn, ? extends FtlType>)formatFunction));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("iso_nz", "isoNZ", (Function<? super FtlBuiltIn, ? extends FtlType>)formatFunction));
        for (String accuracy : DATE_FORMAT_ACCURACIES) {
            ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("iso_" + accuracy, "iso" + StringUtil.capitalize((String)accuracy), (Function<? super FtlBuiltIn, ? extends FtlType>)formatFunction));
            ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("iso_" + accuracy + "_nz", "iso" + StringUtil.capitalize((String)accuracy) + "NZ", (Function<? super FtlBuiltIn, ? extends FtlType>)formatFunction));
        }
    }

    @NotNull
    private static PsiClassType getStringType(PsiElement builtIn) {
        PsiClassType psiClassType = PsiType.getJavaLangString((PsiManager)builtIn.getManager(), (GlobalSearchScope)builtIn.getResolveScope());
        if (psiClassType == null) {
            FtlBuiltIns.$$$reportNull$$$0(2);
        }
        return psiClassType;
    }

    @NotNull
    public static List<FtlBuiltInDescriptor> getBuiltIns(@Nullable FtlExpression qualifier, @Nullable String name) {
        FtlType qualifierType = qualifier == null ? null : qualifier.getType();
        Condition condition = descriptor -> !(name != null && !name.equals(descriptor.getCamelCaseName()) && !name.equals(descriptor.getSnakeCaseName()) || qualifierType != null && !descriptor.acceptsQualifier(qualifierType, qualifier));
        List list = ContainerUtil.findAll(ourBuiltIns, (Condition)condition);
        list.addAll(ContainerUtil.findAll(ourDeprecatedBuiltIns, (Condition)condition));
        List list2 = list;
        if (list2 == null) {
            FtlBuiltIns.$$$reportNull$$$0(3);
        }
        return list2;
    }

    static {
        String[] object2Boolean;
        ourBuiltIns = new THashSet();
        ourDeprecatedBuiltIns = new THashSet();
        DATE_FORMAT_ACCURACIES = (String[])ContainerUtil.ar((Object[])new String[]{"h", "m", "ms"});
        Function stringType = builtIn -> new FtlPsiType((PsiType)FtlBuiltIns.getStringType(builtIn));
        FtlPsiType intType = FtlPsiType.wrap((PsiType)PsiType.INT);
        FtlPsiType booleanType = FtlPsiType.wrap((PsiType)PsiType.BOOLEAN);
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("substring", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, string, "from", intType), FtlCallableType.createLightFunctionType(builtIn, string, "from", intType, "toExclusive", intType));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("boolean", (PsiType)PsiType.BOOLEAN));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("capFirst", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("uncapFirst", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("capitalize", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("chopLinebreak", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        NullableFunction formattedDateTime = builtIn -> {
            FtlDateType date = FtlDateType.INSTANCE;
            return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, date, "format", (FtlType)stringType.fun(builtIn)), FtlCallableType.createLightFunctionType(date), FtlBuiltIns.getDateFormatHash(builtIn), builtIn.getParent() instanceof FtlIndexExpression ? FtlBuiltIns.getStringStringMap(builtIn) : null, date);
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("date", (Function<? super FtlBuiltIn, ? extends FtlType>)formattedDateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("time", (Function<? super FtlBuiltIn, ? extends FtlType>)formattedDateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("datetime", (Function<? super FtlBuiltIn, ? extends FtlType>)formattedDateTime));
        NullableFunction containsType = builtIn -> FtlCallableType.createLightFunctionType(builtIn, booleanType, "substring", (FtlType)stringType.fun(builtIn));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("endsWith", (Function<? super FtlBuiltIn, ? extends FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("ensureEndsWith", (Function<? super FtlBuiltIn, ? extends FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("ensureStartsWith", (Function<? super FtlBuiltIn, ? extends FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("html", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("xhtml", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("groups", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> new FtlCollectionType((FtlType)stringType.fun(builtIn)))));
        NullableFunction indexOfType = builtIn -> new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, intType, "substring", (FtlType)stringType.fun(builtIn)), FtlCallableType.createLightFunctionType(builtIn, intType, "substring", (FtlType)stringType.fun(builtIn), "from", intType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("indexOf", (Function<? super FtlBuiltIn, ? extends FtlType>)indexOfType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("lastIndexOf", (Function<? super FtlBuiltIn, ? extends FtlType>)indexOfType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("jString", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("jsString", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("jsonString", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("length", (PsiType)PsiType.INT));
        NullableFunction padType = builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, string, "length", intType), FtlCallableType.createLightFunctionType(builtIn, string, "length", intType, "fillWith", string));
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("leftPad", (Function<? super FtlBuiltIn, ? extends FtlType>)padType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("rightPad", (Function<? super FtlBuiltIn, ? extends FtlType>)padType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("contains", (Function<? super FtlBuiltIn, ? extends FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("matches", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            FtlCompositeType returnType = new FtlCompositeType(FtlPsiType.wrap((PsiType)PsiType.BOOLEAN), new FtlCollectionType(string));
            return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, returnType, "regex", string), FtlCallableType.createLightFunctionType(builtIn, returnType, "regex", string, "flags", string));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("number", (PsiType)PsiType.INT));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("replace", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, string, "substring", string, "replacement", string), FtlCallableType.createLightFunctionType(builtIn, string, "substring", string, "replacement", string, "flags", string));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("rtf", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("url", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            return new FtlCompositeType(string, FtlCallableType.createLightFunctionType(builtIn, string, "locale", string));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("split", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            FtlCollectionType returnType = new FtlCollectionType(string);
            return new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, returnType, "separator", string), FtlCallableType.createLightFunctionType(builtIn, returnType, "separator", string, "flags", string));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("startsWith", (Function<? super FtlBuiltIn, ? extends FtlType>)containsType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("string", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("trim", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("upperCase", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("lowerCase", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("wordList", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> new FtlCollectionType((FtlType)stringType.fun(builtIn)))));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("xml", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("esc", (Function<? super FtlBuiltIn, ? extends FtlType>)((Function)builtIn -> FtlMarkupOutputType.INSTANCE)));
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("noEsc", (Function<? super FtlBuiltIn, ? extends FtlType>)((Function)builtIn -> FtlMarkupOutputType.INSTANCE)));
        ourBuiltIns.add(new FtlBuiltInDescriptor("markupString", stringType){

            @Override
            public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
                if (qualifierType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                return qualifierType == FtlMarkupOutputType.INSTANCE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "qualifierType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlBuiltIns$1";
                objectArray[2] = "acceptsQualifier";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        NullableFunction substringFunction = builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            return FtlCallableType.createLightFunctionType(builtIn, string, "substring", string);
        };
        for (String s : (String[])ContainerUtil.ar((Object[])new String[]{"removeBeginning", "removeEnding", "keepBefore", "keepBeforeLast", "keepAfter", "keepAfterLast"})) {
            ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn(s, (Function<? super FtlBuiltIn, ? extends FtlType>)substringFunction));
        }
        ourBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("absoluteTemplateName", (Function<? super FtlBuiltIn, ? extends FtlType>)((Function)builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            return new FtlCompositeType(string, FtlCallableType.createLightFunctionType(builtIn, string, "baseName", string));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("c", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("string", (Function<? super FtlBuiltIn, ? extends FtlType>)((Function)builtIn -> {
            FtlCustomVariable customVariable = new FtlCustomVariable("string", (PsiElement)builtIn);
            FtlType string = (FtlType)stringType.fun(builtIn);
            Stream.of("number", "currency", "percent", "computer").forEach(child -> customVariable.addSubVariable(new FtlLightVariable((String)child, (PsiElement)builtIn, string)));
            return new FtlCompositeType(string, new FtlHashType(customVariable), builtIn.getParent() instanceof FtlIndexExpression ? FtlBuiltIns.getStringStringMap(builtIn) : null, FtlCallableType.createLightFunctionType(builtIn, string, "format", string));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("round", (PsiType)PsiType.INT));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("floor", (PsiType)PsiType.INT));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("ceiling", (PsiType)PsiType.INT));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("abs", (PsiType)PsiType.BYTE));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("upperAbc", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("lowerAbc", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("isInfinite", (PsiType)PsiType.BOOLEAN));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("isNan", (PsiType)PsiType.BOOLEAN));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("string", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            return new FtlCompositeType(string, FtlBuiltIns.getDateFormatHash(builtIn), builtIn.getParent() instanceof FtlIndexExpression ? FtlBuiltIns.getStringStringMap(builtIn) : null, FtlCallableType.createLightFunctionType(builtIn, string, "format", string));
        })));
        ConstantFunction dateTime = new ConstantFunction((Object)FtlDateType.INSTANCE);
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("date", (Function<? super FtlBuiltIn, ? extends FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("time", (Function<? super FtlBuiltIn, ? extends FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("datetime", (Function<? super FtlBuiltIn, ? extends FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("dateIfUnknown", (Function<? super FtlBuiltIn, ? extends FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("datetimeIfUnknown", (Function<? super FtlBuiltIn, ? extends FtlType>)dateTime));
        ourBuiltIns.add(new FtlBuiltInDescriptor.DateBuiltIn("timeIfUnknown", (Function<? super FtlBuiltIn, ? extends FtlType>)dateTime));
        FtlBuiltIns.addDateFormatBuiltIns((Function<FtlBuiltIn, FtlType>)stringType);
        ourBuiltIns.add(new FtlBuiltInDescriptor.BooleanBuiltIn("string", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            FtlType string = (FtlType)stringType.fun(builtIn);
            return new FtlCompositeType(string, FtlCallableType.createLightFunctionType(builtIn, string, "true", string, "false", string));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.BooleanBuiltIn("c", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.BooleanBuiltIn("then", (Function<? super FtlBuiltIn, ? extends FtlType>)FtlArgumentDependentBuiltIn.THEN));
        NullableFunction sequenceComponent = builtIn -> {
            FtlType component = FtlListDirective.getComponentType(builtIn.getQualifierType());
            return component != null ? component : FtlPsiType.wrap((PsiType)PsiType.getJavaLangObject((PsiManager)builtIn.getManager(), (GlobalSearchScope)builtIn.getResolveScope()));
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("first", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sequenceComponent));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("last", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sequenceComponent));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("seqContains", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> FtlCallableType.createLightFunctionType(builtIn, booleanType, "element", (FtlType)sequenceComponent.fun(builtIn)))));
        NullableFunction sequenceIndexOf = builtIn -> new FtlCompositeType(FtlCallableType.createLightFunctionType(builtIn, intType, "element", (FtlType)sequenceComponent.fun(builtIn)), FtlCallableType.createLightFunctionType(builtIn, intType, "element", (FtlType)sequenceComponent.fun(builtIn), "from", intType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("seqIndexOf", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sequenceIndexOf));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("seqLastIndexOf", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sequenceIndexOf));
        NullableFunction sameCollection = builtIn -> {
            FtlType type = builtIn.getQualifierType();
            return type == null ? new FtlCollectionType(null) : type;
        };
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("reverse", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sameCollection));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("join", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)context -> {
            FtlType string = (FtlType)stringType.fun(context);
            return new FtlCompositeType(FtlCallableType.createLightFunctionType(context, string, "separator", string), FtlCallableType.createLightFunctionType(context, string, "separator", string, "empty", string), FtlCallableType.createLightFunctionType(context, string, "separator", string, "empty", string, "listEnding", string));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("sort", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sameCollection));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("sortBy", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            FtlType qualifierType = builtIn.getQualifierType();
            FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(FtlListDirective.getComponentType(qualifierType), FtlPsiType.class);
            PsiType componentType = ftlPsiType == null ? null : ftlPsiType.getPsiType();
            PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)componentType, (String)"java.util.Map", (int)0, (boolean)true);
            return FtlCallableType.createLightFunctionType(builtIn, qualifierType, "key", FtlPsiType.wrap(keyType));
        })));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("chunk", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> FtlCallableType.createLightFunctionType(builtIn, new FtlCollectionType(builtIn.getQualifierType()), "size", intType))));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("sequence", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sameCollection));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("max", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sequenceComponent));
        ourBuiltIns.add(new FtlBuiltInDescriptor.SequenceBuiltIn("min", (NullableFunction<? super FtlBuiltIn, ? extends FtlType>)sequenceComponent));
        ourBuiltIns.add(new FtlBuiltInDescriptor.HashBuiltIn("keys", 0));
        ourBuiltIns.add(new FtlBuiltInDescriptor.HashBuiltIn("values", 1));
        ourBuiltIns.add(new FtlBuiltInDescriptor("size", (PsiType)PsiType.INT){

            @Override
            public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
                if (qualifierType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                return FtlListDirective.isCollectionType(qualifierType) || FtlBuiltInDescriptor.HashBuiltIn.isHash(qualifierType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "qualifierType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlBuiltIns$2";
                objectArray[2] = "acceptsQualifier";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("counter", intType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("index", intType));
        for (String s : (String[])ContainerUtil.ar((Object[])new String[]{"hasNext", "isEvenItem", "isOddItem", "isFirst", "isLast"})) {
            ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn(s, booleanType));
        }
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("itemParity", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("itemParityCap", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.LoopVariableBuiltIn("itemCycle", (Function<? super FtlBuiltIn, ? extends FtlType>)FtlArgumentDependentBuiltIn.ITEM_CYCLE));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("children", new FtlCollectionType(FtlNodeType.INSTANCE)));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("parent", FtlNodeType.INSTANCE));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("root", FtlNodeType.INSTANCE));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("ancestors", new FtlCollectionType(FtlNodeType.INSTANCE)));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("nodeName", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("nodeType", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("nodeNamespace", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("nextSibling", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.NodeBuiltIn("previousSibling", (Function<? super FtlBuiltIn, ? extends FtlType>)stringType));
        ourBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("switch", (Function<? super FtlBuiltIn, ? extends FtlType>)FtlArgumentDependentBuiltIn.SWITCH));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("byte", (PsiType)PsiType.BYTE));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("double", (PsiType)PsiType.DOUBLE));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("float", (PsiType)PsiType.FLOAT));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("int", (PsiType)PsiType.INT));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("long", (PsiType)PsiType.LONG));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("short", (PsiType)PsiType.SHORT));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("numberToDate", (Function<? super FtlBuiltIn, ? extends FtlType>)formattedDateTime));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("numberToTime", (Function<? super FtlBuiltIn, ? extends FtlType>)formattedDateTime));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.NumberBuiltIn("numberToDatetime", (Function<? super FtlBuiltIn, ? extends FtlType>)formattedDateTime));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("eval", (Function<? super FtlBuiltIn, ? extends FtlType>)new NullableConstantFunction(null)));
        for (String s : object2Boolean = new String[]{"hasContent", "hasApi", "isString", "isNumber", "isBoolean", "isMarkupOutput", "isDate", "isDateLike", "isDateOnly", "isTime", "isDatetime", "isUnknownDateLike", "isMethod", "isTransform", "isMacro", "isHash", "isHashEx", "isSequence", "isCollection", "isCollectionEx", "isEnumerable", "isIndexable", "isDirective", "isNode"}) {
            ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn(s, (PsiType)PsiType.BOOLEAN));
        }
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("api", (Function<? super FtlBuiltIn, ? extends FtlType>)((Function)FtlBuiltIn::getQualifierType)));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("interpret", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> new FtlCallableType(true, new FtlParameter[0]))));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor("namespace", stringType){

            @Override
            public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
                FtlCallableType callableType;
                if (qualifierType == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                return (callableType = qualifierType.asInstanceOf(FtlCallableType.class)) != null && callableType.isMacro();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "qualifierType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/FtlBuiltIns$3";
                objectArray[2] = "acceptsQualifier";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.StringBuiltIn("new", (Function<? super FtlBuiltIn, ? extends FtlType>)((NullableFunction)builtIn -> {
            JavaPsiFacade facade;
            PsiClass psiClass;
            Object value = builtIn.getQualifier().getConstantValue();
            if (value instanceof String && (psiClass = (facade = JavaPsiFacade.getInstance((Project)builtIn.getProject())).findClass((String)value, builtIn.getResolveScope())) != null) {
                SmartList results = new SmartList();
                final FtlPsiType returnType = FtlPsiType.wrap((PsiType)facade.getElementFactory().createType(psiClass));
                for (PsiMethod method : psiClass.getConstructors()) {
                    if (!method.hasModifierProperty("public")) continue;
                    results.add(new FtlMethodType(method, PsiSubstitutor.EMPTY){

                        @Override
                        public FtlType getResultType() {
                            return returnType;
                        }
                    });
                }
                if (results.size() > 1) {
                    return new FtlCompositeType(results.toArray(FtlCallableType.EMPTY_ARRAY));
                }
                if (results.size() == 1) {
                    return (FtlType)results.get(0);
                }
            }
            return new FtlCallableType(false, new FtlParameter[0]);
        })));
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("default", (Function)((NullableFunction)builtIn -> FtlCallableType.createLightFunctionType(builtIn, builtIn.getQualifierType(), "defaultValue", builtIn.getQualifierType()))){

            @Override
            public boolean isDeprecated() {
                return true;
            }

            @Override
            public String getQuickFixReplacement(FtlBuiltIn builtIn) {
                FtlMethodCallExpression expression;
                FtlExpression[] arguments;
                if (builtIn.getParent() instanceof FtlMethodCallExpression && (arguments = (expression = (FtlMethodCallExpression)builtIn.getParent()).getArgumentList().getPositionalArguments()).length == 1) {
                    return "!" + arguments[0].getText();
                }
                return null;
            }
        });
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("exists", (PsiType)PsiType.BOOLEAN){

            @Override
            public boolean isDeprecated() {
                return true;
            }

            @Override
            public String getQuickFixReplacement(FtlBuiltIn builtIn) {
                return "??";
            }
        });
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("ifExists", FtlBuiltIn::getQualifierType){

            @Override
            public boolean isDeprecated() {
                return true;
            }

            @Override
            public String getQuickFixReplacement(FtlBuiltIn builtIn) {
                return "!";
            }
        });
        ourDeprecatedBuiltIns.add(new FtlBuiltInDescriptor.ObjectBuiltIn("webSafe", stringType){

            @Override
            public boolean isDeprecated() {
                return true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/freemarker/FtlBuiltIns";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringStringMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormatHash";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltIns";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

