/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.ui;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class MobileModuleResourcesSettings
implements ModuleConfigurationEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    private final Module myModule;
    private final J2MEModuleProperties myProperties;
    private final ModifiableRootModel myRootModel;
    private final JPanel myWholePanel = new JPanel(new BorderLayout());
    private final TextFieldWithBrowseButton myResources = new TextFieldWithBrowseButton();
    private final JPanel myResourcesPanel = new JPanel(new GridBagLayout());
    private final JCheckBox myResourcesEnable = new JCheckBox(J2MEBundle.message("resource.directory.create.command", new Object[0]));
    private boolean myModified = false;
    private final String myDefaultResourcesDir;

    public MobileModuleResourcesSettings(Module module, ModifiableRootModel rootModel) {
        this.myRootModel = rootModel;
        this.myModule = module;
        this.myProperties = J2MEModuleProperties.getInstance(this.myModule);
        this.myDefaultResourcesDir = (String)ReadAction.compute(() -> {
            String res = "res";
            return new File(this.myModule.getModuleFilePath()).getParent().replace('/', File.separatorChar) + File.separatorChar + "res";
        });
    }

    public String getDisplayName() {
        return J2MEBundle.message("resources.settings.title", new Object[0]);
    }

    public String getHelpTopic() {
        return "j2me.moduleJ2ME";
    }

    public JComponent createComponent() {
        this.myResources.setText(this.myProperties.getResourcePath());
        this.myResourcesEnable.setSelected(this.myProperties.getResourcePath() != null);
        this.myResources.setEnabled(this.myResourcesEnable.isSelected());
        this.myResourcesEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobileModuleResourcesSettings.this.myResources.setEnabled(MobileModuleResourcesSettings.this.myResourcesEnable.isSelected());
                if (MobileModuleResourcesSettings.this.myResources.isEnabled()) {
                    MobileModuleResourcesSettings.this.myResources.setText(MobileModuleResourcesSettings.this.myProperties.getResourcePath() != null ? MobileModuleResourcesSettings.this.myProperties.getResourcePath() : MobileModuleResourcesSettings.this.myDefaultResourcesDir);
                }
                MobileModuleResourcesSettings.this.myModified = true;
            }
        });
        this.myResources.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MobileModuleResourcesSettings.this.myModified = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/j2meplugin/module/settings/ui/MobileModuleResourcesSettings$2", "textChanged"));
            }
        });
        this.myResources.addBrowseFolderListener(J2MEBundle.message("resource.directory.chooser", new Object[0]), J2MEBundle.message("resource.directory.chooser", new Object[0]), this.myModule.getProject(), new FileChooserDescriptor(false, true, false, true, false, false));
        this.myWholePanel.add((Component)this.myResourcesEnable, "North");
        this.myResourcesPanel.add((Component)this.myResources, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 12, 2, (Insets)JBUI.insets((int)6, (int)12, (int)0, (int)2), 0, 0));
        JPanel resourcePanel = new JPanel(new BorderLayout());
        resourcePanel.add((Component)this.myResourcesPanel, "North");
        this.myWholePanel.add((Component)resourcePanel, "Center");
        this.myWholePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return this.myWholePanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() throws ConfigurationException {
        if (this.myResourcesEnable.isSelected()) {
            if (this.myResources.getText() == null || this.myResources.getText().length() == 0) {
                throw new ConfigurationException(J2MEBundle.message("resource.directory.not.set", new Object[0]));
            }
            this.myProperties.setResourcePath(this.myResources.getText());
            if (!new File(this.myResources.getText()).exists()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        String path = FileUtil.toSystemIndependentName((String)MobileModuleResourcesSettings.this.myResources.getText());
                        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                        if (file == null) {
                            final File ioFile = new File(MobileModuleResourcesSettings.this.myResources.getText());
                            CommandProcessor.getInstance().executeCommand(MobileModuleResourcesSettings.this.myModule.getProject(), new Runnable(){

                                @Override
                                public void run() {
                                    VirtualFile dir;
                                    FileUtil.createParentDirs((File)ioFile);
                                    LocalFileSystem lfs = LocalFileSystem.getInstance();
                                    File ioFileParentFile = ioFile.getParentFile();
                                    VirtualFile virtualFile = dir = ioFileParentFile != null ? lfs.refreshAndFindFileByIoFile(ioFileParentFile) : null;
                                    if (dir != null) {
                                        try {
                                            dir.createChildDirectory((Object)this, ioFile.getName());
                                        }
                                        catch (IOException e) {
                                            LOG.error((Throwable)e);
                                        }
                                    }
                                }
                            }, J2MEBundle.message("resource.directory.create.command", new Object[0]), null);
                        }
                    }
                });
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                VirtualFile res;
                String resourcesPath = this.myResources.getText();
                if (resourcesPath == null || resourcesPath.length() == 0) {
                    return;
                }
                String path = FileUtil.toSystemIndependentName((String)resourcesPath);
                ContentEntry contentEntry = null;
                for (ContentEntry entry : this.myRootModel.getContentEntries()) {
                    VirtualFile contentRoot = entry.getFile();
                    if (contentRoot == null || !path.startsWith(contentRoot.getPath())) continue;
                    contentEntry = entry;
                    break;
                }
                if (contentEntry == null) {
                    VirtualFile ioFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path).getParentFile());
                    if (ioFile == null) {
                        return;
                    }
                    contentEntry = this.myRootModel.addContentEntry(ioFile);
                }
                if ((res = LocalFileSystem.getInstance().refreshAndFindFileByPath(path)) != null) {
                    contentEntry.addSourceFolder(res, false);
                }
            });
        } else {
            if (this.myProperties.getResourcePath() != null) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (int i = 0; i < this.myRootModel.getContentEntries().length; ++i) {
                        ContentEntry contentEntry = this.myRootModel.getContentEntries()[i];
                        for (SourceFolder folder : contentEntry.getSourceFolders()) {
                            VirtualFile sourceRoot = folder.getFile();
                            if (sourceRoot == null || sourceRoot.getPath().compareTo(FileUtil.toSystemIndependentName((String)this.myProperties.getResourcePath())) != 0) continue;
                            contentEntry.removeSourceFolder(folder);
                        }
                    }
                });
            }
            this.myProperties.setResourcePath(null);
        }
        this.myModified = false;
    }

    public void reset() {
        this.myResources.setText(this.myProperties.getResourcePath());
        this.myResourcesEnable.setSelected(this.myProperties.getResourcePath() != null);
        this.myModified = false;
    }

    public void disposeUIResources() {
    }
}

