/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.EmulatorUtil;
import com.intellij.j2meplugin.emulator.MobileSdkUtil;
import com.intellij.j2meplugin.emulator.ui.MobileSdkConfigurable;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.JavaDependentSdkType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import icons.J2mepluginIcons;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobileSdk
extends JavaDependentSdkType
implements JavaSdkType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");

    public MobileSdk() {
        super("MobileSDK");
    }

    @NotNull
    public String getPresentableName() {
        String string = J2MEBundle.message("jdk.type.name", new Object[0]);
        if (string == null) {
            MobileSdk.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return J2mepluginIcons.Sdk_closed;
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = J2mepluginIcons.Add_sdk;
        if (icon == null) {
            MobileSdk.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public static MobileSdk getInstance() {
        return (MobileSdk)SdkType.findInstance(MobileSdk.class);
    }

    public static boolean checkCorrectness(Sdk projectJdk, Module module) {
        EmulatorType emulatorType;
        if (projectJdk == null) {
            return false;
        }
        if (!projectJdk.getSdkType().equals((Object)MobileSdk.getInstance())) {
            return false;
        }
        if (!(projectJdk.getSdkAdditionalData() instanceof Emulator)) {
            return false;
        }
        Emulator emulator = (Emulator)projectJdk.getSdkAdditionalData();
        if (emulator.getHome() == null) {
            emulator.setHome(projectJdk.getHomePath());
        }
        if ((emulatorType = emulator.getEmulatorType()) == null) {
            return false;
        }
        Sdk javaSdk = emulator.getJavaSdk();
        if (javaSdk == null || !javaSdk.getSdkType().equals(JavaSdk.getInstance())) {
            return false;
        }
        return module == null || ModuleType.get((Module)module).equals((Object)J2MEModuleType.getInstance()) && J2MEModuleProperties.getInstance(module).getMobileApplicationType() != null;
    }

    @Nullable
    public static EmulatorType getEmulatorType(Sdk jdk, Module module) {
        if (MobileSdk.checkCorrectness(jdk, module)) {
            return ((Emulator)jdk.getSdkAdditionalData()).getEmulatorType();
        }
        return null;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            MobileSdk.$$$reportNull$$$0(2);
        }
        if (sdkModificator == null) {
            MobileSdk.$$$reportNull$$$0(3);
        }
        return new MobileSdkConfigurable(sdkModel, sdkModificator);
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            MobileSdk.$$$reportNull$$$0(4);
        }
        if (additional == null) {
            MobileSdk.$$$reportNull$$$0(5);
        }
        if (!(additionalData instanceof Emulator)) {
            return;
        }
        try {
            ((Emulator)additionalData).writeExternal(additional);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
    }

    public SdkAdditionalData loadAdditionalData(Element additional) {
        Emulator emulator = new Emulator();
        try {
            emulator.readExternal(additional);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return emulator;
    }

    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            MobileSdk.$$$reportNull$$$0(6);
        }
        if (!MobileSdk.checkCorrectness(sdk, null)) {
            return null;
        }
        Sdk mySdk = ((Emulator)sdk.getSdkAdditionalData()).getJavaSdk();
        LOG.assertTrue(mySdk != null);
        return ((JavaSdk)mySdk.getSdkType()).getBinPath(mySdk);
    }

    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            MobileSdk.$$$reportNull$$$0(7);
        }
        if (!MobileSdk.checkCorrectness(sdk, null)) {
            return null;
        }
        Sdk mySdk = ((Emulator)sdk.getSdkAdditionalData()).getJavaSdk();
        LOG.assertTrue(mySdk != null);
        return ((JavaSdk)mySdk.getSdkType()).getToolsPath(mySdk);
    }

    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            MobileSdk.$$$reportNull$$$0(8);
        }
        if (!MobileSdk.checkCorrectness(sdk, null)) {
            return null;
        }
        Sdk mySdk = ((Emulator)sdk.getSdkAdditionalData()).getJavaSdk();
        LOG.assertTrue(mySdk != null);
        return ((JavaSdk)mySdk.getSdkType()).getVMExecutablePath(mySdk);
    }

    public String suggestHomePath() {
        return null;
    }

    public boolean isValidSdkHome(String path) {
        return EmulatorUtil.getValidEmulatorType(path) != null;
    }

    public String getVersionString(String sdkHome) {
        return "1.3";
    }

    @NotNull
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String name;
        EmulatorType emulatorType = EmulatorUtil.getValidEmulatorType(sdkHome);
        if (emulatorType != null && emulatorType.suggestName(sdkHome) != null && (name = emulatorType.suggestName(sdkHome)) != null) {
            String string = name;
            if (string == null) {
                MobileSdk.$$$reportNull$$$0(9);
            }
            return string;
        }
        if ("Mobile SDK" == null) {
            MobileSdk.$$$reportNull$$$0(10);
        }
        return "Mobile SDK";
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        File api;
        if (sdk == null) {
            MobileSdk.$$$reportNull$$$0(11);
        }
        VirtualFile[] classes = null;
        File mobileJdkHome = new File(sdk.getHomePath());
        EmulatorType emulatorType = EmulatorUtil.getValidEmulatorType(sdk.getHomePath());
        LOG.assertTrue(emulatorType != null);
        String[] apiClasses = emulatorType.getApi(sdk.getHomePath());
        if (apiClasses != null) {
            classes = MobileSdkUtil.findApiClasses(apiClasses);
        }
        if (classes == null || classes.length == 0) {
            classes = MobileSdkUtil.findApiClasses(mobileJdkHome);
        }
        ArrayList docs = new ArrayList();
        String docsString = "docs";
        String apiString = "api";
        String docString = "doc";
        File file = new File(new File(mobileJdkHome, "docs"), "api").exists() ? new File(new File(mobileJdkHome, "docs"), "api") : (api = new File(new File(mobileJdkHome, "doc"), "api").exists() ? new File(new File(mobileJdkHome, "doc"), "api") : null);
        if (api != null) {
            MobileSdkUtil.findDocs(api, docs);
        } else {
            MobileSdkUtil.findDocs(mobileJdkHome, docs);
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        for (int i = 0; classes != null && i < classes.length; ++i) {
            sdkModificator.addRoot(classes[i], OrderRootType.CLASSES);
        }
        for (VirtualFile doc : docs) {
            sdkModificator.addRoot(doc, JavadocOrderRootType.getInstance());
        }
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)new Emulator(emulatorType, null, EmulatorUtil.findFirstJavaSdk(), sdk.getHomePath()));
        sdkModificator.commitChanges();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2meplugin/emulator/MobileSdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2meplugin/emulator/MobileSdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

