/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.compiler;

import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.general.UserDefinedOption;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;

public class MobileMakeUtil {
    private MobileMakeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeJad(MobileModuleSettings settings, String jadPath, boolean leaveSettings) throws Exception {
        VirtualFile virtualFile;
        MobileApplicationType applicationType = settings.getApplicationType();
        String separator = applicationType.getSeparator();
        File jadFile = new File(jadPath);
        if (!leaveSettings && (virtualFile = LocalFileSystem.getInstance().findFileByIoFile(jadFile)) != null && ReadonlyStatusHandler.getInstance((Project)settings.getModule().getProject()).ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles()) {
            return;
        }
        File jarFile = new File(settings.getJarURL());
        if (jarFile.exists()) {
            settings.prepareJarSettings();
        }
        BufferedReader is = null;
        PrintWriter printWriter = null;
        try {
            if (settings.isSynchronized() && leaveSettings) {
                String jarSizeSettingName = applicationType.getJarSizeSettingName();
                String string = settings.getSettings().get(jarSizeSettingName);
                String jarSizeLine = jarSizeSettingName + separator + " " + string;
                boolean sizeWasDeleted = true;
                ArrayList<String> lineStore = new ArrayList<String>();
                is = new BufferedReader(new FileReader(jadFile));
                String line = is.readLine();
                while (line != null) {
                    String name = line.substring(0, line.indexOf(separator));
                    if (name.trim().compareToIgnoreCase(jarSizeSettingName) != 0) {
                        lineStore.add(line);
                    } else {
                        sizeWasDeleted = false;
                        lineStore.add(jarSizeLine);
                    }
                    line = is.readLine();
                }
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(jadFile)));
                if (sizeWasDeleted) {
                    printWriter.println(jarSizeLine);
                }
                for (String byLine : lineStore) {
                    printWriter.println(byLine);
                }
            } else {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(jadFile)));
                for (String string : settings.getSettings().keySet()) {
                    printWriter.println(string + separator + " " + (settings.isMidletKey(string) ? settings.getSettings().get(string).replaceAll(",", ", ") : settings.getSettings().get(string)));
                }
                for (UserDefinedOption userDefinedOption : settings.getUserDefinedOptions()) {
                    printWriter.println(userDefinedOption.getKey() + separator + " " + userDefinedOption.getValue());
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        LocalFileSystem.getInstance().refresh(false);
    }

    public static void makeJad(MobileModuleSettings settings, boolean leaveSettings) throws Exception {
        String jadPath = settings.getMobileDescriptionPath().replace(File.separatorChar, '/');
        MobileMakeUtil.makeJad(settings, jadPath, leaveSettings);
    }

    public static void getDependencies(Module module, Set<? super Module> modules) {
        Module[] dependencies;
        if (modules.contains(module)) {
            return;
        }
        for (Module dependency : dependencies = ModuleRootManager.getInstance((Module)module).getDependencies()) {
            modules.add((Module)dependency);
            if (modules.contains(dependency)) continue;
            MobileMakeUtil.getDependencies(dependency, modules);
        }
    }
}

