/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.util;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class OsgiBuildUtil {
    private static final boolean ourMavenPluginLoaded;

    @NotNull
    public static Properties getMavenProjectProperties(@NotNull CompileContext context, @NotNull JpsModule module) {
        if (context == null) {
            OsgiBuildUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            OsgiBuildUtil.$$$reportNull$$$0(1);
        }
        Properties result = new Properties();
        if (ourMavenPluginLoaded) {
            OsgiBuildUtil.collectMavenProjectProperties(context, module, result);
        }
        Properties properties = result;
        if (properties == null) {
            OsgiBuildUtil.$$$reportNull$$$0(2);
        }
        return properties;
    }

    @Nullable
    public static File getMavenProjectPath(@NotNull CompileContext context, @NotNull JpsModule module) {
        if (context == null) {
            OsgiBuildUtil.$$$reportNull$$$0(3);
        }
        if (module == null) {
            OsgiBuildUtil.$$$reportNull$$$0(4);
        }
        return ourMavenPluginLoaded ? OsgiBuildUtil.findMavenProjectPath(context, module) : null;
    }

    private static void collectMavenProjectProperties(CompileContext context, JpsModule module, Properties result) {
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig != null) {
            JpsJavaExtensionService.dependencies((JpsModule)module).recursively().productionOnly().processModules(module1 -> {
                MavenModuleResourceConfiguration moduleConfig = (MavenModuleResourceConfiguration)projectConfig.moduleConfigurations.get(module1.getName());
                if (moduleConfig != null) {
                    for (Map.Entry entry : moduleConfig.properties.entrySet()) {
                        result.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            });
        }
    }

    private static File findMavenProjectPath(CompileContext context, JpsModule module) {
        MavenModuleResourceConfiguration moduleConfig;
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig != null && (moduleConfig = (MavenModuleResourceConfiguration)projectConfig.moduleConfigurations.get(module.getName())) != null) {
            return new File(FileUtil.toSystemDependentName((String)moduleConfig.directory), "pom.xml");
        }
        return null;
    }

    @Nullable
    public static File findFileInModuleContentRoots(@NotNull JpsModule module, @NotNull String relativePath) {
        if (module == null) {
            OsgiBuildUtil.$$$reportNull$$$0(5);
        }
        if (relativePath == null) {
            OsgiBuildUtil.$$$reportNull$$$0(6);
        }
        String ioRelativePath = FileUtil.toSystemDependentName((String)relativePath);
        for (String rootUrl : module.getContentRootsList().getUrls()) {
            File root = JpsPathUtil.urlToFile((String)rootUrl);
            File result = new File(root, ioRelativePath);
            if (!result.exists()) continue;
            return result;
        }
        return null;
    }

    static {
        boolean pluginLoaded = false;
        try {
            Class.forName("org.jetbrains.jps.maven.model.JpsMavenExtensionService");
            pluginLoaded = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ourMavenPluginLoaded = pluginLoaded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/jps/util/OsgiBuildUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/jps/util/OsgiBuildUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenProjectProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMavenProjectProperties";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMavenProjectPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFileInModuleContentRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

