/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.osgi.jps.build.BndWrapper;
import org.jetbrains.osgi.jps.build.OsmorcBuildTargetType;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;
import org.jetbrains.osgi.jps.util.OsgiBuildUtil;

public class OsmorcBuildTarget
extends ModuleBasedTarget<BuildRootDescriptor> {
    private final JpsOsmorcModuleExtension myExtension;
    private List<File> myOutputRoots;

    public OsmorcBuildTarget(@NotNull JpsOsmorcModuleExtension extension, @NotNull JpsModule module) {
        if (extension == null) {
            OsmorcBuildTarget.$$$reportNull$$$0(0);
        }
        if (module == null) {
            OsmorcBuildTarget.$$$reportNull$$$0(1);
        }
        super((ModuleBasedBuildTargetType)OsmorcBuildTargetType.INSTANCE, module);
        this.myOutputRoots = null;
        this.myExtension = extension;
    }

    public JpsOsmorcModuleExtension getExtension() {
        return this.myExtension;
    }

    public String getId() {
        return this.myModule.getName();
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        BuildTargetRegistry.ModuleTargetSelector selector = BuildTargetRegistry.ModuleTargetSelector.PRODUCTION;
        return Collections.unmodifiableCollection(targetRegistry.getModuleBasedTargets(this.getModule(), selector));
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File file;
        ArrayList rootDescriptors = ContainerUtil.newArrayList();
        JpsOsmorcModuleExtension extension = JpsOsmorcExtensionService.getExtension(this.getModule());
        if (extension != null && (file = extension.getBundleDescriptorFile()) != null) {
            rootDescriptors.add(new BuildRootDescriptorImpl((BuildTarget)this, file, true));
        }
        JpsJavaExtensionService.dependencies((JpsModule)this.getModule()).recursively().productionOnly().processModules(module -> {
            File root;
            if ((module == this.getModule() || JpsOsmorcExtensionService.getExtension(module) == null) && (root = JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, false)) != null) {
                rootDescriptors.add(new BuildRootDescriptorImpl((BuildTarget)this, root, true));
            }
        });
        ArrayList arrayList = rootDescriptors;
        if (arrayList == null) {
            OsmorcBuildTarget.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        return (BuildRootDescriptor)ContainerUtil.find((Iterable)rootIndex.getTargetRoots((BuildTarget)this, null), descriptor -> descriptor.getRootId().equals(rootId));
    }

    @NotNull
    public String getPresentableName() {
        String string = "OSGi in module '" + this.getModule().getName() + "'";
        if (string == null) {
            OsmorcBuildTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        if (this.myOutputRoots == null) {
            String location = this.myExtension.getJarFileLocation();
            if (!location.isEmpty()) {
                List<String> bundleNames;
                File bndFile;
                this.myOutputRoots = ContainerUtil.newArrayList();
                if (this.myExtension.isUseBndFile() && (bndFile = OsgiBuildUtil.findFileInModuleContentRoots(this.myModule, this.myExtension.getBndFileLocation())) != null && bndFile.isFile() && !(bundleNames = BndWrapper.getBundleNames(bndFile)).isEmpty()) {
                    String bundleDir = new File(location).getParent();
                    bundleNames.stream().map(name -> new File(bundleDir, (String)name)).forEach(this.myOutputRoots::add);
                }
                if (this.myOutputRoots.isEmpty()) {
                    this.myOutputRoots.add(new File(location));
                }
            } else {
                this.myOutputRoots = Collections.emptyList();
            }
        }
        List<File> list = this.myOutputRoots;
        if (list == null) {
            OsmorcBuildTarget.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isTests() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OsmorcBuildTarget target = (OsmorcBuildTarget)((Object)o);
        return this.myExtension.equals(target.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/jps/build/OsmorcBuildTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/jps/build/OsmorcBuildTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

