/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.javaee.directoryManager.SystemBaseDirectoryManager;
import com.intellij.javaee.jmxremote.JmxRemoteAware;
import com.intellij.javaee.oss.jetty.JettySystemBaseDirectoryManager;
import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyDeployTarget;
import com.intellij.javaee.oss.jetty.server.JettyLocalEditor;
import com.intellij.javaee.oss.jetty.server.JettyModelData;
import com.intellij.javaee.oss.jetty.server.JettyPortConfig;
import com.intellij.javaee.oss.jetty.server.JettyServerModel;
import com.intellij.javaee.oss.server.JavaeeServerBaseProvider;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JettyLocalModel
extends JettyServerModel<JettyLocalModelData>
implements JmxRemoteAware {
    private static final Logger LOG = Logger.getInstance(JettyLocalModel.class);
    private List<JettyConfigFile> myConfigFiles = JettyLocalModel.createDefaultConfigFiles();
    private File mySessionTemporalContextsFolder;
    private String myJmxUsername;
    private String myJmxPassword;
    private String myBaseDirectoryName;

    public static JettyConfigFile createJmxConfigFile() {
        JettyConfigFile result = new JettyConfigFile(FileUtil.toSystemDependentName((String)"modules/jmx.mod"));
        result.setActive(true);
        return result;
    }

    protected String getWorkDir() {
        return JettyUtil.getWorkDir(this.getVersion(), this.getHome(), new JavaeeServerBaseProvider((JavaeeServerModel)this).getValue());
    }

    private static List<JettyConfigFile> createDefaultConfigFiles() {
        return new ArrayList<JettyConfigFile>(Collections.singletonList(JettyLocalModel.createJmxConfigFile()));
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new JettyLocalEditor();
    }

    private File getDeployDestinationFolder(JettyDeployTarget deployTarget) {
        File targetDir = new File(this.getHome(), deployTarget.getLocalHomeSubFolder());
        if (!targetDir.exists()) {
            LOG.error("Can't find target folder: " + targetDir.getAbsolutePath());
            return null;
        }
        return targetDir;
    }

    private static File getDestinationFile(File sourceFile, File destinationFolder) {
        return new File(destinationFolder, sourceFile.getName());
    }

    public static boolean transferFile(File sourceFile, File destinationFolder) {
        try {
            File destinationFile = JettyLocalModel.getDestinationFile(sourceFile, destinationFolder);
            FileUtil.copyFileOrDir((File)sourceFile, (File)destinationFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean deleteFile(File sourceFile, File destinationFolder) {
        File destinationFile = JettyLocalModel.getDestinationFile(sourceFile, destinationFolder);
        return FileUtil.delete((File)destinationFile);
    }

    @Override
    public boolean transferFile(File webAppFile, JettyDeployTarget deployTarget) {
        File destinationFolder = this.getDeployDestinationFolder(deployTarget);
        if (destinationFolder == null) {
            return false;
        }
        return JettyLocalModel.transferFile(webAppFile, destinationFolder);
    }

    @Override
    public boolean deleteFile(File webAppFile, JettyDeployTarget deployTarget) {
        File destinationFolder = this.getDeployDestinationFolder(deployTarget);
        if (destinationFolder == null) {
            return false;
        }
        return JettyLocalModel.deleteFile(webAppFile, destinationFolder);
    }

    public List<JettyConfigFile> getConfigFiles() {
        return this.myConfigFiles;
    }

    public void setConfigFiles(List<JettyConfigFile> configFiles) {
        this.myConfigFiles = configFiles;
    }

    @Override
    protected Class<JettyLocalModelData> getDataClass() {
        return JettyLocalModelData.class;
    }

    @Override
    protected JettyLocalModelData createData() {
        return new JettyLocalModelData();
    }

    @Override
    protected void readFromData(JettyLocalModelData settings) {
        this.myConfigFiles = settings.getConfigFiles();
        this.myBaseDirectoryName = settings.getBaseDirectoryName();
    }

    @Override
    protected void writeToData(JettyLocalModelData settings) {
        settings.setConfigFiles(this.myConfigFiles);
        settings.setBaseDirectoryName(this.myBaseDirectoryName);
    }

    public File getSessionTemporalContextsFolder() {
        return this.mySessionTemporalContextsFolder;
    }

    public void setSessionTemporalContextsFolder(File sessionTemporalContextsFolder) {
        this.mySessionTemporalContextsFolder = sessionTemporalContextsFolder;
    }

    public boolean isDetectableServerPort() {
        return false;
    }

    public int getLocalPort() {
        return JettyPortConfig.getHttp(this);
    }

    @Override
    @Nullable
    protected String getJmxUsername() {
        return this.myJmxUsername;
    }

    public void setJmxUsername(@Nullable String jmxUsername) {
        this.myJmxUsername = jmxUsername;
    }

    @Override
    @Nullable
    protected String getJmxPassword() {
        return this.myJmxPassword;
    }

    public void setJmxPassword(@Nullable String jmxPassword) {
        this.myJmxPassword = jmxPassword;
    }

    @NotNull
    public SystemBaseDirectoryManager getSystemBaseDirectoryManager() {
        SystemBaseDirectoryManager systemBaseDirectoryManager = JettySystemBaseDirectoryManager.getInstance();
        if (systemBaseDirectoryManager == null) {
            JettyLocalModel.$$$reportNull$$$0(0);
        }
        return systemBaseDirectoryManager;
    }

    @Nullable
    public String getBaseDirectoryName() {
        return this.myBaseDirectoryName;
    }

    public void setBaseDirectoryName(@Nullable String baseDirectoryName) {
        this.myBaseDirectoryName = baseDirectoryName;
    }

    static /* synthetic */ List access$000() {
        return JettyLocalModel.createDefaultConfigFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jetty/server/JettyLocalModel", "getSystemBaseDirectoryManager"));
    }

    @Tag(value="data")
    public static class JettyLocalModelData
    implements JettyModelData {
        @Tag(value="jndi-port")
        private int myJndiPort = 1099;
        @Tag(value="base-directory-name")
        private String myBaseDirectoryName;
        @AbstractCollection
        private List<JettyConfigFile> myConfigFiles = JettyLocalModel.access$000();

        @Override
        public int getJndiPort() {
            return this.myJndiPort;
        }

        @Override
        public void setJndiPort(int jndiPort) {
            this.myJndiPort = jndiPort;
        }

        public List<JettyConfigFile> getConfigFiles() {
            return this.myConfigFiles;
        }

        public void setConfigFiles(List<JettyConfigFile> configFiles) {
            this.myConfigFiles = configFiles;
        }

        public String getBaseDirectoryName() {
            return this.myBaseDirectoryName;
        }

        public void setBaseDirectoryName(String baseDirectoryName) {
            this.myBaseDirectoryName = baseDirectoryName;
        }
    }
}

